/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.client.model;

import com.github.tartaricacid.touhoulittlemaid.client.model.ModelBoxFloat;
import com.github.tartaricacid.touhoulittlemaid.client.model.pojo.BonesItem;
import com.github.tartaricacid.touhoulittlemaid.client.model.pojo.CubesItem;
import com.github.tartaricacid.touhoulittlemaid.client.model.pojo.CustomModelPOJO;
import com.github.tartaricacid.touhoulittlemaid.config.GeneralConfig;
import com.github.tartaricacid.touhoulittlemaid.entity.item.EntityChair;
import com.github.tartaricacid.touhoulittlemaid.entity.item.EntityMarisaBroom;
import com.github.tartaricacid.touhoulittlemaid.entity.item.EntitySuitcase;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.model.ModelBase;
import net.minecraft.client.model.ModelRenderer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.entity.Entity;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumHandSide;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class EntityModelJson
extends ModelBase {
    public final AxisAlignedBB renderBoundingBox;
    private final int format;
    private HashMap<String, ModelRenderer> modelMap = new HashMap();
    private HashMap<String, BonesItem> indexBones = new HashMap();
    private List<ModelRenderer> shouldRender = new LinkedList<ModelRenderer>();

    public EntityModelJson(CustomModelPOJO pojo, int format) {
        this.format = format;
        this.field_78090_t = pojo.getGeometryModel().getTexturewidth();
        this.field_78089_u = pojo.getGeometryModel().getTextureheight();
        List<Float> offset = pojo.getGeometryModel().getVisibleBoundsOffset();
        float offsetX = offset.get(0).floatValue();
        float offsetY = offset.get(1).floatValue();
        float offsetZ = offset.get(2).floatValue();
        float width = pojo.getGeometryModel().getVisibleBoundsWidth() / 2;
        float height = pojo.getGeometryModel().getVisibleBoundsHeight() / 2;
        this.renderBoundingBox = new AxisAlignedBB((double)(offsetX - width), (double)(offsetY - height), (double)(offsetZ - width), (double)(offsetX + width), (double)(offsetY + height), (double)(offsetZ + width));
        for (BonesItem bones : pojo.getGeometryModel().getBones()) {
            this.indexBones.put(bones.getName(), bones);
            this.modelMap.put(bones.getName(), new ModelRenderer((ModelBase)this));
        }
        for (BonesItem bones : pojo.getGeometryModel().getBones()) {
            String name = bones.getName();
            List<Float> rotation = bones.getRotation();
            String parent = bones.getParent();
            ModelRenderer model = this.modelMap.get(name);
            model.func_78793_a(this.convertPivot(bones, 0), this.convertPivot(bones, 1), this.convertPivot(bones, 2));
            if (rotation != null) {
                this.setRotationAngle(model, this.convertRotation(rotation.get(0).floatValue()), this.convertRotation(rotation.get(1).floatValue()), this.convertRotation(rotation.get(2).floatValue()));
            }
            if (parent != null) {
                this.modelMap.get(parent).func_78792_a(model);
            } else {
                this.shouldRender.add(model);
            }
            if (bones.getCubes() == null) continue;
            for (CubesItem cubes : bones.getCubes()) {
                List<Integer> uv = cubes.getUv();
                List<Float> size = cubes.getSize();
                boolean mirror = cubes.isMirror();
                float inflate = cubes.getInflate();
                model.field_78804_l.add(new ModelBoxFloat(model, uv.get(0), uv.get(1), this.convertOrigin(bones, cubes, 0), this.convertOrigin(bones, cubes, 1), this.convertOrigin(bones, cubes, 2), size.get(0).floatValue(), size.get(1).floatValue(), size.get(2).floatValue(), inflate, mirror));
            }
        }
    }

    public void func_78088_a(Entity entityIn, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch, float scale) {
        if (this.format >= 1) {
            GlStateManager.func_179089_o();
        }
        for (ModelRenderer model : this.shouldRender) {
            model.func_78785_a(scale);
        }
        if (this.format >= 1) {
            GlStateManager.func_179129_p();
        }
    }

    public void func_78087_a(float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch, float scaleFactor, Entity entityIn) {
        if (entityIn instanceof EntityMaid) {
            this.setMaidRotationAngles(limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch, scaleFactor, (EntityMaid)entityIn);
            return;
        }
        if (entityIn instanceof EntityChair) {
            this.setChairRotationAngles(limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch, scaleFactor, (EntityChair)entityIn);
        }
    }

    private void setMaidRotationAngles(float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch, float scaleFactor, EntityMaid entityMaid) {
        ModelRenderer head = this.modelMap.get("head");
        ModelRenderer legLeft = this.modelMap.get("legLeft");
        ModelRenderer legRight = this.modelMap.get("legRight");
        ModelRenderer armLeft = this.modelMap.get("armLeft");
        ModelRenderer armRight = this.modelMap.get("armRight");
        ModelRenderer wingLeft = this.modelMap.get("wingLeft");
        ModelRenderer wingRight = this.modelMap.get("wingRight");
        ModelRenderer ahoge = this.modelMap.get("ahoge");
        ModelRenderer blink = this.modelMap.get("blink");
        ModelRenderer tail = this.modelMap.get("tail");
        ModelRenderer sinFloat = this.modelMap.get("sinFloat");
        ModelRenderer cosFloat = this.modelMap.get("cosFloat");
        ModelRenderer negativeSinFloat = this.modelMap.get("-sinFloat");
        ModelRenderer negativeCosFloat = this.modelMap.get("-cosFloat");
        ModelRenderer negativeSinFloat2 = this.modelMap.get("_sinFloat");
        ModelRenderer negativeCosFloat2 = this.modelMap.get("_cosFloat");
        ModelRenderer helmet = this.modelMap.get("helmet");
        ModelRenderer hat = this.modelMap.get("hat");
        ModelRenderer chestPlate = this.modelMap.get("chestPlate");
        ModelRenderer chestPlateLeft = this.modelMap.get("chestPlateLeft");
        ModelRenderer chestPlateMiddle = this.modelMap.get("chestPlateMiddle");
        ModelRenderer chestPlateRight = this.modelMap.get("chestPlateRight");
        ModelRenderer leggings = this.modelMap.get("leggings");
        ModelRenderer leggingsLeft = this.modelMap.get("leggingsLeft");
        ModelRenderer leggingsMiddle = this.modelMap.get("leggingsMiddle");
        ModelRenderer leggingsRight = this.modelMap.get("leggingsRight");
        ModelRenderer bootsLeft = this.modelMap.get("bootsLeft");
        ModelRenderer bootsRight = this.modelMap.get("bootsRight");
        ModelRenderer reverseHelmet = this.modelMap.get("-helmet");
        ModelRenderer reverseHat = this.modelMap.get("-hat");
        ModelRenderer reverseChestPlate = this.modelMap.get("-chestPlate");
        ModelRenderer reverseChestPlateLeft = this.modelMap.get("-chestPlateLeft");
        ModelRenderer reverseChestPlateMiddle = this.modelMap.get("-chestPlateMiddle");
        ModelRenderer reverseChestPlateRight = this.modelMap.get("-chestPlateRight");
        ModelRenderer reverseLeggings = this.modelMap.get("-leggings");
        ModelRenderer reverseLeggingsLeft = this.modelMap.get("-leggingsLeft");
        ModelRenderer reverseLeggingsMiddle = this.modelMap.get("-leggingsMiddle");
        ModelRenderer reverseLeggingsRight = this.modelMap.get("-leggingsRight");
        ModelRenderer reverseBootsLeft = this.modelMap.get("-bootsLeft");
        ModelRenderer reverseBootsRight = this.modelMap.get("-bootsRight");
        ModelRenderer reverseHelmet2 = this.modelMap.get("_helmet");
        ModelRenderer reverseHat2 = this.modelMap.get("_hat");
        ModelRenderer reverseChestPlate2 = this.modelMap.get("_chestPlate");
        ModelRenderer reverseChestPlateLeft2 = this.modelMap.get("_chestPlateLeft");
        ModelRenderer reverseChestPlateMiddle2 = this.modelMap.get("_chestPlateMiddle");
        ModelRenderer reverseChestPlateRight2 = this.modelMap.get("_chestPlateRight");
        ModelRenderer reverseLeggings2 = this.modelMap.get("_leggings");
        ModelRenderer reverseLeggingsLeft2 = this.modelMap.get("_leggingsLeft");
        ModelRenderer reverseLeggingsMiddle2 = this.modelMap.get("_leggingsMiddle");
        ModelRenderer reverseLeggingsRight2 = this.modelMap.get("_leggingsRight");
        ModelRenderer reverseBootsLeft2 = this.modelMap.get("_bootsLeft");
        ModelRenderer reverseBootsRight2 = this.modelMap.get("_bootsRight");
        this.headAnimation(head, netHeadYaw, headPitch);
        this.legAnimation(legLeft, legRight, limbSwing, limbSwingAmount);
        this.armAnimation(entityMaid, armLeft, armRight, limbSwing, limbSwingAmount, ageInTicks);
        this.wingAnimation(wingLeft, wingRight, ageInTicks);
        this.blinkAnimation(blink, ageInTicks);
        this.tailAnimation(tail, ageInTicks);
        this.floatAnimation(sinFloat, cosFloat, negativeSinFloat, negativeCosFloat, negativeSinFloat2, negativeCosFloat2, ageInTicks);
        this.renderArmor(entityMaid, helmet, hat, chestPlate, chestPlateLeft, chestPlateMiddle, chestPlateRight, leggings, leggingsLeft, leggingsMiddle, leggingsRight, bootsLeft, bootsRight);
        this.renderReverseArmor(entityMaid, reverseHelmet, reverseHat, reverseChestPlate, reverseChestPlateLeft, reverseChestPlateMiddle, reverseChestPlateRight, reverseLeggings, reverseLeggingsLeft, reverseLeggingsMiddle, reverseLeggingsRight, reverseBootsLeft, reverseBootsRight);
        this.renderReverseArmor(entityMaid, reverseHelmet2, reverseHat2, reverseChestPlate2, reverseChestPlateLeft2, reverseChestPlateMiddle2, reverseChestPlateRight2, reverseLeggings2, reverseLeggingsLeft2, reverseLeggingsMiddle2, reverseLeggingsRight2, reverseBootsLeft2, reverseBootsRight2);
        this.beggingPosture(entityMaid, head, ahoge, ageInTicks);
        this.swingingArmsPosture(entityMaid, armLeft, armRight);
        if (head != null) {
            head.field_82908_p = 0.0f;
        }
        if (entityMaid.func_184179_bs() instanceof EntityMarisaBroom || entityMaid.isDebugBroomShow) {
            this.ridingBroomPosture(head, armLeft, armRight, legLeft, legRight);
        } else if (entityMaid.func_184218_aH()) {
            this.ridingPosture(legLeft, legRight);
        } else if (entityMaid.func_70906_o()) {
            this.sittingPosture(armLeft, armRight, legLeft, legRight);
        }
    }

    private void headAnimation(@Nullable ModelRenderer head, float netHeadYaw, float headPitch) {
        if (head != null) {
            head.field_78795_f = headPitch * ((float)Math.PI / 180);
            head.field_78796_g = netHeadYaw * ((float)Math.PI / 180);
        }
    }

    private void legAnimation(@Nullable ModelRenderer legLeft, @Nullable ModelRenderer legRight, float limbSwing, float limbSwingAmount) {
        if (legLeft != null) {
            legLeft.field_78795_f = MathHelper.func_76134_b((float)(limbSwing * 0.67f)) * 0.3f * limbSwingAmount;
            legLeft.field_78808_h = 0.0f;
        }
        if (legRight != null) {
            legRight.field_78795_f = -MathHelper.func_76134_b((float)(limbSwing * 0.67f)) * 0.3f * limbSwingAmount;
            legRight.field_78808_h = 0.0f;
        }
    }

    private void armAnimation(EntityMaid entityMaid, @Nullable ModelRenderer armLeft, @Nullable ModelRenderer armRight, float limbSwing, float limbSwingAmount, float ageInTicks) {
        float f1 = 1.0f - this.field_78095_p;
        f1 *= f1;
        f1 *= f1;
        f1 = 1.0f - f1;
        float f2 = MathHelper.func_76126_a((float)(f1 * (float)Math.PI));
        float f3 = MathHelper.func_76126_a((float)(this.field_78095_p * (float)Math.PI)) * -0.7f * 0.75f;
        if (armLeft != null) {
            if (entityMaid.func_184179_bs() instanceof EntitySuitcase) {
                armLeft.field_78795_f = 0.5f;
                armLeft.field_78796_g = 0.0f;
                armLeft.field_78808_h = -0.395f;
            } else {
                armLeft.field_78795_f = -MathHelper.func_76134_b((float)(limbSwing * 0.67f)) * 0.7f * limbSwingAmount;
                armLeft.field_78796_g = 0.0f;
                armLeft.field_78808_h = MathHelper.func_76134_b((float)(ageInTicks * 0.05f)) * 0.05f - 0.4f;
                if (this.field_78095_p > 0.0f && this.getSwingingHand(entityMaid) == EnumHandSide.LEFT) {
                    armLeft.field_78795_f = (float)((double)armLeft.field_78795_f - ((double)f2 * 1.2 + (double)f3));
                    armLeft.field_78808_h += MathHelper.func_76126_a((float)(this.field_78095_p * (float)Math.PI)) * -0.4f;
                }
            }
        }
        if (armRight != null) {
            armRight.field_78795_f = MathHelper.func_76134_b((float)(limbSwing * 0.67f)) * 0.7f * limbSwingAmount;
            armRight.field_78796_g = 0.0f;
            armRight.field_78808_h = -MathHelper.func_76134_b((float)(ageInTicks * 0.05f)) * 0.05f + 0.4f;
            if (this.field_78095_p > 0.0f && this.getSwingingHand(entityMaid) == EnumHandSide.RIGHT) {
                armRight.field_78795_f = (float)((double)armRight.field_78795_f - ((double)f2 * 1.2 + (double)f3));
                armRight.field_78808_h += MathHelper.func_76126_a((float)(this.field_78095_p * (float)Math.PI)) * -0.4f;
            }
        }
    }

    private void wingAnimation(@Nullable ModelRenderer wingLeft, @Nullable ModelRenderer wingRight, float ageInTicks) {
        if (wingLeft != null) {
            wingLeft.field_78796_g = -MathHelper.func_76134_b((float)(ageInTicks * 0.3f)) * 0.2f + 1.0f;
        }
        if (wingRight != null) {
            wingRight.field_78796_g = MathHelper.func_76134_b((float)(ageInTicks * 0.3f)) * 0.2f - 1.0f;
        }
    }

    private void blinkAnimation(@Nullable ModelRenderer blink, float ageInTicks) {
        if (blink != null) {
            float remainder = ageInTicks % 60.0f;
            blink.field_78807_k = !(55.0f < remainder) || !(remainder < 60.0f);
        }
    }

    private void tailAnimation(@Nullable ModelRenderer tail, float ageInTicks) {
        if (tail != null) {
            tail.field_78808_h = MathHelper.func_76134_b((float)(ageInTicks * 0.2f)) * 0.1f;
            tail.field_78795_f = MathHelper.func_76126_a((float)(ageInTicks * 0.2f)) * 0.05f;
        }
    }

    private void floatAnimation(@Nullable ModelRenderer sinFloat, @Nullable ModelRenderer cosFloat, @Nullable ModelRenderer negativeSinFloat, @Nullable ModelRenderer negativeCosFloat, @Nullable ModelRenderer negativeSinFloat2, @Nullable ModelRenderer negativeCosFloat2, float ageInTicks) {
        if (sinFloat != null) {
            sinFloat.field_82908_p = MathHelper.func_76126_a((float)(ageInTicks * 0.1f)) * 0.05f;
        }
        if (cosFloat != null) {
            cosFloat.field_82908_p = MathHelper.func_76134_b((float)(ageInTicks * 0.1f)) * 0.05f;
        }
        if (negativeSinFloat != null) {
            negativeSinFloat.field_82908_p = -MathHelper.func_76126_a((float)(ageInTicks * 0.1f)) * 0.05f;
        }
        if (negativeSinFloat2 != null) {
            negativeSinFloat2.field_82908_p = -MathHelper.func_76126_a((float)(ageInTicks * 0.1f)) * 0.05f;
        }
        if (negativeCosFloat != null) {
            negativeCosFloat.field_82908_p = -MathHelper.func_76134_b((float)(ageInTicks * 0.1f)) * 0.05f;
        }
        if (negativeCosFloat2 != null) {
            negativeCosFloat2.field_82908_p = -MathHelper.func_76134_b((float)(ageInTicks * 0.1f)) * 0.05f;
        }
    }

    private void renderArmor(EntityMaid entityMaid, @Nullable ModelRenderer helmet, @Nullable ModelRenderer hat, @Nullable ModelRenderer chestPlate, @Nullable ModelRenderer chestPlateLeft, @Nullable ModelRenderer chestPlateMiddle, @Nullable ModelRenderer chestPlateRight, @Nullable ModelRenderer leggings, @Nullable ModelRenderer leggingsLeft, @Nullable ModelRenderer leggingsMiddle, @Nullable ModelRenderer leggingsRight, @Nullable ModelRenderer bootsLeft, @Nullable ModelRenderer bootsRight) {
        if (helmet != null) {
            helmet.field_78807_k = entityMaid.func_184582_a(EntityEquipmentSlot.HEAD).func_190926_b();
        }
        if (hat != null) {
            boolean bl = hat.field_78807_k = !GeneralConfig.MAID_CONFIG.maidAlwaysShowHat && entityMaid.func_184582_a(EntityEquipmentSlot.HEAD).func_190926_b();
        }
        if (chestPlate != null) {
            chestPlate.field_78807_k = entityMaid.func_184582_a(EntityEquipmentSlot.CHEST).func_190926_b();
        }
        if (chestPlateLeft != null) {
            chestPlateLeft.field_78807_k = entityMaid.func_184582_a(EntityEquipmentSlot.CHEST).func_190926_b();
        }
        if (chestPlateMiddle != null) {
            chestPlateMiddle.field_78807_k = entityMaid.func_184582_a(EntityEquipmentSlot.CHEST).func_190926_b();
        }
        if (chestPlateRight != null) {
            chestPlateRight.field_78807_k = entityMaid.func_184582_a(EntityEquipmentSlot.CHEST).func_190926_b();
        }
        if (leggings != null) {
            leggings.field_78807_k = entityMaid.func_184582_a(EntityEquipmentSlot.LEGS).func_190926_b();
        }
        if (leggingsLeft != null) {
            leggingsLeft.field_78807_k = entityMaid.func_184582_a(EntityEquipmentSlot.LEGS).func_190926_b();
        }
        if (leggingsMiddle != null) {
            leggingsMiddle.field_78807_k = entityMaid.func_184582_a(EntityEquipmentSlot.LEGS).func_190926_b();
        }
        if (leggingsRight != null) {
            leggingsRight.field_78807_k = entityMaid.func_184582_a(EntityEquipmentSlot.LEGS).func_190926_b();
        }
        if (bootsLeft != null) {
            bootsLeft.field_78807_k = entityMaid.func_184582_a(EntityEquipmentSlot.FEET).func_190926_b();
        }
        if (bootsRight != null) {
            bootsRight.field_78807_k = entityMaid.func_184582_a(EntityEquipmentSlot.FEET).func_190926_b();
        }
    }

    private void renderReverseArmor(EntityMaid entityMaid, @Nullable ModelRenderer reverseHelmet, @Nullable ModelRenderer reverseHat, @Nullable ModelRenderer reverseChestPlate, @Nullable ModelRenderer reverseChestPlateLeft, @Nullable ModelRenderer reverseChestPlateMiddle, @Nullable ModelRenderer reverseChestPlateRight, @Nullable ModelRenderer reverseLeggings, @Nullable ModelRenderer reverseLeggingsLeft, @Nullable ModelRenderer reverseLeggingsMiddle, @Nullable ModelRenderer reverseLeggingsRight, @Nullable ModelRenderer reverseBootsLeft, @Nullable ModelRenderer reverseBootsRight) {
        if (reverseHelmet != null) {
            boolean bl = reverseHelmet.field_78807_k = !entityMaid.func_184582_a(EntityEquipmentSlot.HEAD).func_190926_b();
        }
        if (reverseHat != null) {
            boolean bl = reverseHat.field_78807_k = GeneralConfig.MAID_CONFIG.maidAlwaysShowHat || !entityMaid.func_184582_a(EntityEquipmentSlot.HEAD).func_190926_b();
        }
        if (reverseChestPlate != null) {
            boolean bl = reverseChestPlate.field_78807_k = !entityMaid.func_184582_a(EntityEquipmentSlot.CHEST).func_190926_b();
        }
        if (reverseChestPlateLeft != null) {
            boolean bl = reverseChestPlateLeft.field_78807_k = !entityMaid.func_184582_a(EntityEquipmentSlot.CHEST).func_190926_b();
        }
        if (reverseChestPlateMiddle != null) {
            boolean bl = reverseChestPlateMiddle.field_78807_k = !entityMaid.func_184582_a(EntityEquipmentSlot.CHEST).func_190926_b();
        }
        if (reverseChestPlateRight != null) {
            boolean bl = reverseChestPlateRight.field_78807_k = !entityMaid.func_184582_a(EntityEquipmentSlot.CHEST).func_190926_b();
        }
        if (reverseLeggings != null) {
            boolean bl = reverseLeggings.field_78807_k = !entityMaid.func_184582_a(EntityEquipmentSlot.LEGS).func_190926_b();
        }
        if (reverseLeggingsLeft != null) {
            boolean bl = reverseLeggingsLeft.field_78807_k = !entityMaid.func_184582_a(EntityEquipmentSlot.LEGS).func_190926_b();
        }
        if (reverseLeggingsMiddle != null) {
            boolean bl = reverseLeggingsMiddle.field_78807_k = !entityMaid.func_184582_a(EntityEquipmentSlot.LEGS).func_190926_b();
        }
        if (reverseLeggingsRight != null) {
            boolean bl = reverseLeggingsRight.field_78807_k = !entityMaid.func_184582_a(EntityEquipmentSlot.LEGS).func_190926_b();
        }
        if (reverseBootsLeft != null) {
            boolean bl = reverseBootsLeft.field_78807_k = !entityMaid.func_184582_a(EntityEquipmentSlot.FEET).func_190926_b();
        }
        if (reverseBootsRight != null) {
            reverseBootsRight.field_78807_k = !entityMaid.func_184582_a(EntityEquipmentSlot.FEET).func_190926_b();
        }
    }

    private void beggingPosture(EntityMaid entityMaid, @Nullable ModelRenderer head, @Nullable ModelRenderer ahoge, float ageInTicks) {
        if (entityMaid.isBegging()) {
            if (head != null) {
                head.field_78808_h = 0.139f;
            }
            if (ahoge != null) {
                ahoge.field_78795_f = MathHelper.func_76134_b((float)(ageInTicks * 1.0f)) * 0.05f;
                ahoge.field_78808_h = MathHelper.func_76126_a((float)(ageInTicks * 1.0f)) * 0.05f;
            }
        } else {
            if (head != null) {
                head.field_78808_h = 0.0f;
            }
            if (ahoge != null) {
                ahoge.field_78808_h = 0.0f;
            }
        }
    }

    private void swingingArmsPosture(EntityMaid entityMaid, @Nullable ModelRenderer armLeft, @Nullable ModelRenderer armRight) {
        if (entityMaid.isSwingingArms()) {
            if (armLeft != null) {
                armLeft.field_78795_f = -1.396f;
                armLeft.field_78796_g = 0.785f;
            }
            if (armRight != null) {
                armRight.field_78795_f = -1.396f;
                armRight.field_78796_g = -0.174f;
            }
        }
    }

    private void sittingPosture(@Nullable ModelRenderer armLeft, @Nullable ModelRenderer armRight, @Nullable ModelRenderer legLeft, @Nullable ModelRenderer legRight) {
        if (armLeft != null) {
            armLeft.field_78795_f = -0.798f;
            armLeft.field_78808_h = 0.274f;
        }
        if (armRight != null) {
            armRight.field_78795_f = -0.798f;
            armRight.field_78808_h = -0.274f;
        }
        if (legLeft != null) {
            legLeft.field_78795_f = -0.96f;
            legLeft.field_78808_h = -0.523f;
        }
        if (legRight != null) {
            legRight.field_78795_f = -0.96f;
            legRight.field_78808_h = 0.523f;
        }
        GlStateManager.func_179109_b((float)0.0f, (float)0.3f, (float)0.0f);
    }

    private void ridingBroomPosture(@Nullable ModelRenderer head, @Nullable ModelRenderer armLeft, @Nullable ModelRenderer armRight, @Nullable ModelRenderer legLeft, @Nullable ModelRenderer legRight) {
        this.sittingPosture(armLeft, armRight, legLeft, legRight);
        if (head != null) {
            head.field_78795_f -= 0.5235988f;
            head.field_82908_p = 0.0625f;
        }
        GlStateManager.func_179114_b((float)30.0f, (float)1.0f, (float)0.0f, (float)0.0f);
        GlStateManager.func_179137_b((double)0.0, (double)-0.4, (double)-0.3);
    }

    private void ridingPosture(@Nullable ModelRenderer legLeft, @Nullable ModelRenderer legRight) {
        if (legLeft != null) {
            legLeft.field_78795_f = -0.96f;
            legLeft.field_78808_h = -0.523f;
        }
        if (legRight != null) {
            legRight.field_78795_f = -0.96f;
            legRight.field_78808_h = 0.523f;
        }
        GlStateManager.func_179109_b((float)0.0f, (float)0.3f, (float)0.0f);
    }

    private void setChairRotationAngles(float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch, float scaleFactor, EntityChair entityChair) {
        ModelRenderer rRotationX5 = this.modelMap.get("rRotationX5");
        ModelRenderer rRotationX10 = this.modelMap.get("rRotationX10");
        ModelRenderer rRotationX20 = this.modelMap.get("rRotationX20");
        ModelRenderer rRotationY5 = this.modelMap.get("rRotationY5");
        ModelRenderer rRotationY10 = this.modelMap.get("rRotationY10");
        ModelRenderer rRotationY20 = this.modelMap.get("rRotationY20");
        ModelRenderer rRotationZ5 = this.modelMap.get("rRotationZ5");
        ModelRenderer rRotationZ10 = this.modelMap.get("rRotationZ10");
        ModelRenderer rRotationZ20 = this.modelMap.get("rRotationZ20");
        ModelRenderer lRotationX5 = this.modelMap.get("lRotationX5");
        ModelRenderer lRotationX10 = this.modelMap.get("lRotationX10");
        ModelRenderer lRotationX20 = this.modelMap.get("lRotationX20");
        ModelRenderer lRotationY5 = this.modelMap.get("lRotationY5");
        ModelRenderer lRotationY10 = this.modelMap.get("lRotationY10");
        ModelRenderer lRotationY20 = this.modelMap.get("lRotationY20");
        ModelRenderer lRotationZ5 = this.modelMap.get("lRotationZ5");
        ModelRenderer lRotationZ10 = this.modelMap.get("lRotationZ10");
        ModelRenderer lRotationZ20 = this.modelMap.get("lRotationZ20");
        if (rRotationX5 != null) {
            rRotationX5.field_78795_f = ageInTicks * 3.6f * ((float)Math.PI / 180);
        }
        if (rRotationX10 != null) {
            rRotationX10.field_78795_f = ageInTicks * 1.8f * ((float)Math.PI / 180);
        }
        if (rRotationX20 != null) {
            rRotationX20.field_78795_f = ageInTicks * 0.9f * ((float)Math.PI / 180);
        }
        if (rRotationY5 != null) {
            rRotationY5.field_78796_g = ageInTicks * 3.6f * ((float)Math.PI / 180);
        }
        if (rRotationY10 != null) {
            rRotationY10.field_78796_g = ageInTicks * 1.8f * ((float)Math.PI / 180);
        }
        if (rRotationY20 != null) {
            rRotationY20.field_78796_g = ageInTicks * 0.9f * ((float)Math.PI / 180);
        }
        if (rRotationZ5 != null) {
            rRotationZ5.field_78808_h = ageInTicks * 3.6f * ((float)Math.PI / 180);
        }
        if (rRotationZ10 != null) {
            rRotationZ10.field_78808_h = ageInTicks * 1.8f * ((float)Math.PI / 180);
        }
        if (rRotationZ20 != null) {
            rRotationZ20.field_78808_h = ageInTicks * 0.9f * ((float)Math.PI / 180);
        }
        if (lRotationX5 != null) {
            lRotationX5.field_78795_f = -ageInTicks * 3.6f * ((float)Math.PI / 180);
        }
        if (lRotationX10 != null) {
            lRotationX10.field_78795_f = -ageInTicks * 1.8f * ((float)Math.PI / 180);
        }
        if (lRotationX20 != null) {
            lRotationX20.field_78795_f = -ageInTicks * 0.9f * ((float)Math.PI / 180);
        }
        if (lRotationY5 != null) {
            lRotationY5.field_78796_g = -ageInTicks * 3.6f * ((float)Math.PI / 180);
        }
        if (lRotationY10 != null) {
            lRotationY10.field_78796_g = -ageInTicks * 1.8f * ((float)Math.PI / 180);
        }
        if (lRotationY20 != null) {
            lRotationY20.field_78796_g = -ageInTicks * 0.9f * ((float)Math.PI / 180);
        }
        if (lRotationZ5 != null) {
            lRotationZ5.field_78808_h = -ageInTicks * 3.6f * ((float)Math.PI / 180);
        }
        if (lRotationZ10 != null) {
            lRotationZ10.field_78808_h = -ageInTicks * 1.8f * ((float)Math.PI / 180);
        }
        if (lRotationZ20 != null) {
            lRotationZ20.field_78808_h = -ageInTicks * 0.9f * ((float)Math.PI / 180);
        }
    }

    private void setRotationAngle(ModelRenderer modelRenderer, float x, float y, float z) {
        modelRenderer.field_78795_f = x;
        modelRenderer.field_78796_g = y;
        modelRenderer.field_78808_h = z;
    }

    public boolean hasBackpackPositioningModel() {
        return this.modelMap.get("backpackPositioningBone") != null;
    }

    public ModelRenderer getBackpackPositioningModel() {
        return this.modelMap.get("backpackPositioningBone");
    }

    public boolean hasArmPositioningModel(EnumHandSide side) {
        ModelRenderer arm = side == EnumHandSide.LEFT ? this.modelMap.get("armLeftPositioningBone") : this.modelMap.get("armRightPositioningBone");
        return arm != null;
    }

    public void postRenderArmPositioningModel(float scale, EnumHandSide side) {
        ModelRenderer arm;
        ModelRenderer modelRenderer = arm = side == EnumHandSide.LEFT ? this.modelMap.get("armLeftPositioningBone") : this.modelMap.get("armRightPositioningBone");
        if (arm != null) {
            arm.func_78794_c(scale);
        }
    }

    public void postRenderArm(float scale, EnumHandSide side) {
        ModelRenderer arm;
        ModelRenderer modelRenderer = arm = side == EnumHandSide.LEFT ? this.modelMap.get("armLeft") : this.modelMap.get("armRight");
        if (arm != null) {
            arm.func_78794_c(scale);
        }
    }

    public void postRenderCustomHead(float scale) {
        ModelRenderer customHead = this.modelMap.get("head");
        if (customHead != null) {
            customHead.func_78794_c(scale);
        }
    }

    private EnumHandSide getSwingingHand(EntityMaid entityIn) {
        return entityIn.field_184622_au == EnumHand.MAIN_HAND ? EnumHandSide.RIGHT : EnumHandSide.LEFT;
    }

    private float convertPivot(BonesItem bones, int index) {
        if (bones.getParent() != null) {
            if (index == 1) {
                return this.indexBones.get(bones.getParent()).getPivot().get(index).floatValue() - bones.getPivot().get(index).floatValue();
            }
            return bones.getPivot().get(index).floatValue() - this.indexBones.get(bones.getParent()).getPivot().get(index).floatValue();
        }
        if (index == 1) {
            return 24.0f - bones.getPivot().get(index).floatValue();
        }
        return bones.getPivot().get(index).floatValue();
    }

    private float convertOrigin(BonesItem bones, CubesItem cubes, int index) {
        if (index == 1) {
            return bones.getPivot().get(index).floatValue() - cubes.getOrigin().get(index).floatValue() - cubes.getSize().get(index).floatValue();
        }
        return cubes.getOrigin().get(index).floatValue() - bones.getPivot().get(index).floatValue();
    }

    private float convertRotation(float degree) {
        return (float)((double)degree * Math.PI / 180.0);
    }
}

