/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.client.gui.skin;

import com.github.tartaricacid.touhoulittlemaid.client.gui.skin.AbstractSkinGui;
import com.github.tartaricacid.touhoulittlemaid.client.gui.skin.ChairSkinDetailsGui;
import com.github.tartaricacid.touhoulittlemaid.client.resources.pojo.ModelItem;
import com.github.tartaricacid.touhoulittlemaid.entity.item.EntityChair;
import com.github.tartaricacid.touhoulittlemaid.network.simpleimpl.ApplyChairSkinDataMessage;
import com.github.tartaricacid.touhoulittlemaid.proxy.ClientProxy;
import com.github.tartaricacid.touhoulittlemaid.proxy.CommonProxy;
import java.util.concurrent.ExecutionException;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.inventory.GuiInventory;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class ChairSkinGui
extends AbstractSkinGui<EntityChair> {
    private static int PACK_INDEX = 0;
    private static int PAGE_INDEX = 0;

    public ChairSkinGui(EntityChair chair) {
        super(chair, ClientProxy.CHAIR_MODEL.getPackList(), "touhou_little_maid:entity.item.chair");
    }

    @Override
    void drawLeftEntity(int middleX, int middleY, float mouseX, float mouseY) {
        float renderItemScale = ClientProxy.CHAIR_MODEL.getModelRenderItemScale(((EntityChair)this.entity).getModelId());
        GuiInventory.func_147046_a((int)(middleX - 190), (int)(middleY + 80), (int)((int)(45.0f * renderItemScale)), (float)-25.0f, (float)-20.0f, (EntityLivingBase)this.entity);
    }

    @Override
    void drawRightEntity(int posX, int posY, ModelItem modelItem) {
        EntityChair chair;
        try {
            chair = (EntityChair)((Object)ClientProxy.ENTITY_CACHE.get((Object)ENTITY_ID, () -> {
                Entity e = EntityList.func_188429_b((ResourceLocation)new ResourceLocation(ENTITY_ID), (World)this.field_146297_k.field_71441_e);
                if (e == null) {
                    return new EntityChair((World)this.field_146297_k.field_71441_e);
                }
                return e;
            }));
        }
        catch (ClassCastException | ExecutionException e) {
            e.printStackTrace();
            return;
        }
        chair.setModelId(modelItem.getModelId().toString());
        GuiInventory.func_147046_a((int)posX, (int)posY, (int)((int)(12.0f * modelItem.getRenderItemScale())), (float)-25.0f, (float)-20.0f, (EntityLivingBase)chair);
    }

    @Override
    void openDetailsGui(EntityChair chair, ResourceLocation modelId) {
        this.field_146297_k.func_152344_a(() -> this.field_146297_k.func_147108_a((GuiScreen)new ChairSkinDetailsGui(chair, modelId)));
    }

    @Override
    void notifyModelChange(EntityChair chair, ResourceLocation modelId) {
        float mountedYOffset = ClientProxy.CHAIR_MODEL.getModelMountedYOffset(modelId.toString());
        boolean isTameableCanRide = ClientProxy.CHAIR_MODEL.getModelTameableCanRide(modelId.toString());
        boolean isNoGravity = ClientProxy.CHAIR_MODEL.getModelNoGravity(modelId.toString());
        CommonProxy.INSTANCE.sendToServer((IMessage)new ApplyChairSkinDataMessage(chair.func_110124_au(), modelId, mountedYOffset, isTameableCanRide, isNoGravity));
    }

    @Override
    int getPackIndex() {
        return PACK_INDEX;
    }

    @Override
    void setPackIndex(int packIndex) {
        PACK_INDEX = packIndex;
    }

    @Override
    int getPageIndex() {
        return PAGE_INDEX;
    }

    @Override
    void setPageIndex(int pageIndex) {
        PAGE_INDEX = pageIndex;
    }
}

