/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.client.gui.skin;

import com.github.tartaricacid.touhoulittlemaid.client.gui.skin.AbstractSkinDetailsGui;
import com.github.tartaricacid.touhoulittlemaid.client.gui.skin.ChairSkinGui;
import com.github.tartaricacid.touhoulittlemaid.entity.item.EntityChair;
import com.github.tartaricacid.touhoulittlemaid.network.simpleimpl.ApplyChairSkinDataMessage;
import com.github.tartaricacid.touhoulittlemaid.proxy.ClientProxy;
import com.github.tartaricacid.touhoulittlemaid.proxy.CommonProxy;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiButtonToggle;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class ChairSkinDetailsGui
extends AbstractSkinDetailsGui<EntityChair> {
    private GuiButtonToggle characterButton;
    private ResourceLocation modelId;
    private GuiButton setGravityButton;

    public ChairSkinDetailsGui(EntityChair sourceEntity, ResourceLocation modelId) {
        super(sourceEntity, new EntityChair(sourceEntity.field_70170_p), ClientProxy.CHAIR_MODEL.getInfo(modelId.toString()).orElseThrow(NullPointerException::new));
        this.modelId = modelId;
        ((EntityChair)this.guiEntity).setModelId(modelId.toString());
        ((EntityChair)this.guiEntity).setMountedHeight(this.modelItem.getMountedYOffset());
        ((EntityChair)this.guiEntity).setTameableCanRide(this.modelItem.isTameableCanRide());
        ((EntityChair)this.guiEntity).func_189654_d(this.modelItem.isNoGravity());
        ((EntityChair)this.guiEntity).isDebugFloorOpen = true;
    }

    @Override
    void initSideButton() {
        this.func_189646_b(new GuiButton(BUTTON.APPLY_DATA.ordinal(), 2, 18, 128, 20, I18n.func_135052_a((String)"gui.touhou_little_maid.skin_details.apply_data", (Object[])new Object[0])));
        this.func_189646_b(new GuiButton(BUTTON.MIN_HEIGHT.ordinal(), 58, 40, 12, 12, "-"));
        this.func_189646_b(new GuiButton(BUTTON.ADD_HEIGHT.ordinal(), 118, 40, 12, 12, "+"));
        this.characterButton = new GuiButtonToggle(BUTTON.SHOW_CHARACTER.ordinal(), 2, 54, 128, 12, ((EntityChair)this.guiEntity).isDebugCharacterOpen);
        this.characterButton.func_191751_a(0, 0, 128, 12, BUTTON_TEXTURE);
        this.func_189646_b((GuiButton)this.characterButton);
        this.setGravityButton = new GuiButton(BUTTON.SET_GRAVITY.ordinal(), 2, 68, 128, 20, this.getGravityButtonText(((EntityChair)this.guiEntity).func_189652_ae()));
        this.func_189646_b(this.setGravityButton);
    }

    @Override
    void actionSideButtonPerformed(GuiButton button) {
        switch (BUTTON.getButtonFromOrdinal(button.field_146127_k)) {
            case APPLY_DATA: {
                CommonProxy.INSTANCE.sendToServer((IMessage)new ApplyChairSkinDataMessage(((EntityChair)this.sourceEntity).func_110124_au(), this.modelId, ((EntityChair)this.guiEntity).getMountedHeight(), ((EntityChair)this.guiEntity).isTameableCanRide(), ((EntityChair)this.guiEntity).func_189652_ae()));
                return;
            }
            case MIN_HEIGHT: {
                if (ChairSkinDetailsGui.func_146272_n()) {
                    ((EntityChair)this.guiEntity).setMountedHeight(((EntityChair)this.guiEntity).getMountedHeight() - 0.5f);
                } else {
                    ((EntityChair)this.guiEntity).setMountedHeight(((EntityChair)this.guiEntity).getMountedHeight() - 0.0625f);
                }
                return;
            }
            case ADD_HEIGHT: {
                if (ChairSkinDetailsGui.func_146272_n()) {
                    ((EntityChair)this.guiEntity).setMountedHeight(((EntityChair)this.guiEntity).getMountedHeight() + 0.5f);
                } else {
                    ((EntityChair)this.guiEntity).setMountedHeight(((EntityChair)this.guiEntity).getMountedHeight() + 0.0625f);
                }
                return;
            }
            case SHOW_CHARACTER: {
                this.applyShowCharacterLogic();
                return;
            }
            case SET_GRAVITY: {
                this.applySetGravityLogic();
                return;
            }
        }
    }

    @Override
    void applyFloorButtonLogic() {
        ((EntityChair)this.guiEntity).isDebugFloorOpen = !((EntityChair)this.guiEntity).isDebugFloorOpen;
    }

    @Override
    void applyReturnButtonLogic() {
        this.field_146297_k.func_152344_a(() -> this.field_146297_k.func_147108_a((GuiScreen)new ChairSkinGui((EntityChair)this.sourceEntity)));
    }

    @Override
    void drawSideButtonText() {
        this.field_146289_q.func_78276_b(I18n.func_135052_a((String)"gui.touhou_little_maid.skin_details.mounted_height", (Object[])new Object[0]), 5, 43, 13290196);
        String data = String.format("%.2f", Float.valueOf(((EntityChair)this.guiEntity).getMountedHeight() / 0.0625f + 3.0f));
        this.field_146289_q.func_78276_b(data, (188 - this.field_146289_q.func_78256_a(data)) / 2, 43, 13290196);
        this.field_146289_q.func_78276_b(I18n.func_135052_a((String)"gui.touhou_little_maid.skin_details.show_character", (Object[])new Object[0]), 16, 57, 13290196);
    }

    @Override
    void drawSideButtonTooltips(int mouseX, int mouseY) {
        boolean isInHeightRange;
        boolean isInWidthRange = 58 < mouseX && mouseX < 70 || 118 < mouseX && mouseX < 138;
        boolean bl = isInHeightRange = 40 < mouseY && mouseY < 60;
        if (isInWidthRange && isInHeightRange) {
            this.func_146279_a(I18n.func_135052_a((String)"gui.touhou_little_maid.skin_details.mounted_height.button.tooltips", (Object[])new Object[0]), mouseX, mouseY);
        }
    }

    private void applyShowCharacterLogic() {
        if (((EntityChair)this.guiEntity).isDebugCharacterOpen) {
            ((EntityChair)this.guiEntity).isDebugCharacterOpen = false;
            this.characterButton.func_191753_b(false);
        } else {
            ((EntityChair)this.guiEntity).isDebugCharacterOpen = true;
            this.characterButton.func_191753_b(true);
        }
    }

    private void applySetGravityLogic() {
        ((EntityChair)this.guiEntity).func_189654_d(!((EntityChair)this.guiEntity).func_189652_ae());
        this.setGravityButton.field_146126_j = this.getGravityButtonText(((EntityChair)this.guiEntity).func_189652_ae());
    }

    private String getGravityButtonText(boolean isNoGravity) {
        return I18n.func_135052_a((String)String.format("gui.touhou_little_maid.skin_details.set_gravity.button.%s", isNoGravity), (Object[])new Object[0]);
    }

    static enum BUTTON {
        MIN_HEIGHT,
        ADD_HEIGHT,
        SHOW_CHARACTER,
        APPLY_DATA,
        SET_GRAVITY;


        static BUTTON getButtonFromOrdinal(int ordinal) {
            for (BUTTON button : BUTTON.values()) {
                if (button.ordinal() != ordinal) continue;
                return button;
            }
            return ADD_HEIGHT;
        }
    }
}

