/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.client.gui.skin;

import com.github.tartaricacid.touhoulittlemaid.client.resources.pojo.CustomModelPackPOJO;
import com.github.tartaricacid.touhoulittlemaid.client.resources.pojo.ModelItem;
import com.github.tartaricacid.touhoulittlemaid.util.ParseI18n;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiButtonImage;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public abstract class AbstractSkinGui<T extends EntityLivingBase>
extends GuiScreen {
    private static final ResourceLocation BG = new ResourceLocation("touhou_little_maid", "textures/gui/skin_select.png");
    private static final HashMap<Integer, ModelItem> BUTTON_MODEL_MAP = Maps.newHashMap();
    private static final int PAGE_MAX_NUM = 44;
    protected static String ENTITY_ID;
    private static int PACK_COUNT;
    private static int PAGE_COUNT;
    private static List<CustomModelPackPOJO> MODEL_PACK_LIST;
    protected T entity;

    public AbstractSkinGui(T entity, List<CustomModelPackPOJO> listPack, String entityId) {
        this.entity = entity;
        MODEL_PACK_LIST = listPack;
        ENTITY_ID = entityId;
    }

    abstract void drawLeftEntity(int var1, int var2, float var3, float var4);

    abstract void drawRightEntity(int var1, int var2, ModelItem var3);

    abstract void openDetailsGui(T var1, ResourceLocation var2);

    abstract void notifyModelChange(T var1, ResourceLocation var2);

    abstract int getPackIndex();

    abstract void setPackIndex(int var1);

    abstract int getPageIndex();

    abstract void setPageIndex(int var1);

    public void func_73866_w_() {
        this.field_146292_n.clear();
        this.field_146293_o.clear();
        int i = this.field_146294_l / 2 + 50;
        int j = this.field_146295_m / 2 + 5;
        int id = 0;
        this.field_146292_n.add(new GuiButtonImage(id++, i - 118, j - 89, 11, 17, 15, 201, 18, BG));
        this.field_146292_n.add(new GuiButtonImage(id++, i + 107, j - 89, 11, 17, 1, 201, 18, BG));
        this.field_146292_n.add(new GuiButtonImage(id++, i - 118, j + 73, 11, 17, 15, 201, 18, BG));
        this.field_146292_n.add(new GuiButtonImage(id++, i + 107, j + 73, 11, 17, 1, 201, 18, BG));
        this.field_146292_n.add(new GuiButtonImage(id++, i + 104, j - 116, 21, 17, 58, 201, 18, BG));
        CustomModelPackPOJO pojo = MODEL_PACK_LIST.get(this.getPackIndex());
        int x = -100;
        int y = -35;
        int fromIndex = 44 * this.getPageIndex();
        int toIndex = 44 * (this.getPageIndex() + 1) > pojo.getModelList().size() ? pojo.getModelList().size() : 44 * (this.getPageIndex() + 1);
        for (ModelItem modelItem : pojo.getModelList().subList(fromIndex, toIndex)) {
            this.field_146292_n.add(new GuiButtonImage(id, i + x - 8, j + y - 23, 15, 24, 41, 201, 24, BG));
            BUTTON_MODEL_MAP.put(id, modelItem);
            ++id;
            if ((x += 20) <= 105) continue;
            x = -100;
            y += 30;
        }
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        PACK_COUNT = MODEL_PACK_LIST.size();
        if (this.getPackIndex() >= MODEL_PACK_LIST.size()) {
            this.setPackIndex(MODEL_PACK_LIST.size() - 1);
        }
        PAGE_COUNT = (MODEL_PACK_LIST.get(this.getPackIndex()).getModelList().size() - 1) / 44 + 1;
        int middleX = this.field_146294_l / 2 + 50;
        int middleY = this.field_146295_m / 2 + 5;
        this.func_146276_q_();
        this.field_146297_k.field_71446_o.func_110577_a(BG);
        this.func_73729_b(middleX - 128, middleY - 100, 0, 0, 256, 200);
        super.func_73863_a(mouseX, mouseY, partialTicks);
        this.drawLeftEntity(middleX, middleY, mouseX, mouseY);
        this.drawEntity(middleX, middleY);
        this.drawTooltips(mouseX, mouseY, middleX, middleY);
    }

    private void drawEntity(int middleX, int middleY) {
        CustomModelPackPOJO pojo = MODEL_PACK_LIST.get(this.getPackIndex());
        this.drawPackInfoText(pojo, middleX, middleY);
        int x = -100;
        int y = -35;
        int fromIndex = 44 * this.getPageIndex();
        int toIndex = 44 * (this.getPageIndex() + 1) > pojo.getModelList().size() ? pojo.getModelList().size() : 44 * (this.getPageIndex() + 1);
        for (ModelItem modelItem : pojo.getModelList().subList(fromIndex, toIndex)) {
            this.drawRightEntity(middleX + x, middleY + y, modelItem);
            if ((x += 20) <= 105) continue;
            x = -100;
            y += 30;
        }
    }

    private void drawPackInfoText(CustomModelPackPOJO pojo, int middleX, int middleY) {
        int offSet = -80;
        this.func_73732_a(this.field_146289_q, ParseI18n.parse(pojo.getPackName()), middleX - 193, middleY + offSet, 0xFFFFFF);
        for (String str : ParseI18n.parse(pojo.getDescription())) {
            this.func_73732_a(this.field_146289_q, TextFormatting.GRAY + str, middleX - 193, middleY + (offSet += 10), 0xFFFFFF);
        }
        if (!pojo.getAuthor().isEmpty()) {
            for (List textList : Lists.partition(pojo.getAuthor(), (int)2)) {
                this.func_73732_a(this.field_146289_q, TextFormatting.GOLD + textList.toString(), middleX - 193, middleY + (offSet += 10), 0xFFFFFF);
            }
        }
        if (pojo.getVersion() != null) {
            this.func_73732_a(this.field_146289_q, TextFormatting.DARK_AQUA + I18n.func_135052_a((String)"gui.touhou_little_maid.skin.text.version", (Object[])new Object[]{pojo.getVersion()}), middleX - 193, middleY + (offSet += 10), 0xFFFFFF);
        }
        if (pojo.getDate() != null) {
            this.func_73732_a(this.field_146289_q, TextFormatting.GREEN + I18n.func_135052_a((String)"gui.touhou_little_maid.skin.text.date", (Object[])new Object[]{pojo.getDate()}), middleX - 193, middleY + (offSet += 10), 0xFFFFFF);
        }
        this.func_73732_a(this.field_146289_q, String.format("%s/%s", this.getPackIndex() + 1, PACK_COUNT), middleX, middleY - 84, 0xFFFFFF);
        this.func_73732_a(this.field_146289_q, String.format("%s/%s", this.getPageIndex() + 1, PAGE_COUNT), middleX, middleY + 78, 0xFFFFFF);
    }

    private void drawTooltips(int mouseX, int mouseY, int middleX, int middleY) {
        boolean yInRange;
        CustomModelPackPOJO pojo = MODEL_PACK_LIST.get(this.getPackIndex());
        int x = -100;
        int y = -35;
        int fromIndex = 44 * this.getPageIndex();
        int toIndex = 44 * (this.getPageIndex() + 1) > pojo.getModelList().size() ? pojo.getModelList().size() : 44 * (this.getPageIndex() + 1);
        for (ModelItem modelItem : pojo.getModelList().subList(fromIndex, toIndex)) {
            boolean isyInRange;
            boolean isxInRange = middleX + x - 8 < mouseX && mouseX < middleX + x + 7;
            boolean bl = isyInRange = middleY + y - 23 < mouseY && mouseY < middleY + y + 1;
            if (isxInRange && isyInRange) {
                ArrayList<String> str = new ArrayList<String>();
                str.add(modelItem.getName());
                str.addAll(modelItem.getDescription());
                str.add(TextFormatting.DARK_GRAY.toString() + TextFormatting.ITALIC.toString() + I18n.func_135052_a((String)"gui.touhou_little_maid.skin.tooltips.show_details", (Object[])new Object[0]));
                this.func_146283_a(ParseI18n.parse(str), mouseX, mouseY);
            }
            if ((x += 20) <= 105) continue;
            x = -100;
            y += 30;
        }
        boolean xInRange = middleX + 104 < mouseX && mouseX < middleX + 125;
        boolean bl = yInRange = middleY - 116 < mouseY && mouseY < middleY - 99;
        if (xInRange && yInRange) {
            this.func_146279_a(I18n.func_135052_a((String)"gui.touhou_little_maid.skin.button.close", (Object[])new Object[0]), mouseX, mouseY);
        }
    }

    protected void func_146284_a(GuiButton button) {
        switch (button.field_146127_k) {
            case 0: {
                this.setPackIndex(this.getPackIndex() <= 0 ? PACK_COUNT - 1 : this.getPackIndex() - 1);
                this.setPageIndex(0);
                this.func_73866_w_();
                return;
            }
            case 1: {
                this.setPackIndex(this.getPackIndex() >= PACK_COUNT - 1 ? 0 : this.getPackIndex() + 1);
                this.setPageIndex(0);
                this.func_73866_w_();
                return;
            }
            case 2: {
                this.setPageIndex(this.getPageIndex() <= 0 ? PAGE_COUNT - 1 : this.getPageIndex() - 1);
                this.func_73866_w_();
                return;
            }
            case 3: {
                this.setPageIndex(this.getPageIndex() >= PAGE_COUNT - 1 ? 0 : this.getPageIndex() + 1);
                this.func_73866_w_();
                return;
            }
            case 4: {
                this.field_146297_k.func_152344_a(() -> this.field_146297_k.func_147108_a(null));
                return;
            }
        }
        if (AbstractSkinGui.func_146272_n()) {
            this.openDetailsGui(this.entity, BUTTON_MODEL_MAP.get(button.field_146127_k).getModelId());
        } else {
            this.notifyModelChange(this.entity, BUTTON_MODEL_MAP.get(button.field_146127_k).getModelId());
        }
    }

    public boolean func_73868_f() {
        return false;
    }

    static {
        PAGE_COUNT = 1;
        MODEL_PACK_LIST = Lists.newArrayList();
    }
}

