/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.client.gui.inventory;

import com.github.tartaricacid.touhoulittlemaid.TouhouLittleMaid;
import com.github.tartaricacid.touhoulittlemaid.api.IMaidTask;
import com.github.tartaricacid.touhoulittlemaid.api.LittleMaidAPI;
import com.github.tartaricacid.touhoulittlemaid.client.gui.ResourcesDownloadGui;
import com.github.tartaricacid.touhoulittlemaid.client.gui.skin.MaidHataSelect;
import com.github.tartaricacid.touhoulittlemaid.client.gui.skin.MaidSkinGui;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.github.tartaricacid.touhoulittlemaid.init.MaidSoundEvent;
import com.github.tartaricacid.touhoulittlemaid.inventory.MaidMainContainer;
import com.github.tartaricacid.touhoulittlemaid.network.MaidGuiHandler;
import com.github.tartaricacid.touhoulittlemaid.network.simpleimpl.MaidHomeModeMessage;
import com.github.tartaricacid.touhoulittlemaid.network.simpleimpl.MaidPickupModeMessage;
import com.github.tartaricacid.touhoulittlemaid.network.simpleimpl.SwitchMaidGuiMessage;
import com.github.tartaricacid.touhoulittlemaid.network.simpleimpl.effect.EffectRequest;
import com.github.tartaricacid.touhoulittlemaid.proxy.CommonProxy;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.text.DecimalFormat;
import java.util.Arrays;
import java.util.Collection;
import java.util.Locale;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import net.minecraft.block.Block;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiButtonImage;
import net.minecraft.client.gui.GuiButtonToggle;
import net.minecraft.client.gui.GuiConfirmOpenLink;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.GuiYesNoCallback;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.gui.inventory.GuiInventory;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.inventory.Container;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.commons.lang3.concurrent.BasicThreadFactory;

@SideOnly(value=Side.CLIENT)
public abstract class AbstractMaidGuiContainer
extends GuiContainer {
    protected static final DecimalFormat DECIMAL_FORMAT = new DecimalFormat("0.0");
    protected static final ResourceLocation BACKGROUND = new ResourceLocation("touhou_little_maid", "textures/gui/inventory_main.png");
    private static final ResourceLocation SIDE = new ResourceLocation("touhou_little_maid", "textures/gui/inventory_side.png");
    private static ScheduledExecutorService timer;
    private static int taskPageIndex;
    protected MaidMainContainer container;
    EntityMaid maid;
    private int guiId;
    private int taskPageTotal;
    private GuiButtonToggle togglePickup;
    private GuiButtonToggle toggleHome;

    public AbstractMaidGuiContainer(MaidMainContainer inventorySlotsIn, int guiId) {
        super((Container)inventorySlotsIn);
        this.guiId = guiId;
        this.container = inventorySlotsIn;
        this.maid = this.container.maid;
        this.taskPageTotal = (LittleMaidAPI.getTasks().size() - 1) / 6;
        this.syncEffectThread();
    }

    public abstract void drawCustomBackground(int var1, int var2, float var3);

    public abstract void drawCustomScreen(int var1, int var2, float var3);

    public abstract void drawCustomTooltips(int var1, int var2, float var3);

    public abstract String getGuiName();

    public void func_73866_w_() {
        this.field_146292_n.clear();
        this.field_146293_o.clear();
        super.func_73866_w_();
        int i = this.field_147003_i;
        int j = this.field_147009_r;
        this.togglePickup = new GuiButtonToggle(BUTTON.PICKUP.ordinal(), i + 143, j + 63, 26, 16, this.maid.isPickup());
        this.togglePickup.func_191751_a(178, 0, 28, 18, BACKGROUND);
        this.field_146292_n.add(this.togglePickup);
        this.field_146292_n.add(new GuiButtonImage(BUTTON.MAIN.ordinal(), i + 3, j - 25, 22, 22, 234, 234, 0, BACKGROUND));
        this.field_146292_n.add(new GuiButtonImage(BUTTON.INVENTORY.ordinal(), i + 31, j - 25, 22, 22, 234, 234, 0, BACKGROUND));
        this.field_146292_n.add(new GuiButtonImage(BUTTON.BAUBLE.ordinal(), i + 59, j - 25, 22, 22, 234, 234, 0, BACKGROUND));
        this.toggleHome = new GuiButtonToggle(BUTTON.HOME.ordinal(), i + 116, j + 63, 26, 16, this.maid.isHome());
        this.toggleHome.func_191751_a(178, 36, 28, 18, BACKGROUND);
        this.field_146292_n.add(this.toggleHome);
        this.field_146292_n.add(new GuiButtonImage(BUTTON.SKIN.ordinal(), i + 65, j + 9, 9, 9, 178, 72, 10, BACKGROUND));
        if (this.maid.hasSasimono()) {
            this.field_146292_n.add(new GuiButtonImage(BUTTON.HATA_SASIMONO.ordinal(), i + 26, j + 9, 9, 9, 188, 72, 10, BACKGROUND));
        }
        this.field_146292_n.add(new GuiButtonImage(BUTTON.SOUND_CREDIT.ordinal(), i + 3, j + 166, 21, 21, 233, 0, 24, BACKGROUND));
        this.field_146292_n.add(new GuiButtonImage(BUTTON.DOWNLOAD_RESOURCES.ordinal(), i + 24, j + 166, 21, 21, 233, 45, 24, BACKGROUND));
        GuiButtonImage leftSwitch = new GuiButtonImage(BUTTON.TASK_LEFT_SWITCH.ordinal(), i - 70, j + 150, 7, 11, 177, 0, 16, SIDE);
        GuiButtonImage rightSwitch = new GuiButtonImage(BUTTON.TASK_RIGHT_SWITCH.ordinal(), i - 17, j + 150, 7, 11, 165, 0, 16, SIDE);
        leftSwitch.field_146125_m = taskPageIndex > 0;
        rightSwitch.field_146125_m = taskPageIndex < this.taskPageTotal;
        this.field_146292_n.add(leftSwitch);
        this.field_146292_n.add(rightSwitch);
        for (int k = 0; k < 6 && k + taskPageIndex * 6 < LittleMaidAPI.getTasks().size(); ++k) {
            if (LittleMaidAPI.getTasks().get(k + taskPageIndex * 6) == this.container.task) {
                this.field_146292_n.add(new GuiButtonImage(k + BUTTON.values().length, i - 70, j + 23 + 21 * k, 60, 20, 98, 0, 0, SIDE));
                continue;
            }
            this.field_146292_n.add(new GuiButtonImage(k + BUTTON.values().length, i - 70, j + 23 + 21 * k, 60, 20, 98, 20, 20, SIDE));
        }
    }

    protected void func_146284_a(GuiButton button) throws IOException {
        int listIndex;
        super.func_146284_a(button);
        if (button.field_146127_k == BUTTON.PICKUP.ordinal()) {
            if (this.maid.isPickup()) {
                this.togglePickup.func_191753_b(false);
                CommonProxy.INSTANCE.sendToServer((IMessage)new MaidPickupModeMessage(this.maid.func_110124_au(), false));
                return;
            }
            this.togglePickup.func_191753_b(true);
            CommonProxy.INSTANCE.sendToServer((IMessage)new MaidPickupModeMessage(this.maid.func_110124_au(), true));
            return;
        }
        if (button.field_146127_k == BUTTON.MAIN.ordinal()) {
            CommonProxy.INSTANCE.sendToServer((IMessage)new SwitchMaidGuiMessage(this.field_146297_k.field_71439_g.func_110124_au(), this.maid.func_145782_y(), BUTTON.MAIN.getGuiId(), this.container.taskIndex));
            return;
        }
        if (button.field_146127_k == BUTTON.INVENTORY.ordinal()) {
            CommonProxy.INSTANCE.sendToServer((IMessage)new SwitchMaidGuiMessage(this.field_146297_k.field_71439_g.func_110124_au(), this.maid.func_145782_y(), BUTTON.INVENTORY.getGuiId(), this.container.taskIndex));
            return;
        }
        if (button.field_146127_k == BUTTON.BAUBLE.ordinal()) {
            CommonProxy.INSTANCE.sendToServer((IMessage)new SwitchMaidGuiMessage(this.field_146297_k.field_71439_g.func_110124_au(), this.maid.func_145782_y(), BUTTON.BAUBLE.getGuiId(), this.container.taskIndex));
            return;
        }
        if (button.field_146127_k == BUTTON.HOME.ordinal()) {
            if (this.maid.isHome()) {
                this.toggleHome.func_191753_b(false);
                CommonProxy.INSTANCE.sendToServer((IMessage)new MaidHomeModeMessage(this.maid.func_110124_au(), false));
                return;
            }
            this.toggleHome.func_191753_b(true);
            CommonProxy.INSTANCE.sendToServer((IMessage)new MaidHomeModeMessage(this.maid.func_110124_au(), true));
            return;
        }
        if (button.field_146127_k == BUTTON.SKIN.ordinal()) {
            this.field_146297_k.func_152344_a(() -> this.field_146297_k.func_147108_a((GuiScreen)new MaidSkinGui(this.maid)));
            return;
        }
        if (button.field_146127_k == BUTTON.HATA_SASIMONO.ordinal()) {
            this.field_146297_k.func_152344_a(() -> this.field_146297_k.func_147108_a((GuiScreen)new MaidHataSelect(this.maid)));
            return;
        }
        if (button.field_146127_k == BUTTON.SOUND_CREDIT.ordinal()) {
            this.field_146297_k.field_71439_g.func_184185_a(MaidSoundEvent.OTHER_CREDIT, 1.0f, 1.0f);
            this.field_146297_k.func_152344_a(() -> this.field_146297_k.func_147108_a((GuiScreen)new GuiSoundCredit((GuiYesNoCallback)this)));
            return;
        }
        if (button.field_146127_k == BUTTON.DOWNLOAD_RESOURCES.ordinal()) {
            this.field_146297_k.func_152344_a(() -> this.field_146297_k.func_147108_a((GuiScreen)new ResourcesDownloadGui()));
            return;
        }
        if (button.field_146127_k == BUTTON.TASK_LEFT_SWITCH.ordinal()) {
            if (taskPageIndex > 0) {
                --taskPageIndex;
                this.func_73866_w_();
            }
            return;
        }
        if (button.field_146127_k == BUTTON.TASK_RIGHT_SWITCH.ordinal()) {
            if (taskPageIndex < this.taskPageTotal) {
                ++taskPageIndex;
                this.func_73866_w_();
            }
            return;
        }
        if (button.field_146127_k >= BUTTON.values().length && button.field_146127_k < BUTTON.values().length + 6 && (listIndex = button.field_146127_k - BUTTON.values().length + taskPageIndex * 6) < LittleMaidAPI.getTasks().size()) {
            this.container.taskIndex = listIndex;
            this.container.task = LittleMaidAPI.getTasks().get(listIndex);
            this.func_73866_w_();
        }
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        boolean yInRange;
        boolean xInRange;
        super.func_73863_a(mouseX, mouseY, partialTicks);
        this.drawCustomScreen(mouseX, mouseY, partialTicks);
        int i = this.field_147003_i;
        int j = this.field_147009_r;
        String currentModeName = TextFormatting.DARK_GRAY + I18n.func_135052_a((String)this.container.task.getTranslationKey(), (Object[])new Object[0]);
        this.field_146289_q.func_175065_a(currentModeName, (float)(i - 39 - this.field_146289_q.func_78256_a(currentModeName) / 2), (float)(j + 9), 0xFFFFFF, false);
        String pageText = String.format("%s%d/%d", TextFormatting.DARK_GRAY, taskPageIndex + 1, this.taskPageTotal + 1);
        this.field_146289_q.func_175065_a(pageText, (float)(i - 39 - this.field_146289_q.func_78256_a(pageText) / 2), (float)(j + 151), 0xFFFFFF, false);
        for (int k = 0; k < 6 && k + taskPageIndex * 6 < LittleMaidAPI.getTasks().size(); ++k) {
            IMaidTask task = LittleMaidAPI.getTasks().get(k + taskPageIndex * 6);
            this.drawItemStack(task.getIcon(), i - 68, j + 25 + 21 * k);
            String name = I18n.func_135052_a((String)task.getTranslationKey(), (Object[])new Object[0]);
            this.field_146289_q.func_175065_a(name, (float)(i - 32 - this.field_146289_q.func_78256_a(name) / 2), (float)(j + 29 + 21 * k), 0xDDDDDD, false);
        }
        int spacing = 0;
        Collection effects = this.maid.func_70651_bq();
        for (PotionEffect effect : effects) {
            if (effect.func_76459_b() <= 0) continue;
            Potion potion = effect.func_188419_a();
            int startX = i + 178 + this.getRenderPotionStartXOffset();
            int startY = j + 5 + spacing;
            spacing += 12;
            GlStateManager.func_179094_E();
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GlStateManager.func_179137_b((double)startX, (double)((double)startY - 1.5), (double)0.0);
            GlStateManager.func_179139_a((double)0.6, (double)0.6, (double)0.6);
            this.field_146297_k.func_110434_K().func_110577_a(field_147001_a);
            if (potion.func_76400_d()) {
                int index = potion.func_76392_e();
                this.func_73729_b(0, 0, index % 8 * 18, 198 + index / 8 * 18, 18, 18);
            }
            GlStateManager.func_179121_F();
            potion.renderInventoryEffect(i, j, effect, this.field_146297_k);
            if (!potion.shouldRenderInvText(effect) || effect.func_76459_b() <= 0) continue;
            this.field_146289_q.func_175065_a(String.format("%s %s %s %s%s", effect.func_188419_a().func_76398_f() ? TextFormatting.RED : TextFormatting.RESET, I18n.func_135052_a((String)effect.func_76453_d(), (Object[])new Object[0]), I18n.func_135052_a((String)("enchantment.level." + (effect.func_76458_c() + 1)), (Object[])new Object[0]), TextFormatting.GRAY, Potion.func_188410_a((PotionEffect)effect, (float)1.0f)), (float)(startX + 9), (float)startY, -1, true);
        }
        for (MaidGuiHandler.MAIN_GUI gui : MaidGuiHandler.MAIN_GUI.values()) {
            xInRange = i + 28 * (gui.getId() - 1) < mouseX && mouseX < i + 28 * gui.getId();
            boolean bl = yInRange = j - 28 < mouseY && mouseY < j;
            if (!xInRange || !yInRange) continue;
            this.func_146279_a(I18n.func_135052_a((String)("gui.touhou_little_maid.tab." + gui.name().toLowerCase(Locale.US)), (Object[])new Object[0]), mouseX, mouseY);
        }
        xInRange = i + 143 < mouseX && mouseX < i + 169;
        boolean bl = yInRange = j + 63 < mouseY && mouseY < j + 79;
        if (xInRange && yInRange) {
            this.func_146283_a(Arrays.asList(I18n.func_135052_a((String)("gui.touhou_little_maid.button.pickup." + this.maid.isPickup()), (Object[])new Object[0]), I18n.func_135052_a((String)"gui.touhou_little_maid.button.pickup.desc", (Object[])new Object[0])), mouseX, mouseY);
        }
        xInRange = i + 116 < mouseX && mouseX < i + 142;
        boolean bl2 = yInRange = j + 63 < mouseY && mouseY < j + 79;
        if (xInRange && yInRange) {
            this.func_146283_a(Arrays.asList(I18n.func_135052_a((String)("gui.touhou_little_maid.button.home." + this.maid.isHome()), (Object[])new Object[0]), I18n.func_135052_a((String)"gui.touhou_little_maid.button.home.desc", (Object[])new Object[0])), mouseX, mouseY);
        }
        xInRange = i + 65 < mouseX && mouseX < i + 74;
        boolean bl3 = yInRange = j + 9 < mouseY && mouseY < j + 18;
        if (xInRange && yInRange) {
            this.func_146279_a(I18n.func_135052_a((String)"gui.touhou_little_maid.button.skin", (Object[])new Object[0]), mouseX, mouseY);
        }
        xInRange = i + 26 < mouseX && mouseX < i + 35;
        boolean bl4 = yInRange = j + 9 < mouseY && mouseY < j + 18;
        if (xInRange && yInRange && this.maid.hasSasimono()) {
            this.func_146279_a(I18n.func_135052_a((String)"gui.touhou_little_maid.button.hata_sasimono", (Object[])new Object[0]), mouseX, mouseY);
        }
        this.drawCustomTooltips(mouseX, mouseY, partialTicks);
        this.func_191948_b(mouseX, mouseY);
    }

    protected void func_146976_a(float partialTicks, int mouseX, int mouseY) {
        int i = this.field_147003_i;
        int j = this.field_147009_r;
        this.func_146276_q_();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.field_146297_k.func_110434_K().func_110577_a(BACKGROUND);
        this.func_73729_b(i, j - 28, 0, 193, 112, 32);
        this.field_146297_k.func_110434_K().func_110577_a(SIDE);
        this.func_73729_b(i - 76, j, 0, 0, 89, this.field_147000_g);
        this.field_146297_k.func_110434_K().func_110577_a(BACKGROUND);
        this.func_73729_b(i, j, 0, 0, this.field_146999_f, this.field_147000_g);
        this.drawCustomBackground(mouseX, mouseY, partialTicks);
        this.field_146297_k.func_110434_K().func_110577_a(BACKGROUND);
        this.func_73729_b(i + 28 * (this.guiId - 1), j - 28, 28 * (this.guiId - 1), 224, 28, 32);
        this.drawItemStack(Items.field_151099_bA.func_190903_i(), i + 6, j - 19);
        this.drawItemStack(Item.func_150898_a((Block)Blocks.field_150486_ae).func_190903_i(), i + 34, j - 19);
        this.drawItemStack(new ItemStack(Items.field_151100_aR, 1, 4), i + 62, j - 19);
        this.drawItemStack(Items.field_151048_u.func_190903_i(), i + 90, j - 19);
        GuiInventory.func_147046_a((int)(i + 51), (int)(j + 70), (int)28, (float)((float)(i + 51) - (float)mouseX), (float)((float)(j + 70 - 45) - (float)mouseY), (EntityLivingBase)this.maid);
    }

    private void drawItemStack(ItemStack stack, int x, int y) {
        RenderHelper.func_74520_c();
        GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)32.0f);
        this.field_73735_i = 200.0f;
        this.field_146296_j.field_77023_b = 200.0f;
        this.field_146296_j.func_180450_b(stack, x, y);
        this.field_73735_i = 0.0f;
        this.field_146296_j.field_77023_b = 0.0f;
        RenderHelper.func_74518_a();
    }

    public abstract int getRenderPotionStartXOffset();

    public int getXSize() {
        if (this.maid.func_70651_bq().size() <= 0) {
            return super.getXSize() + this.getRenderPotionStartXOffset();
        }
        int i = 0;
        for (PotionEffect effect : this.maid.func_70651_bq()) {
            i += effect.func_76459_b();
        }
        if (i == 0) {
            return super.getXSize() + this.getRenderPotionStartXOffset();
        }
        return super.getXSize() + 128 + this.getRenderPotionStartXOffset();
    }

    private void syncEffectThread() {
        timer = new ScheduledThreadPoolExecutor(1, (ThreadFactory)new BasicThreadFactory.Builder().namingPattern("sync-maid-effect-schedule").daemon(true).build());
        timer.scheduleAtFixedRate(() -> CommonProxy.INSTANCE.sendToServer((IMessage)new EffectRequest(this.maid.func_110124_au())), 0L, 500L, TimeUnit.MILLISECONDS);
    }

    public void func_146281_b() {
        timer.shutdown();
        super.func_146281_b();
    }

    private class GuiSoundCredit
    extends GuiConfirmOpenLink {
        GuiSoundCredit(GuiYesNoCallback parentScreenIn) {
            super(parentScreenIn, "https://www14.big.or.jp/~amiami/happy/index.html", BUTTON.SOUND_CREDIT.ordinal(), true);
        }

        protected void func_146284_a(GuiButton button) {
            if (button.field_146127_k == 0) {
                try {
                    super.func_175282_a(new URI("https://www14.big.or.jp/~amiami/happy/index.html"));
                }
                catch (URISyntaxException urisyntaxexception) {
                    TouhouLittleMaid.LOGGER.error("Can't open url for {}", (Throwable)urisyntaxexception);
                }
                return;
            }
            if (button.field_146127_k == 1) {
                this.field_146297_k.func_152344_a(() -> this.field_146297_k.func_147108_a(null));
                return;
            }
            if (button.field_146127_k == 2) {
                this.func_146359_e();
            }
        }

        public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
            super.func_146358_g();
            super.func_73863_a(mouseX, mouseY, partialTicks);
            this.func_73732_a(this.field_146289_q, TextFormatting.GOLD.toString() + TextFormatting.BOLD.toString() + I18n.func_135052_a((String)"gui.touhou_little_maid.credit.url.close", (Object[])new Object[0]), this.field_146294_l / 2, 110, 0xFFCCCC);
        }
    }

    public static enum BUTTON {
        PICKUP(MaidGuiHandler.OTHER_GUI.NONE.getId()),
        MAIN(MaidGuiHandler.MAIN_GUI.MAIN.getId()),
        INVENTORY(MaidGuiHandler.MAIN_GUI.INVENTORY.getId()),
        BAUBLE(MaidGuiHandler.MAIN_GUI.BAUBLE.getId()),
        HOME(MaidGuiHandler.OTHER_GUI.NONE.getId()),
        SKIN(MaidGuiHandler.OTHER_GUI.NONE.getId()),
        SOUND_CREDIT(MaidGuiHandler.OTHER_GUI.NONE.getId()),
        HATA_SASIMONO(MaidGuiHandler.OTHER_GUI.NONE.getId()),
        TASK_LEFT_SWITCH(MaidGuiHandler.OTHER_GUI.NONE.getId()),
        TASK_RIGHT_SWITCH(MaidGuiHandler.OTHER_GUI.NONE.getId()),
        DOWNLOAD_RESOURCES(MaidGuiHandler.OTHER_GUI.NONE.getId());

        private int guiId;

        private BUTTON(int guiId) {
            this.guiId = guiId;
        }

        public int getGuiId() {
            return this.guiId;
        }
    }
}

