/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.client.gui.block;

import com.github.tartaricacid.touhoulittlemaid.capability.CapabilityPowerHandler;
import com.github.tartaricacid.touhoulittlemaid.capability.PowerHandler;
import com.github.tartaricacid.touhoulittlemaid.inventory.MaidBeaconContainer;
import com.github.tartaricacid.touhoulittlemaid.network.simpleimpl.SetBeaconPotionMessage;
import com.github.tartaricacid.touhoulittlemaid.network.simpleimpl.StorageAndTakePowerMessage;
import com.github.tartaricacid.touhoulittlemaid.proxy.CommonProxy;
import com.github.tartaricacid.touhoulittlemaid.tileentity.TileEntityMaidBeacon;
import com.github.tartaricacid.touhoulittlemaid.util.RenderHelper;
import java.text.DecimalFormat;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiButtonToggle;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.resources.I18n;
import net.minecraft.init.MobEffects;
import net.minecraft.inventory.Container;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class MaidBeaconGuiContainer
extends GuiContainer {
    private static final ResourceLocation BG = new ResourceLocation("touhou_little_maid", "textures/gui/maid_beacon.png");
    private static final DecimalFormat DECIMAL_FORMAT = new DecimalFormat("0.00");
    private TileEntityMaidBeacon beacon;
    private GuiButtonToggle speed;
    private GuiButtonToggle fireResistance;
    private GuiButtonToggle strength;
    private GuiButtonToggle resistance;
    private GuiButtonToggle regeneration;

    public MaidBeaconGuiContainer(MaidBeaconContainer maidBeaconContainer) {
        super((Container)maidBeaconContainer);
        this.field_146999_f = 256;
        this.field_147000_g = 105;
        this.beacon = maidBeaconContainer.getTileEntityMaidBeacon();
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        int i = this.field_147003_i;
        int j = this.field_147009_r;
        int start = i + 16;
        int spacing = 26;
        int y = j + 15;
        this.speed = new GuiButtonToggle(TileEntityMaidBeacon.Effect.SPEED.ordinal(), start, y, 22, 22, this.beacon.getPotionIndex() == TileEntityMaidBeacon.Effect.SPEED.ordinal());
        this.speed.func_191751_a(0, 111, 22, 22, BG);
        this.field_146292_n.add(this.speed);
        this.fireResistance = new GuiButtonToggle(TileEntityMaidBeacon.Effect.FIRE_RESISTANCE.ordinal(), start + spacing, y, 22, 22, this.beacon.getPotionIndex() == TileEntityMaidBeacon.Effect.FIRE_RESISTANCE.ordinal());
        this.fireResistance.func_191751_a(0, 111, 22, 22, BG);
        this.field_146292_n.add(this.fireResistance);
        this.strength = new GuiButtonToggle(TileEntityMaidBeacon.Effect.STRENGTH.ordinal(), start + spacing * 2, y, 22, 22, this.beacon.getPotionIndex() == TileEntityMaidBeacon.Effect.STRENGTH.ordinal());
        this.strength.func_191751_a(0, 111, 22, 22, BG);
        this.field_146292_n.add(this.strength);
        this.resistance = new GuiButtonToggle(TileEntityMaidBeacon.Effect.RESISTANCE.ordinal(), start + spacing * 3, y, 22, 22, this.beacon.getPotionIndex() == TileEntityMaidBeacon.Effect.RESISTANCE.ordinal());
        this.resistance.func_191751_a(0, 111, 22, 22, BG);
        this.field_146292_n.add(this.resistance);
        this.regeneration = new GuiButtonToggle(TileEntityMaidBeacon.Effect.REGENERATION.ordinal(), start + spacing * 4, y, 22, 22, this.beacon.getPotionIndex() == TileEntityMaidBeacon.Effect.REGENERATION.ordinal());
        this.regeneration.func_191751_a(0, 111, 22, 22, BG);
        this.field_146292_n.add(this.regeneration);
        this.field_146292_n.add(new GuiButton(Button.ADD_ONE.getIndex(), i + 16, j + 48, 62, 20, I18n.func_135052_a((String)"gui.touhou_little_maid.maid_beacon.add_one", (Object[])new Object[0])));
        this.field_146292_n.add(new GuiButton(Button.ADD_ALL.getIndex(), i + 80, j + 48, 62, 20, I18n.func_135052_a((String)"gui.touhou_little_maid.maid_beacon.add_all", (Object[])new Object[0])));
        this.field_146292_n.add(new GuiButton(Button.MIN_ONE.getIndex(), i + 16, j + 70, 62, 20, I18n.func_135052_a((String)"gui.touhou_little_maid.maid_beacon.min_one", (Object[])new Object[0])));
        this.field_146292_n.add(new GuiButton(Button.MIN_ALL.getIndex(), i + 80, j + 70, 62, 20, I18n.func_135052_a((String)"gui.touhou_little_maid.maid_beacon.min_all", (Object[])new Object[0])));
    }

    protected void func_146976_a(float partialTicks, int mouseX, int mouseY) {
        this.func_146276_q_();
        this.field_146297_k.func_110434_K().func_110577_a(BG);
        this.func_73729_b(this.field_147003_i, this.field_147009_r, 0, 0, 256, 105);
        PowerHandler powerHandler = (PowerHandler)Minecraft.func_71410_x().field_71439_g.getCapability(CapabilityPowerHandler.POWER_CAP, null);
        if (powerHandler != null) {
            this.func_73732_a(this.field_146289_q, I18n.func_135052_a((String)"gui.touhou_little_maid.maid_beacon.player_power", (Object[])new Object[]{DECIMAL_FORMAT.format(powerHandler.get())}), this.field_147003_i + 198, this.field_147009_r + 10 + 2, 0xFFFFFF);
        }
        this.func_73732_a(this.field_146289_q, I18n.func_135052_a((String)"gui.touhou_little_maid.maid_beacon.storage_power", (Object[])new Object[]{DECIMAL_FORMAT.format(this.beacon.getStoragePower())}), this.field_147003_i + 198, this.field_147009_r + 22, 0xFFFFFF);
        if (this.beacon.getPotionIndex() == -1) {
            this.func_73732_a(this.field_146289_q, I18n.func_135052_a((String)"gui.touhou_little_maid.maid_beacon.cost_power", (Object[])new Object[]{DECIMAL_FORMAT.format(0L)}), this.field_147003_i + 198, this.field_147009_r + 32, 0xFFFFFF);
        } else {
            this.func_73732_a(this.field_146289_q, TextFormatting.RED + I18n.func_135052_a((String)"gui.touhou_little_maid.maid_beacon.cost_power", (Object[])new Object[]{DECIMAL_FORMAT.format(this.beacon.getEffectCost() * 900.0f)}), this.field_147003_i + 198, this.field_147009_r + 32, 0xFFFFFF);
        }
        RenderHelper.drawCircle(this.field_147003_i + 180, this.field_147009_r + 70, 20, 64, 570846061);
        RenderHelper.drawSector(this.field_147003_i + 180, this.field_147009_r + 70, 22, 0.0, (double)(this.beacon.getStoragePower() / this.beacon.getMaxStorage() * 2.0f) * Math.PI, 64, -12524315);
        this.func_73732_a(this.field_146289_q, String.format("%.2f%%", Float.valueOf(this.beacon.getStoragePower() / this.beacon.getMaxStorage() * 100.0f)), this.field_147003_i + 223, this.field_147009_r + 66, 0xFFFFFF);
    }

    protected void func_146284_a(GuiButton button) {
        PowerHandler powerHandler = (PowerHandler)Minecraft.func_71410_x().field_71439_g.getCapability(CapabilityPowerHandler.POWER_CAP, null);
        if (powerHandler == null) {
            return;
        }
        if (button.field_146127_k == this.speed.field_146127_k) {
            CommonProxy.INSTANCE.sendToServer((IMessage)new SetBeaconPotionMessage(this.field_146297_k.field_71439_g.func_110124_au(), this.beacon.func_174877_v(), this.speed.func_191754_c() ? -1 : button.field_146127_k));
            this.speed.func_191753_b(!this.speed.func_191754_c());
            if (this.speed.func_191754_c()) {
                this.fireResistance.func_191753_b(false);
                this.strength.func_191753_b(false);
                this.resistance.func_191753_b(false);
                this.regeneration.func_191753_b(false);
            }
            return;
        }
        if (button.field_146127_k == this.fireResistance.field_146127_k) {
            CommonProxy.INSTANCE.sendToServer((IMessage)new SetBeaconPotionMessage(this.field_146297_k.field_71439_g.func_110124_au(), this.beacon.func_174877_v(), this.fireResistance.func_191754_c() ? -1 : button.field_146127_k));
            this.fireResistance.func_191753_b(!this.fireResistance.func_191754_c());
            if (this.fireResistance.func_191754_c()) {
                this.speed.func_191753_b(false);
                this.strength.func_191753_b(false);
                this.resistance.func_191753_b(false);
                this.regeneration.func_191753_b(false);
            }
            return;
        }
        if (button.field_146127_k == this.strength.field_146127_k) {
            CommonProxy.INSTANCE.sendToServer((IMessage)new SetBeaconPotionMessage(this.field_146297_k.field_71439_g.func_110124_au(), this.beacon.func_174877_v(), this.strength.func_191754_c() ? -1 : button.field_146127_k));
            this.strength.func_191753_b(!this.strength.func_191754_c());
            if (this.strength.func_191754_c()) {
                this.speed.func_191753_b(false);
                this.fireResistance.func_191753_b(false);
                this.resistance.func_191753_b(false);
                this.regeneration.func_191753_b(false);
            }
            return;
        }
        if (button.field_146127_k == this.resistance.field_146127_k) {
            CommonProxy.INSTANCE.sendToServer((IMessage)new SetBeaconPotionMessage(this.field_146297_k.field_71439_g.func_110124_au(), this.beacon.func_174877_v(), this.resistance.func_191754_c() ? -1 : button.field_146127_k));
            this.resistance.func_191753_b(!this.resistance.func_191754_c());
            if (this.resistance.func_191754_c()) {
                this.speed.func_191753_b(false);
                this.fireResistance.func_191753_b(false);
                this.strength.func_191753_b(false);
                this.regeneration.func_191753_b(false);
            }
            return;
        }
        if (button.field_146127_k == this.regeneration.field_146127_k) {
            CommonProxy.INSTANCE.sendToServer((IMessage)new SetBeaconPotionMessage(this.field_146297_k.field_71439_g.func_110124_au(), this.beacon.func_174877_v(), this.regeneration.func_191754_c() ? -1 : button.field_146127_k));
            this.regeneration.func_191753_b(!this.regeneration.func_191754_c());
            if (this.regeneration.func_191754_c()) {
                this.speed.func_191753_b(false);
                this.fireResistance.func_191753_b(false);
                this.strength.func_191753_b(false);
                this.resistance.func_191753_b(false);
            }
            return;
        }
        if (button.field_146127_k == Button.ADD_ONE.getIndex()) {
            CommonProxy.INSTANCE.sendToServer((IMessage)new StorageAndTakePowerMessage(this.field_146297_k.field_71439_g.func_110124_au(), this.beacon.func_174877_v(), 1.0f, true));
            return;
        }
        if (button.field_146127_k == Button.ADD_ALL.getIndex()) {
            CommonProxy.INSTANCE.sendToServer((IMessage)new StorageAndTakePowerMessage(this.field_146297_k.field_71439_g.func_110124_au(), this.beacon.func_174877_v(), powerHandler.get(), true));
            return;
        }
        if (button.field_146127_k == Button.MIN_ONE.getIndex()) {
            CommonProxy.INSTANCE.sendToServer((IMessage)new StorageAndTakePowerMessage(this.field_146297_k.field_71439_g.func_110124_au(), this.beacon.func_174877_v(), 1.0f, false));
            return;
        }
        if (button.field_146127_k == Button.MIN_ALL.getIndex()) {
            CommonProxy.INSTANCE.sendToServer((IMessage)new StorageAndTakePowerMessage(this.field_146297_k.field_71439_g.func_110124_au(), this.beacon.func_174877_v(), this.beacon.getStoragePower(), false));
        }
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        super.func_73863_a(mouseX, mouseY, partialTicks);
        int i = this.field_147003_i;
        int j = this.field_147009_r;
        int start = i + 18;
        int spacing = 26;
        int y = j + 17;
        this.field_146297_k.field_71446_o.func_110577_a(GuiContainer.field_147001_a);
        this.func_73729_b(start, y, MobEffects.field_76424_c.func_76392_e() % 8 * 18, 198 + MobEffects.field_76424_c.func_76392_e() / 8 * 18, 18, 18);
        this.func_73729_b(start + spacing, y, MobEffects.field_76426_n.func_76392_e() % 8 * 18, 198 + MobEffects.field_76426_n.func_76392_e() / 8 * 18, 18, 18);
        this.func_73729_b(start + spacing * 2, y, MobEffects.field_76420_g.func_76392_e() % 8 * 18, 198 + MobEffects.field_76420_g.func_76392_e() / 8 * 18, 18, 18);
        this.func_73729_b(start + spacing * 3, y, MobEffects.field_76429_m.func_76392_e() % 8 * 18, 198 + MobEffects.field_76429_m.func_76392_e() / 8 * 18, 18, 18);
        this.func_73729_b(start + spacing * 4, y, MobEffects.field_76428_l.func_76392_e() % 8 * 18, 198 + MobEffects.field_76428_l.func_76392_e() / 8 * 18, 18, 18);
    }

    static enum Button {
        ADD_ONE,
        ADD_ALL,
        MIN_ONE,
        MIN_ALL;


        int getIndex() {
            return this.ordinal() + TileEntityMaidBeacon.Effect.VALUES.length;
        }
    }
}

