/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.client.gui;

import com.github.tartaricacid.touhoulittlemaid.client.download.InfoGetManager;
import com.github.tartaricacid.touhoulittlemaid.client.download.pojo.DownloadInfo;
import com.github.tartaricacid.touhoulittlemaid.client.download.pojo.DownloadStatus;
import com.github.tartaricacid.touhoulittlemaid.client.gui.GuiDownloadButton;
import com.google.common.collect.Lists;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.EnumSet;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.commons.io.FileUtils;
import org.lwjgl.input.Mouse;

@SideOnly(value=Side.CLIENT)
public class ResourcesDownloadGui
extends GuiScreen {
    private static int SCROLL;
    private List<Long> crc32List = Lists.newArrayList();

    public ResourcesDownloadGui() {
        if (InfoGetManager.DOWNLOAD_INFO_LIST != null && InfoGetManager.DOWNLOAD_INFO_LIST.size() != 0) {
            this.getCrc32Info();
            this.checkDownloadInfo();
        }
    }

    public void func_73866_w_() {
        this.field_146292_n.clear();
        if (InfoGetManager.DOWNLOAD_INFO_LIST == null || InfoGetManager.DOWNLOAD_INFO_LIST.size() == 0) {
            this.func_189646_b(new GuiButton(-1, 5, 5, 60, 20, I18n.func_135052_a((String)"gui.touhou_little_maid.resources_download.reload", (Object[])new Object[0])));
        }
        for (int i = 0; i < InfoGetManager.DOWNLOAD_INFO_LIST.size(); ++i) {
            DownloadInfo info = InfoGetManager.DOWNLOAD_INFO_LIST.get(i);
            this.func_189646_b(new GuiDownloadButton(i, this.field_146294_l - 80, i * 75 + 60 - SCROLL, 60, 20, info));
        }
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        this.func_146276_q_();
        if (InfoGetManager.DOWNLOAD_INFO_LIST == null || InfoGetManager.DOWNLOAD_INFO_LIST.size() == 0) {
            this.func_73732_a(this.field_146289_q, I18n.func_135052_a((String)"gui.touhou_little_maid.resources_download.fail.1", (Object[])new Object[0]), this.field_146294_l / 2, this.field_146295_m / 2 - 15, 1048575);
            this.func_73732_a(this.field_146289_q, I18n.func_135052_a((String)"gui.touhou_little_maid.resources_download.fail.2", (Object[])new Object[0]), this.field_146294_l / 2, this.field_146295_m / 2, 1048575);
        } else {
            for (int i = 0; i < InfoGetManager.DOWNLOAD_INFO_LIST.size(); ++i) {
                this.addResInfo(i, InfoGetManager.DOWNLOAD_INFO_LIST.get(i));
            }
        }
        super.func_73863_a(mouseX, mouseY, partialTicks);
    }

    private void addResInfo(int index, DownloadInfo info) {
        this.func_73733_a(10, index * 75 + 20 - SCROLL, this.field_146294_l - 10, index * 75 + 90 - SCROLL, -267382768, -267382768);
        this.func_73731_b(this.field_146289_q, info.getName(), 15, index * 75 + 25 - SCROLL, 0xFFAA00);
        this.func_73731_b(this.field_146289_q, info.getVersion(), 20 + this.field_146289_q.func_78256_a(info.getName()), index * 75 + 25 - SCROLL, 0x55FF55);
        this.func_73731_b(this.field_146289_q, this.getI18nFormatAuthor(info.getAuthor()), 15, index * 75 + 38 - SCROLL, 0x55FFFF);
        this.field_146289_q.func_78279_b(info.getDesc(), 15, index * 75 + 51 - SCROLL, this.field_146294_l - 100, 0x6A6A6A);
        String fileSize = this.getI18nFormatFileSize(info.getFormatFileSize());
        this.func_73731_b(this.field_146289_q, fileSize, this.field_146294_l - this.field_146289_q.func_78256_a(fileSize) - 20, index * 75 + 45 - SCROLL, 0x6A6A6A);
    }

    protected void func_146284_a(GuiButton button) {
        DownloadInfo info;
        if (button.field_146127_k == -1) {
            InfoGetManager.downloadAndReadInfoJsonFile();
            this.field_146297_k.field_71439_g.func_145747_a((ITextComponent)new TextComponentTranslation("message.touhou_little_maid.resources_download.reload", new Object[0]));
            this.field_146297_k.func_152344_a(() -> this.field_146297_k.func_147108_a(null));
            return;
        }
        if (button.field_146127_k >= 0 && button.field_146127_k < InfoGetManager.DOWNLOAD_INFO_LIST.size() && DownloadStatus.canDownload((info = InfoGetManager.DOWNLOAD_INFO_LIST.get(button.field_146127_k)).getStatus())) {
            InfoGetManager.downloadResourcesPack(info);
        }
    }

    public void func_146274_d() throws IOException {
        super.func_146274_d();
        if (Mouse.getEventDWheel() != 0) {
            if (InfoGetManager.DOWNLOAD_INFO_LIST.size() < 4) {
                return;
            }
            if ((SCROLL += Mouse.getEventDWheel() < 0 ? 20 : -20) < 0) {
                SCROLL = 0;
            }
            if (SCROLL > InfoGetManager.DOWNLOAD_INFO_LIST.size() * 75 - this.field_146295_m + 75) {
                SCROLL = InfoGetManager.DOWNLOAD_INFO_LIST.size() * 75 - this.field_146295_m + 75;
            }
            this.func_73866_w_();
        }
    }

    private void getCrc32Info() {
        try {
            Path path = Minecraft.func_71410_x().field_71412_D.toPath().resolve("resourcepacks");
            Files.walkFileTree(path, EnumSet.noneOf(FileVisitOption.class), 1, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                    if (file.getFileName().toString().endsWith(".zip")) {
                        ResourcesDownloadGui.this.crc32List.add(FileUtils.checksumCRC32((File)file.toFile()));
                    }
                    return super.visitFile(file, attrs);
                }
            });
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void checkDownloadInfo() {
        block0: for (DownloadInfo info : InfoGetManager.DOWNLOAD_INFO_LIST) {
            if (info.getStatus() == DownloadStatus.DOWNLOADING) continue;
            info.setStatus(DownloadStatus.NOT_DOWNLOAD);
            for (Long crc32 : this.crc32List) {
                if (crc32.equals(info.getChecksum())) {
                    info.setStatus(DownloadStatus.DOWNLOADED);
                    continue block0;
                }
                if (!info.getHistory().contains(crc32)) continue;
                info.setStatus(DownloadStatus.NEED_UPDATE);
                continue block0;
            }
        }
    }

    private String getI18nFormatAuthor(List<String> authors) {
        String str = String.join((CharSequence)I18n.func_135052_a((String)"gui.touhou_little_maid.resources_download.author.delimiter", (Object[])new Object[0]), authors);
        return I18n.func_135052_a((String)"gui.touhou_little_maid.resources_download.author", (Object[])new Object[]{str});
    }

    private String getI18nFormatFileSize(String size) {
        return I18n.func_135052_a((String)"gui.touhou_little_maid.resources_download.file_size", (Object[])new Object[]{size});
    }
}

