/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.client.event;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.text.ITextComponent;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
@Mod.EventBusSubscriber(modid="touhou_little_maid", value={Side.CLIENT})
public class PlayerLoggedInNotice {
    private static boolean notFirst = false;
    private static Pattern pattern = Pattern.compile("^\\d\\.\\d\\.\\d_(\\d+)$");

    @SubscribeEvent
    public static void onEnterGame(PlayerEvent.PlayerLoggedInEvent event) {
        PlayerLoggedInNotice.missingPatchouliNotice(event);
        PlayerLoggedInNotice.javaVersionNotice(event);
    }

    private static void missingPatchouliNotice(PlayerEvent.PlayerLoggedInEvent event) {
        boolean missingPatchouli;
        boolean bl = missingPatchouli = !Loader.isModLoaded((String)"patchouli");
        if (notFirst) {
            return;
        }
        if (missingPatchouli) {
            String json = I18n.func_135052_a((String)"message.touhou_little_maid.missing_patchouli", (Object[])new Object[0]);
            ITextComponent component = ITextComponent.Serializer.func_150699_a((String)json);
            event.player.func_145747_a(component);
        }
        notFirst = true;
    }

    private static void javaVersionNotice(PlayerEvent.PlayerLoggedInEvent event) {
        int version;
        Matcher matcher = pattern.matcher(System.getProperty("java.version"));
        if (matcher.find() && (version = Integer.valueOf(matcher.group(1)).intValue()) < 60) {
            String json = I18n.func_135052_a((String)"message.touhou_little_maid.java_version_old", (Object[])new Object[0]);
            ITextComponent component = ITextComponent.Serializer.func_150699_a((String)json);
            event.player.func_145747_a(component);
        }
    }
}

