/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.client.event;

import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.github.tartaricacid.touhoulittlemaid.init.MaidItems;
import com.github.tartaricacid.touhoulittlemaid.item.ItemMaidModelCoupon;
import com.github.tartaricacid.touhoulittlemaid.item.ItemPhoto;
import com.github.tartaricacid.touhoulittlemaid.proxy.ClientProxy;
import java.util.concurrent.ExecutionException;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.client.event.RenderTooltipEvent;
import net.minecraftforge.fml.client.config.GuiUtils;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
@Mod.EventBusSubscriber(modid="touhou_little_maid", value={Side.CLIENT})
public class MaidRenderTooltipsEvent {
    private static final String MAID_ID = "touhou_little_maid:entity.passive.maid";

    @SubscribeEvent
    public static void onRenderTooltip(RenderTooltipEvent.PostText event) {
        ItemStack stack = event.getStack();
        if (stack.func_77973_b() == MaidItems.MAID_MODEL_COUPON && ItemMaidModelCoupon.hasModelData(stack)) {
            MaidRenderTooltipsEvent.onRenderMaidTooltips(ItemMaidModelCoupon.getModelData(stack), event.getX(), event.getY(), null);
            return;
        }
        if (stack.func_77973_b() == MaidItems.PHOTO && ItemPhoto.hasMaidNbtData(stack)) {
            MaidRenderTooltipsEvent.onRenderMaidTooltips("", event.getX(), event.getY(), ItemPhoto.getMaidNbtData(stack));
        }
    }

    private static void onRenderBackground(int x, int y, int width, int height) {
        int backgroundColor = -267386864;
        int borderColorStart = 0x505000FF;
        int borderColorEnd = 1344798847;
        GuiUtils.drawGradientRect((int)300, (int)((x -= width) - 3), (int)((y -= height) - 4), (int)(x + width + 3), (int)(y - 3), (int)backgroundColor, (int)backgroundColor);
        GuiUtils.drawGradientRect((int)300, (int)(x - 3), (int)(y + height + 3), (int)(x + width + 3), (int)(y + height + 4), (int)backgroundColor, (int)backgroundColor);
        GuiUtils.drawGradientRect((int)300, (int)(x - 3), (int)(y - 3), (int)(x + width + 3), (int)(y + height + 3), (int)backgroundColor, (int)backgroundColor);
        GuiUtils.drawGradientRect((int)300, (int)(x - 4), (int)(y - 3), (int)(x - 3), (int)(y + height + 3), (int)backgroundColor, (int)backgroundColor);
        GuiUtils.drawGradientRect((int)300, (int)(x + width + 3), (int)(y - 3), (int)(x + width + 4), (int)(y + height + 3), (int)backgroundColor, (int)backgroundColor);
        GuiUtils.drawGradientRect((int)300, (int)(x - 3), (int)(y - 3 + 1), (int)(x - 3 + 1), (int)(y + height + 3 - 1), (int)borderColorStart, (int)borderColorEnd);
        GuiUtils.drawGradientRect((int)300, (int)(x + width + 2), (int)(y - 3 + 1), (int)(x + width + 3), (int)(y + height + 3 - 1), (int)borderColorStart, (int)borderColorEnd);
        GuiUtils.drawGradientRect((int)300, (int)(x - 3), (int)(y - 3), (int)(x + width + 3), (int)(y - 3 + 1), (int)borderColorStart, (int)borderColorStart);
        GuiUtils.drawGradientRect((int)300, (int)(x - 3), (int)(y + height + 2), (int)(x + width + 3), (int)(y + height + 3), (int)borderColorEnd, (int)borderColorEnd);
    }

    private static void onRenderMaidTooltips(String modelId, int x, int y, @Nullable NBTTagCompound compound) {
        Entity entity;
        x -= 20;
        if (y < 65) {
            y = 65;
        }
        MaidRenderTooltipsEvent.onRenderBackground(x, y, 60, 60);
        WorldClient world = Minecraft.func_71410_x().field_71441_e;
        GlStateManager.func_179126_j();
        GlStateManager.func_179124_c((float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179109_b((float)(x - 30), (float)(y - 5), (float)500.0f);
        GlStateManager.func_179152_a((float)24.0f, (float)24.0f, (float)-24.0f);
        GlStateManager.func_179114_b((float)190.0f, (float)1.0f, (float)0.0f, (float)0.0f);
        GlStateManager.func_179114_b((float)(world.func_72820_D() * 2L % 360L), (float)0.0f, (float)-1.0f, (float)0.0f);
        float renderItemScale = 1.0f;
        GlStateManager.func_179094_E();
        if (Minecraft.func_71379_u()) {
            GlStateManager.func_179103_j((int)7425);
        } else {
            GlStateManager.func_179103_j((int)7424);
        }
        try {
            entity = (Entity)ClientProxy.ENTITY_CACHE.get((Object)MAID_ID, () -> MaidRenderTooltipsEvent.lambda$onRenderMaidTooltips$0((World)world));
            if (entity instanceof EntityMaid) {
                EntityMaid maid = (EntityMaid)entity;
                maid.setModelId(modelId);
                renderItemScale = ClientProxy.MAID_MODEL.getModelRenderItemScale(modelId);
                maid.setShowSasimono(false);
                maid.field_70172_ad = 0;
                maid.field_70737_aN = 0;
                maid.field_70725_aQ = 0;
                maid.func_70904_g(false);
                maid.setBackpackLevel(EntityMaid.EnumBackPackLevel.EMPTY);
                for (EntityEquipmentSlot slot : EntityEquipmentSlot.values()) {
                    maid.func_184201_a(slot, ItemStack.field_190927_a);
                }
                if (compound != null) {
                    maid.func_70037_a(compound);
                }
            }
        }
        catch (ExecutionException e) {
            return;
        }
        GlStateManager.func_179142_g();
        GlStateManager.func_179138_g((int)OpenGlHelper.field_77476_b);
        boolean lightmapEnabled = GL11.glGetBoolean((int)3553);
        GlStateManager.func_179138_g((int)OpenGlHelper.field_77478_a);
        GlStateManager.func_179152_a((float)renderItemScale, (float)renderItemScale, (float)renderItemScale);
        Minecraft.func_71410_x().func_175598_ae().func_178633_a(false);
        Minecraft.func_71410_x().func_175598_ae().func_188391_a(entity, 0.0, 0.0, 0.0, 0.0f, 0.0f, true);
        Minecraft.func_71410_x().func_175598_ae().func_178633_a(true);
        GlStateManager.func_179121_F();
        GlStateManager.func_179138_g((int)OpenGlHelper.field_77476_b);
        if (lightmapEnabled) {
            GlStateManager.func_179098_w();
        } else {
            GlStateManager.func_179090_x();
        }
        GlStateManager.func_179138_g((int)OpenGlHelper.field_77478_a);
        GlStateManager.func_179147_l();
    }

    private static /* synthetic */ Entity lambda$onRenderMaidTooltips$0(World world) throws Exception {
        Entity e = EntityList.func_188429_b((ResourceLocation)new ResourceLocation(MAID_ID), (World)world);
        if (e == null) {
            return new EntityMaid(world);
        }
        return e;
    }
}

