/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.client.download.pojo;

import com.github.tartaricacid.touhoulittlemaid.client.download.pojo.DownloadStatus;
import com.google.common.collect.Lists;
import com.google.gson.annotations.SerializedName;
import java.text.DecimalFormat;
import java.util.List;

public class DownloadInfo {
    private static final String[] UNITS = new String[]{"B", "kB", "MB", "GB", "TB"};
    private volatile DownloadStatus status = DownloadStatus.NOT_DOWNLOAD;
    private String formatFileSize = "";
    @SerializedName(value="author")
    private List<String> author = Lists.newArrayList();
    @SerializedName(value="history")
    private List<Long> history = Lists.newArrayList();
    @SerializedName(value="file_name")
    private String fileName = "";
    @SerializedName(value="file_size")
    private long fileSize;
    @SerializedName(value="checksum")
    private long checksum;
    @SerializedName(value="name")
    private String name = "";
    @SerializedName(value="version")
    private String version = "";
    @SerializedName(value="url")
    private String url = "";
    @SerializedName(value="desc")
    private String desc = "";

    private static String readableFileSize(long size) {
        if (size <= 0L) {
            return "0";
        }
        int digitGroups = (int)(Math.log10(size) / Math.log10(1024.0));
        return new DecimalFormat("#,##0.#").format((double)size / Math.pow(1024.0, digitGroups)) + " " + UNITS[digitGroups];
    }

    public List<String> getAuthor() {
        return this.author;
    }

    public String getFileName() {
        return this.fileName;
    }

    public long getFileSize() {
        return this.fileSize;
    }

    public long getChecksum() {
        return this.checksum;
    }

    public String getName() {
        return this.name;
    }

    public String getVersion() {
        return this.version;
    }

    public String getUrl() {
        return this.url;
    }

    public String getDesc() {
        return this.desc;
    }

    public List<Long> getHistory() {
        return this.history;
    }

    public DownloadStatus getStatus() {
        return this.status;
    }

    public void setStatus(DownloadStatus status) {
        this.status = status;
    }

    public String getFormatFileSize() {
        return this.formatFileSize;
    }

    public DownloadInfo decorate() {
        this.formatFileSize = DownloadInfo.readableFileSize(this.getFileSize());
        return this;
    }
}

