/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.client.download;

import com.github.tartaricacid.touhoulittlemaid.TouhouLittleMaid;
import com.github.tartaricacid.touhoulittlemaid.client.download.pojo.DownloadInfo;
import com.github.tartaricacid.touhoulittlemaid.client.download.pojo.DownloadStatus;
import com.github.tartaricacid.touhoulittlemaid.proxy.CommonProxy;
import com.google.common.collect.Lists;
import com.google.gson.reflect.TypeToken;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.commons.io.FileUtils;

@SideOnly(value=Side.CLIENT)
public class InfoGetManager {
    private static final String INFO_JSON_URL = "https://gitlab.com/TartaricAcid/download/raw/master/info.json";
    public static List<DownloadInfo> DOWNLOAD_INFO_LIST = Lists.newArrayList();

    public static void downloadAndReadInfoJsonFile() {
        Thread thread = new Thread(() -> {
            try {
                File file = Minecraft.func_71410_x().field_71412_D.toPath().resolve("resourcepacks").resolve("info.json").toFile();
                TouhouLittleMaid.LOGGER.info("Downloading info.json file...");
                FileUtils.copyURLToFile((URL)new URL(INFO_JSON_URL), (File)file, (int)30000, (int)30000);
                TouhouLittleMaid.LOGGER.info("Downloaded info.json file");
                DOWNLOAD_INFO_LIST = (List)CommonProxy.GSON.fromJson((Reader)new InputStreamReader((InputStream)new FileInputStream(file), StandardCharsets.UTF_8), new TypeToken<List<DownloadInfo>>(){}.getType());
                DOWNLOAD_INFO_LIST.forEach(DownloadInfo::decorate);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }, "Download-Info-Json-File");
        thread.start();
    }

    public static void downloadResourcesPack(DownloadInfo info) {
        Thread thread = new Thread(() -> {
            info.setStatus(DownloadStatus.DOWNLOADING);
            try {
                URL url = new URL(info.getUrl());
                File file = Minecraft.func_71410_x().field_71412_D.toPath().resolve("resourcepacks").resolve(info.getFileName()).toFile();
                TouhouLittleMaid.LOGGER.info("Downloading {} file...", (Object)info.getFileName());
                FileUtils.copyURLToFile((URL)url, (File)file, (int)60000, (int)60000);
                TouhouLittleMaid.LOGGER.info("Downloaded {} file", (Object)info.getFileName());
                info.setStatus(DownloadStatus.DOWNLOADED);
            }
            catch (IOException e) {
                info.setStatus(DownloadStatus.NOT_DOWNLOAD);
                e.printStackTrace();
            }
        }, String.format("Download-Resources-Pack-File-%s", info.getName()));
        thread.start();
    }
}

