/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.capability;

import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.concurrent.Callable;

public class DrawHandler {
    static Factory FACTORY = new Factory();
    private int totalDrawTimes = 0;
    private HashMap<String, Integer> drawInfo = Maps.newHashMap();

    public void addDrawnInfo(String modelId) {
        this.addDrawnInfo(modelId, 1);
    }

    public void addDrawnInfo(String modelId, int times) {
        this.totalDrawTimes += times;
        if (this.drawInfo.containsKey(modelId)) {
            times = this.drawInfo.get(modelId) + times;
        }
        this.drawInfo.put(modelId, times);
    }

    public int getDrawInfo(String modelId) {
        if (this.drawInfo.containsKey(modelId)) {
            return this.drawInfo.get(modelId);
        }
        return 0;
    }

    public HashMap<String, Integer> getDrawInfoMaps() {
        return this.drawInfo;
    }

    public void setDrawInfoMaps(HashMap<String, Integer> drawInfo) {
        this.drawInfo = drawInfo;
    }

    public int getTotalDrawTimes() {
        return this.totalDrawTimes;
    }

    public void setTotalDrawTimes(int times) {
        this.totalDrawTimes = times;
    }

    private static class Factory
    implements Callable<DrawHandler> {
        private Factory() {
        }

        @Override
        public DrawHandler call() {
            return new DrawHandler();
        }
    }
}

