/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.block.muiltblock;

import com.github.tartaricacid.touhoulittlemaid.api.IMultiBlock;
import com.github.tartaricacid.touhoulittlemaid.init.MaidBlocks;
import com.github.tartaricacid.touhoulittlemaid.tileentity.TileEntityAltar;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import net.minecraft.world.gen.structure.template.Template;

public class MuiltBlockAltar
implements IMultiBlock {
    private static final ResourceLocation ALTAR_SOUTH = new ResourceLocation("touhou_little_maid", "altar_south");
    private static final ResourceLocation ALTAR_NORTH = new ResourceLocation("touhou_little_maid", "altar_north");
    private static final ResourceLocation ALTAR_EAST = new ResourceLocation("touhou_little_maid", "altar_east");
    private static final ResourceLocation ALTAR_WEST = new ResourceLocation("touhou_little_maid", "altar_west");
    private static final BlockPos SOUTH_POS = new BlockPos(-4, -3, 0);
    private static final BlockPos NORTH_POS = new BlockPos(-3, -3, -7);
    private static final BlockPos EAST_POS = new BlockPos(0, -3, -3);
    private static final BlockPos WEST_POS = new BlockPos(-7, -3, -4);

    @Override
    public boolean blockIsSuitable(IBlockState blockState) {
        return blockState.func_177230_c() == Blocks.field_150325_L && Blocks.field_150325_L.func_176201_c(blockState) == EnumDyeColor.RED.func_176765_a();
    }

    @Override
    public boolean isMatch(World worldIn, BlockPos posStart, EnumFacing facing, Template template) {
        for (Template.BlockInfo blockInfo : template.field_186270_a) {
            if (worldIn.func_180495_p(posStart.func_177971_a((Vec3i)blockInfo.field_186242_a)).equals(blockInfo.field_186243_b)) continue;
            return false;
        }
        return true;
    }

    @Override
    public void build(World worldIn, BlockPos posStart, EnumFacing facing, Template template) {
        ArrayList posList = Lists.newArrayList();
        ArrayList canPlaceItemPosList = Lists.newArrayList();
        for (Template.BlockInfo blockInfo : template.field_186270_a) {
            posList.add(posStart.func_177971_a((Vec3i)blockInfo.field_186242_a));
            if (blockInfo.field_186242_a.func_177956_o() != 2 || !blockInfo.field_186243_b.equals(Blocks.field_150364_r.func_176223_P())) continue;
            canPlaceItemPosList.add(posStart.func_177971_a((Vec3i)blockInfo.field_186242_a));
        }
        for (Template.BlockInfo blockInfo : template.field_186270_a) {
            BlockPos currentPos = posStart.func_177971_a((Vec3i)blockInfo.field_186242_a);
            worldIn.func_175656_a(currentPos, MaidBlocks.ALTAR.func_176223_P());
            TileEntity altarTileEntity = worldIn.func_175625_s(currentPos);
            if (!(altarTileEntity instanceof TileEntityAltar)) continue;
            if (currentPos.equals((Object)posStart.func_177973_b((Vec3i)this.getCenterPos(facing)))) {
                ((TileEntityAltar)altarTileEntity).setForgeData(blockInfo.field_186243_b, true, false, facing, posList, canPlaceItemPosList);
                continue;
            }
            if (blockInfo.field_186242_a.func_177956_o() == 2 && blockInfo.field_186243_b.equals(Blocks.field_150364_r.func_176223_P())) {
                ((TileEntityAltar)altarTileEntity).setForgeData(blockInfo.field_186243_b, false, true, facing, posList, canPlaceItemPosList);
                continue;
            }
            ((TileEntityAltar)altarTileEntity).setForgeData(blockInfo.field_186243_b, false, false, facing, posList, canPlaceItemPosList);
        }
    }

    @Override
    public boolean facingIsSuitable(EnumFacing facing) {
        return facing != EnumFacing.DOWN && facing != EnumFacing.UP;
    }

    @Override
    public BlockPos getCenterPos(EnumFacing facing) {
        switch (facing) {
            case SOUTH: {
                return NORTH_POS;
            }
            case NORTH: {
                return SOUTH_POS;
            }
            case EAST: {
                return WEST_POS;
            }
            case WEST: {
                return EAST_POS;
            }
        }
        return NORTH_POS;
    }

    @Override
    public Template getTemplate(World worldIn, EnumFacing facing) {
        switch (facing) {
            case SOUTH: {
                return this.getAltarTemplate(worldIn, ALTAR_NORTH);
            }
            case NORTH: {
                return this.getAltarTemplate(worldIn, ALTAR_SOUTH);
            }
            case EAST: {
                return this.getAltarTemplate(worldIn, ALTAR_WEST);
            }
            case WEST: {
                return this.getAltarTemplate(worldIn, ALTAR_EAST);
            }
        }
        return this.getAltarTemplate(worldIn, ALTAR_NORTH);
    }

    private Template getAltarTemplate(World worldIn, ResourceLocation resourceLocation) {
        return worldIn.func_72860_G().func_186340_h().func_186237_a(worldIn.func_73046_m(), resourceLocation);
    }
}

