/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.block;

import com.github.tartaricacid.touhoulittlemaid.TouhouLittleMaid;
import com.github.tartaricacid.touhoulittlemaid.init.MaidItems;
import com.github.tartaricacid.touhoulittlemaid.item.ItemMaidBeacon;
import com.github.tartaricacid.touhoulittlemaid.network.MaidGuiHandler;
import com.github.tartaricacid.touhoulittlemaid.tileentity.TileEntityMaidBeacon;
import java.util.Locale;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class BlockMaidBeacon
extends Block {
    public static final PropertyEnum<Position> POSITION = PropertyEnum.func_177709_a((String)"position", Position.class);
    private static final AxisAlignedBB UP_AABB = new AxisAlignedBB(0.1875, 0.0625, 0.1875, 0.8125, 1.0, 0.8125);
    private static final AxisAlignedBB DOWN_AABB = new AxisAlignedBB(0.40625, 0.0, 0.40625, 0.59375, 1.0625, 0.59375);

    public BlockMaidBeacon() {
        super(Material.field_151575_d);
        this.func_149663_c("touhou_little_maid.maid_beacon");
        this.func_149711_c(1.0f);
        this.setRegistryName("maid_beacon");
        this.func_149647_a(MaidItems.MAIN_TABS);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a(POSITION, (Comparable)((Object)Position.DOWN)));
    }

    public boolean func_180639_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (worldIn.func_175625_s(pos) instanceof TileEntityMaidBeacon) {
            playerIn.openGui((Object)TouhouLittleMaid.INSTANCE, MaidGuiHandler.OTHER_GUI.MAID_BEACON.getId(), worldIn, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
            return true;
        }
        return false;
    }

    @Nonnull
    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a(POSITION, (Comparable)((Object)Position.byPositionIndex(meta)));
    }

    public int func_176201_c(IBlockState state) {
        return ((Position)((Object)state.func_177229_b(BlockMaidBeacon.POSITION))).getPositionIndex();
    }

    @Nonnull
    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{POSITION});
    }

    public boolean hasTileEntity(IBlockState state) {
        return state.func_177229_b(POSITION) != Position.DOWN;
    }

    public TileEntity createTileEntity(World world, IBlockState state) {
        return new TileEntityMaidBeacon();
    }

    @Nonnull
    public ItemStack getPickBlock(@Nonnull IBlockState state, RayTraceResult target, @Nonnull World world, @Nonnull BlockPos pos, EntityPlayer player) {
        return new ItemStack(MaidItems.MAID_BEACON);
    }

    public boolean func_176196_c(World worldIn, @Nonnull BlockPos pos) {
        if (pos.func_177956_o() >= worldIn.func_72800_K() - 1) {
            return false;
        }
        return super.func_176196_c(worldIn, pos) && super.func_176196_c(worldIn, pos.func_177984_a());
    }

    public void func_176208_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer player) {
        boolean isBeaconUp;
        BlockPos down = pos.func_177977_b();
        BlockPos up = pos.func_177984_a();
        boolean bl = isBeaconUp = state.func_177229_b(POSITION) != Position.DOWN;
        if (player.func_184812_l_() && isBeaconUp && worldIn.func_180495_p(down).func_177230_c() == this) {
            if (player.func_184812_l_()) {
                worldIn.func_175698_g(pos);
            }
            worldIn.func_175698_g(down);
        }
        if (!isBeaconUp && worldIn.func_180495_p(up).func_177230_c() == this) {
            worldIn.func_175698_g(up);
        }
    }

    public void func_180663_b(@Nonnull World worldIn, @Nonnull BlockPos pos, @Nonnull IBlockState state) {
        TileEntity te = worldIn.func_175625_s(pos);
        if (te instanceof TileEntityMaidBeacon) {
            Block.func_180635_a((World)worldIn, (BlockPos)pos, (ItemStack)ItemMaidBeacon.tileEntityToItemStack((TileEntityMaidBeacon)te));
        }
        super.func_180663_b(worldIn, pos, state);
    }

    public int getLightValue(IBlockState state, IBlockAccess world, BlockPos pos) {
        if (state.func_177229_b(POSITION) == Position.DOWN) {
            return 0;
        }
        return 15;
    }

    public void func_189540_a(IBlockState state, World worldIn, BlockPos pos, Block blockIn, BlockPos fromPos) {
        if (state.func_177229_b(POSITION) == Position.DOWN) {
            BlockPos blockPosUp = pos.func_177984_a();
            IBlockState blockStateUp = worldIn.func_180495_p(blockPosUp);
            if (blockStateUp.func_177230_c() != this) {
                worldIn.func_175698_g(pos);
            }
        } else {
            BlockPos blockPosDown = pos.func_177977_b();
            IBlockState blockStateDown = worldIn.func_180495_p(blockPosDown);
            if (blockStateDown.func_177230_c() != this) {
                worldIn.func_175698_g(pos);
            }
        }
    }

    @Nonnull
    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        if (state.func_177229_b(POSITION) == Position.DOWN) {
            return DOWN_AABB;
        }
        return UP_AABB;
    }

    public boolean func_149637_q(IBlockState blockState) {
        return false;
    }

    public boolean func_149662_c(IBlockState blockState) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public static enum Position implements IStringSerializable
    {
        UP_N_S,
        UP_W_E,
        DOWN;


        private static Position byPositionIndex(int meta) {
            if (meta == 0) {
                return UP_N_S;
            }
            if (meta == 1) {
                return UP_W_E;
            }
            return DOWN;
        }

        public String func_176610_l() {
            return this.name().toLowerCase(Locale.US);
        }

        private int getPositionIndex() {
            return this.ordinal();
        }
    }
}

