/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.block;

import com.github.tartaricacid.touhoulittlemaid.init.MaidItems;
import com.github.tartaricacid.touhoulittlemaid.tileentity.TileEntityGrid;
import com.github.tartaricacid.touhoulittlemaid.util.MatrixUtil;
import java.util.List;
import java.util.Locale;
import javax.annotation.Nullable;
import javax.vecmath.Matrix4f;
import javax.vecmath.Point3f;
import javax.vecmath.Vector3f;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.ItemStackHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.NonNullList;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.ItemHandlerHelper;

public class BlockGrid
extends Block {
    public static final PropertyEnum<Direction> DIRECTION = PropertyEnum.func_177709_a((String)"facing", Direction.class);
    public static final PropertyBool INPUT = PropertyBool.func_177716_a((String)"input");
    public static final PropertyBool BLACKLIST = PropertyBool.func_177716_a((String)"blacklist");
    protected static final AxisAlignedBB AABB_DOWN = new AxisAlignedBB(0.0625, 0.9375, 0.0625, 0.9375, 1.0, 0.9375);
    protected static final AxisAlignedBB AABB_UP = new AxisAlignedBB(0.0625, 0.0, 0.0625, 0.9375, 0.0625, 0.9375);
    protected static final AxisAlignedBB AABB_NORTH = new AxisAlignedBB(0.0625, 0.0625, 0.9375, 0.9375, 0.9375, 1.0);
    protected static final AxisAlignedBB AABB_SOUTH = new AxisAlignedBB(0.0625, 0.0625, 0.0, 0.9375, 0.9375, 0.0625);
    protected static final AxisAlignedBB AABB_WEST = new AxisAlignedBB(0.9375, 0.0625, 0.0625, 1.0, 0.9375, 0.9375);
    protected static final AxisAlignedBB AABB_EAST = new AxisAlignedBB(0.0, 0.0625, 0.0625, 0.0625, 0.9375, 0.9375);
    public static final AxisAlignedBB[] AABBS = new AxisAlignedBB[]{AABB_DOWN, AABB_UP, AABB_NORTH, AABB_SOUTH, AABB_WEST, AABB_EAST};

    public BlockGrid() {
        super(Material.field_151571_B);
        this.setRegistryName("grid");
        this.func_149663_c("touhou_little_maid.grid");
        this.func_149672_a(SoundType.field_185852_e);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a(DIRECTION, (Comparable)((Object)Direction.UP_NORTH)).func_177226_a((IProperty)INPUT, (Comparable)Boolean.valueOf(true)).func_177226_a((IProperty)BLACKLIST, (Comparable)Boolean.valueOf(false)));
        this.func_149647_a(MaidItems.MAIN_TABS);
        this.func_149711_c(0.25f);
    }

    @SideOnly(value=Side.CLIENT)
    private static String getModeTooltip(boolean input, boolean blacklist) {
        String s = I18n.func_135052_a((String)String.format("tooltips.%s.grid.input.%s", "touhou_little_maid", input), (Object[])new Object[0]);
        s = s + " | ";
        s = s + I18n.func_135052_a((String)String.format("tooltips.%s.grid.blacklist.%s", "touhou_little_maid", blacklist), (Object[])new Object[0]);
        return s;
    }

    public boolean hasTileEntity(IBlockState state) {
        return true;
    }

    public TileEntity createTileEntity(World world, IBlockState state) {
        return new TileEntityGrid();
    }

    public BlockFaceShape func_193383_a(IBlockAccess worldIn, IBlockState state, BlockPos pos, EnumFacing face) {
        return BlockFaceShape.UNDEFINED;
    }

    public IBlockState func_176221_a(IBlockState state, IBlockAccess worldIn, BlockPos pos) {
        TileEntity tile = worldIn.func_175625_s(pos);
        if (tile instanceof TileEntityGrid) {
            TileEntityGrid grid = (TileEntityGrid)tile;
            state = state.func_177226_a((IProperty)INPUT, (Comparable)Boolean.valueOf(grid.input));
            state = state.func_177226_a((IProperty)BLACKLIST, (Comparable)Boolean.valueOf(grid.blacklist));
        }
        return state;
    }

    public boolean func_176205_b(IBlockAccess worldIn, BlockPos pos) {
        return true;
    }

    public boolean func_180639_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        TileEntity tile = worldIn.func_175625_s(pos);
        if (!(tile instanceof TileEntityGrid)) {
            return false;
        }
        TileEntityGrid grid = (TileEntityGrid)tile;
        if (playerIn.func_70093_af()) {
            for (int i = 0; i < grid.handler.getSlots(); ++i) {
                grid.handler.setStackInSlot(i, ItemStack.field_190927_a);
            }
            grid.clearCraftingResult();
            worldIn.func_184148_a(playerIn, (double)hitX, (double)hitY, (double)hitZ, SoundEvents.field_187629_cO, SoundCategory.PLAYERS, 2.0f, 1.0f);
        } else {
            boolean isInSwitchListRange;
            ItemStack stack = playerIn.func_184586_b(hand);
            Matrix4f matrix = ((Direction)((Object)state.func_177229_b(DIRECTION))).matrix();
            Point3f point = new Point3f(hitX, hitY, hitZ);
            matrix.transform(point);
            boolean isInMarkItemRange = (double)point.x > 0.1875 && (double)point.x < 0.8125 && (double)point.z > 0.1875 && (double)point.z < 0.8125;
            boolean bl = isInSwitchListRange = (double)point.x > 0.3125 && (double)point.x < 0.6875 || (double)point.z > 0.3125 && (double)point.z < 0.6875;
            if (isInMarkItemRange) {
                ItemStack copy;
                int ix = MathHelper.func_76125_a((int)((int)(((double)point.x - 0.1875) / 0.625 * 3.0)), (int)0, (int)2);
                int iz = MathHelper.func_76125_a((int)((int)(((double)point.z - 0.1875) / 0.625 * 3.0)), (int)0, (int)2);
                int i = ix + iz * 3;
                ItemStack before = grid.handler.getStackInSlot(i);
                ItemStack itemStack = copy = stack.func_190926_b() ? ItemStack.field_190927_a : ItemHandlerHelper.copyStackWithSize((ItemStack)stack, (int)1);
                if (before.func_190926_b() && copy.func_190926_b()) {
                    return false;
                }
                grid.handler.setStackInSlot(i, copy);
                grid.clearCraftingResult();
                SoundEvent soundEvent = stack.func_190926_b() ? SoundEvents.field_187629_cO : SoundEvents.field_187638_cR;
                worldIn.func_184148_a(playerIn, (double)hitX, (double)hitY, (double)hitZ, soundEvent, SoundCategory.PLAYERS, 1.0f, 1.0f);
            } else if (isInSwitchListRange) {
                grid.blacklist = !grid.blacklist;
                worldIn.func_184148_a(playerIn, (double)hitX, (double)hitY, (double)hitZ, SoundEvents.field_187722_q, SoundCategory.PLAYERS, 1.0f, 1.0f);
                if (worldIn.field_72995_K) {
                    playerIn.func_146105_b((ITextComponent)new TextComponentTranslation(String.format("message.%s.grid.blacklist.%s", "touhou_little_maid", grid.blacklist), new Object[0]), true);
                }
            } else {
                grid.input = !grid.input;
                worldIn.func_184148_a(playerIn, (double)hitX, (double)hitY, (double)hitZ, SoundEvents.field_187725_r, SoundCategory.PLAYERS, 1.0f, 1.0f);
                if (worldIn.field_72995_K) {
                    playerIn.func_146105_b((ITextComponent)new TextComponentTranslation(String.format("message.%s.grid.input.%s", "touhou_little_maid", grid.input), new Object[0]), true);
                }
            }
        }
        grid.refresh();
        return true;
    }

    public void func_189540_a(IBlockState state, World worldIn, BlockPos pos, Block blockIn, BlockPos fromPos) {
        TileEntity tile = worldIn.func_175625_s(pos);
        if (tile instanceof TileEntityGrid) {
            TileEntityGrid grid = (TileEntityGrid)tile;
            grid.updateMode(state);
        }
    }

    public void func_180653_a(World worldIn, BlockPos pos, IBlockState state, float chance, int fortune) {
    }

    public void func_180663_b(World worldIn, BlockPos pos, IBlockState state) {
        TileEntityGrid grid;
        ItemStack itemstack = new ItemStack((Block)this);
        TileEntity tile = worldIn.func_175625_s(pos);
        if (tile instanceof TileEntityGrid && !(grid = (TileEntityGrid)tile).isCleared()) {
            NBTTagCompound nbttagcompound = new NBTTagCompound();
            NBTTagCompound nbttagcompound1 = new NBTTagCompound();
            nbttagcompound.func_74782_a("BlockEntityTag", (NBTBase)grid.write(nbttagcompound1));
            itemstack.func_77982_d(nbttagcompound);
        }
        BlockGrid.func_180635_a((World)worldIn, (BlockPos)pos, (ItemStack)itemstack);
        super.func_180663_b(worldIn, pos, state);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_190948_a(ItemStack stack, @Nullable World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        super.func_190948_a(stack, worldIn, tooltip, flagIn);
        NBTTagCompound nbttagcompound = stack.func_77978_p();
        if (nbttagcompound == null || !nbttagcompound.func_150297_b("BlockEntityTag", 10)) {
            tooltip.add(BlockGrid.getModeTooltip(true, false));
            return;
        }
        NBTTagCompound tag = nbttagcompound.func_74775_l("BlockEntityTag");
        tooltip.add(BlockGrid.getModeTooltip(tag.func_74767_n("Input"), tag.func_74767_n("Blacklist")));
        if (tag.func_150297_b("Items", 9)) {
            NonNullList nonnulllist = NonNullList.func_191197_a((int)27, (Object)ItemStack.field_190927_a);
            ItemStackHelper.func_191283_b((NBTTagCompound)tag, (NonNullList)nonnulllist);
            int i = 0;
            int j = 0;
            for (ItemStack itemstack : nonnulllist) {
                if (itemstack.func_190926_b()) continue;
                ++j;
                if (i > 4) continue;
                ++i;
                tooltip.add(itemstack.func_82833_r());
            }
            if (j - i > 0) {
                tooltip.add(TextFormatting.ITALIC + I18n.func_135052_a((String)"container.shulkerBox.more", (Object[])new Object[]{j - i}));
            }
        }
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return AABBS[((Direction)((Object)state.func_177229_b(BlockGrid.DIRECTION))).face.ordinal()];
    }

    public AxisAlignedBB func_180646_a(IBlockState blockState, IBlockAccess worldIn, BlockPos pos) {
        return null;
    }

    public IBlockState getStateForPlacement(World world, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer, EnumHand hand) {
        return this.func_176223_P().func_177226_a(DIRECTION, (Comparable)((Object)Direction.byFacing(facing, placer.func_174811_aO())));
    }

    public boolean func_149730_j(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{DIRECTION, INPUT, BLACKLIST});
    }

    public int func_176201_c(IBlockState state) {
        return ((Direction)((Object)state.func_177229_b(DIRECTION))).ordinal();
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a(DIRECTION, (Comparable)((Object)Direction.VALUES[meta % 12]));
    }

    public static enum Direction implements IStringSerializable
    {
        DOWN_NORTH(EnumFacing.DOWN, EnumFacing.NORTH, 180, 0),
        DOWN_SOUTH(EnumFacing.DOWN, EnumFacing.SOUTH, 180, 180),
        DOWN_WEST(EnumFacing.DOWN, EnumFacing.WEST, 180, 90),
        DOWN_EAST(EnumFacing.DOWN, EnumFacing.EAST, 180, 270),
        UP_NORTH(EnumFacing.UP, EnumFacing.NORTH, 0, 0),
        UP_SOUTH(EnumFacing.UP, EnumFacing.SOUTH, 0, 180),
        UP_WEST(EnumFacing.UP, EnumFacing.WEST, 0, 90),
        UP_EAST(EnumFacing.UP, EnumFacing.EAST, 0, 270),
        NORTH(EnumFacing.NORTH, null, 90, 180),
        SOUTH(EnumFacing.SOUTH, null, 90, 0),
        WEST(EnumFacing.WEST, null, 90, 270),
        EAST(EnumFacing.EAST, null, 90, 90);

        public static final Direction[] VALUES;
        public final EnumFacing face;
        public final EnumFacing rot;
        public float rotX;
        public float rotY;
        private Matrix4f matrix;

        private Direction(EnumFacing face, EnumFacing rot, int rotX, int rotY) {
            this.face = face;
            this.rot = rot;
            this.rotX = rotX;
            this.rotY = rotY;
        }

        public static Direction byFacing(EnumFacing face, EnumFacing rot) {
            for (Direction direction : VALUES) {
                if (face != direction.face) continue;
                if (face.func_176736_b() >= 0) {
                    return direction;
                }
                if (rot != direction.rot) continue;
                return direction;
            }
            return UP_NORTH;
        }

        public Matrix4f matrix() {
            if (this.matrix == null) {
                this.matrix = new Matrix4f();
                this.matrix.setIdentity();
                this.matrix.m23 = -0.5f;
                this.matrix.m13 = -0.5f;
                this.matrix.m03 = -0.5f;
                Matrix4f matrix4f = new Matrix4f();
                matrix4f.setIdentity();
                MatrixUtil.rotate(this.rotX * ((float)Math.PI / 180), new Vector3f(1.0f, 0.0f, 0.0f), matrix4f, matrix4f);
                Matrix4f matrix4f1 = new Matrix4f();
                matrix4f1.setIdentity();
                MatrixUtil.rotate(this.rotY * ((float)Math.PI / 180), new Vector3f(0.0f, 1.0f, 0.0f), matrix4f1, matrix4f1);
                matrix4f.mul(matrix4f1);
                matrix4f.mul(this.matrix);
                this.matrix.invert();
                this.matrix.mul(matrix4f);
            }
            return this.matrix;
        }

        public String func_176610_l() {
            return this.toString().toLowerCase(Locale.US);
        }

        static {
            VALUES = Direction.values();
        }
    }
}

