/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.bauble;

import com.github.tartaricacid.touhoulittlemaid.api.AbstractEntityMaid;
import com.github.tartaricacid.touhoulittlemaid.api.IMaidBauble;
import com.github.tartaricacid.touhoulittlemaid.block.BlockGarageKit;
import com.github.tartaricacid.touhoulittlemaid.block.BlockTombstone;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.github.tartaricacid.touhoulittlemaid.init.MaidBlocks;
import com.github.tartaricacid.touhoulittlemaid.tileentity.TileEntityTombstone;
import com.github.tartaricacid.touhoulittlemaid.util.PlaceHelper;
import com.mojang.authlib.GameProfile;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.block.properties.IProperty;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;

public class TombstoneBauble
implements IMaidBauble {
    @Override
    public boolean onDropsPre(AbstractEntityMaid maid, ItemStack baubleItem) {
        World world = maid.field_70170_p;
        BlockPos pos = maid.func_180425_c();
        UUID ownerUuid = maid.func_184753_b();
        IItemHandler maidCapability = (IItemHandler)maid.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null);
        if (PlaceHelper.notSuitableForPlaceTombstone(world, pos) && ownerUuid != null) {
            if (!world.field_72995_K) {
                this.applyNotSuitableForPlaceTombstoneLogic(world, ownerUuid);
            }
            return false;
        }
        world.func_175656_a(pos, MaidBlocks.TOMBSTONE.func_176223_P().func_177226_a((IProperty)BlockTombstone.field_185512_D, (Comparable)maid.func_174811_aO()));
        TileEntity te = world.func_175625_s(pos);
        baubleItem.func_190918_g(1);
        if (te instanceof TileEntityTombstone && maidCapability != null && !world.field_72995_K) {
            this.applyTombstoneStorageItemLogic(maidCapability, (TileEntityTombstone)te, maid, ownerUuid);
        }
        return true;
    }

    private void applyNotSuitableForPlaceTombstoneLogic(World world, UUID ownerUuid) {
        Entity owner = FMLCommonHandler.instance().getMinecraftServerInstance().func_175576_a(ownerUuid);
        if (owner instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)owner;
            if (!world.field_72995_K) {
                player.func_145747_a((ITextComponent)new TextComponentTranslation("message.touhou_little_maid.tombstone.place_fail", new Object[0]));
            }
        }
    }

    private ItemStack getGarageKitItemStack(AbstractEntityMaid maid) {
        maid.field_70172_ad = 0;
        maid.field_70737_aN = 0;
        maid.field_70725_aQ = 0;
        NBTTagCompound entityTag = new NBTTagCompound();
        maid.func_70014_b(entityTag);
        entityTag.func_82580_o("ArmorItems");
        entityTag.func_82580_o("HandItems");
        entityTag.func_82580_o(EntityMaid.NBT.MAID_INVENTORY.getName());
        entityTag.func_82580_o(EntityMaid.NBT.MAID_SMALL_BACKPACK.getName());
        entityTag.func_82580_o(EntityMaid.NBT.MAID_MIDDLE_BACKPACK.getName());
        entityTag.func_82580_o(EntityMaid.NBT.MAID_BIG_BACKPACK.getName());
        entityTag.func_82580_o(EntityMaid.NBT.BAUBLE_INVENTORY.getName());
        return BlockGarageKit.getItemStackWithData("touhou_little_maid:entity.passive.maid", maid.getModelId(), entityTag);
    }

    private void applyTombstoneStorageItemLogic(IItemHandler maidCapability, TileEntityTombstone tombstone, AbstractEntityMaid maid, @Nullable UUID ownerUuid) {
        GameProfile gameProfile;
        for (int i = 0; i < maidCapability.getSlots(); ++i) {
            ItemStack maidItemStack = maidCapability.getStackInSlot(i);
            tombstone.handler.setStackInSlot(i, maidItemStack.func_77946_l());
            maidItemStack.func_190920_e(0);
        }
        tombstone.handler.setStackInSlot(maidCapability.getSlots(), this.getGarageKitItemStack(maid));
        if (ownerUuid != null && (gameProfile = FMLCommonHandler.instance().getMinecraftServerInstance().func_152358_ax().func_152652_a(ownerUuid)) != null) {
            tombstone.setOwnerName(gameProfile.getName());
        }
        tombstone.refresh();
        maid.func_184185_a(SoundEvents.field_187561_bM, 1.0f, 1.0f);
    }
}

