/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.api.util;

import com.github.tartaricacid.touhoulittlemaid.api.AbstractEntityMaid;
import com.github.tartaricacid.touhoulittlemaid.api.util.ItemDefinition;
import com.github.tartaricacid.touhoulittlemaid.init.MaidSoundEvent;
import java.util.LinkedHashSet;
import java.util.Random;
import java.util.stream.Collectors;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraft.util.SoundEvent;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.oredict.OreDictionary;

public final class Util {
    private Util() {
    }

    public static SoundEvent environmentSound(AbstractEntityMaid maid, SoundEvent fallback, float probability) {
        World world = maid.field_70170_p;
        Random rand = maid.func_70681_au();
        if (500L < world.func_72820_D() && world.func_72820_D() < 1500L && rand.nextFloat() < probability) {
            return MaidSoundEvent.MAID_MORNING;
        }
        if (12500L < world.func_72820_D() && world.func_72820_D() < 13500L && rand.nextFloat() < probability) {
            return MaidSoundEvent.MAID_NIGHT;
        }
        Biome biome = world.func_180494_b(maid.func_180425_c());
        if (world.func_72896_J() && biome.func_76738_d() && rand.nextFloat() < probability) {
            return MaidSoundEvent.MAID_RAIN;
        }
        if (world.func_72896_J() && biome.func_150559_j() && rand.nextFloat() < probability) {
            return MaidSoundEvent.MAID_SNOW;
        }
        if (biome.func_150561_m() == Biome.TempCategory.COLD && rand.nextFloat() < probability) {
            return MaidSoundEvent.MAID_COLD;
        }
        if (biome.func_150561_m() == Biome.TempCategory.WARM && rand.nextFloat() < probability) {
            return MaidSoundEvent.MAID_HOT;
        }
        return fallback;
    }

    public static boolean doesItemHaveOreName(ItemStack stack, String ore) {
        if (stack.func_190926_b() || !OreDictionary.doesOreNameExist((String)ore)) {
            return false;
        }
        int oreid = OreDictionary.getOreID((String)ore);
        for (int id : OreDictionary.getOreIDs((ItemStack)stack)) {
            if (oreid != id) continue;
            return true;
        }
        return false;
    }

    public static NonNullList<ItemDefinition> getItemsFromOre(String ore) {
        LinkedHashSet<ItemDefinition> set = new LinkedHashSet<ItemDefinition>();
        if (!ore.isEmpty()) {
            for (ItemStack item : OreDictionary.getOres((String)ore, (boolean)false)) {
                if (item.func_77960_j() == Short.MAX_VALUE) {
                    NonNullList subItems = NonNullList.func_191196_a();
                    item.func_77973_b().func_150895_a(item.func_77973_b().func_77640_w(), subItems);
                    set.addAll(subItems.stream().map(ItemDefinition::of).collect(Collectors.toList()));
                    continue;
                }
                set.add(ItemDefinition.of(item));
            }
        }
        return NonNullList.func_193580_a((Object)ItemDefinition.EMPTY, (Object[])set.toArray(new ItemDefinition[0]));
    }

    public static NonNullList<ItemStack> getItemsFromOre(String ore, int count) {
        return NonNullList.func_193580_a((Object)ItemStack.field_190927_a, (Object[])Util.getItemsFromOre(ore).stream().map(ItemDefinition::getItemStack).peek(i -> i.func_190920_e(count)).toArray(ItemStack[]::new));
    }
}

