/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.api.util;

import com.github.tartaricacid.touhoulittlemaid.api.util.ProcessingInput;
import com.github.tartaricacid.touhoulittlemaid.api.util.Util;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.item.ItemStack;

public class OreDictDefinition
implements ProcessingInput {
    public static final OreDictDefinition EMPTY = OreDictDefinition.of("");
    String ore;

    private OreDictDefinition(String ore) {
        this.ore = ore;
    }

    public static OreDictDefinition of(String ore) {
        return new OreDictDefinition(ore);
    }

    @Override
    public List<ItemStack> examples() {
        return this.isEmpty() ? Collections.emptyList() : Util.getItemsFromOre(this.ore, 1);
    }

    @Override
    public boolean matches(@Nonnull ItemStack stack) {
        return Util.doesItemHaveOreName(stack, this.ore);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OreDictDefinition that = (OreDictDefinition)o;
        return this.ore.equals(that.ore);
    }

    public String toString() {
        return "ore:" + (this.isEmpty() ? "null" : this.ore);
    }

    public int hashCode() {
        return this.ore.hashCode();
    }

    @Override
    public boolean isEmpty() {
        return this.ore.isEmpty();
    }
}

