/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.api.util;

import com.github.tartaricacid.touhoulittlemaid.api.util.ProcessingInput;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraftforge.registries.IRegistryDelegate;

public final class ItemDefinition
implements ProcessingInput,
Comparable<ItemDefinition> {
    public static final ItemDefinition EMPTY = ItemDefinition.of(Items.field_190931_a);
    private final IRegistryDelegate<Item> item;
    private final int metadata;

    public ItemDefinition(Item item, int metadata) {
        this.item = item.delegate;
        this.metadata = metadata;
    }

    public static ItemDefinition of(Item item) {
        return ItemDefinition.of(item, 0);
    }

    public static ItemDefinition of(ItemStack stack) {
        return stack.func_190926_b() ? EMPTY : ItemDefinition.of(stack.func_77973_b(), stack.func_77981_g() ? stack.func_77960_j() : 0);
    }

    public static ItemDefinition of(Block block) {
        return ItemDefinition.of(Item.func_150898_a((Block)block));
    }

    public static ItemDefinition of(Block block, int metadata) {
        return ItemDefinition.of(Item.func_150898_a((Block)block), metadata);
    }

    public static ItemDefinition of(Item item, int metadata) {
        return new ItemDefinition(item, metadata);
    }

    public Item getItem() {
        return (Item)this.item.get();
    }

    public int getMetadata() {
        return this.metadata;
    }

    @Override
    @Nonnull
    public List<ItemStack> examples() {
        CreativeTabs itemGroup;
        if (this.metadata == Short.MAX_VALUE && (itemGroup = ((Item)this.item.get()).func_77640_w()) != null) {
            NonNullList stacks = NonNullList.func_191196_a();
            ((Item)this.item.get()).func_150895_a(itemGroup, stacks);
            return stacks;
        }
        return Collections.singletonList(this.getItemStack());
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ItemDefinition that = (ItemDefinition)o;
        return this.item.equals(that.item) && this.metadata == that.metadata;
    }

    @Override
    public boolean matches(ItemStack stack) {
        boolean metaMatches = Short.MAX_VALUE == this.metadata || stack.func_77960_j() == this.metadata;
        return stack.func_77973_b().delegate == this.item && metaMatches;
    }

    public int hashCode() {
        return this.item.hashCode() * 31 + this.metadata;
    }

    @Override
    public int compareTo(ItemDefinition o) {
        int result = this.item.name().compareTo(o.item.name());
        return result == 0 ? this.metadata - o.metadata : result;
    }

    public String toString() {
        String metaChar = this.metadata != Short.MAX_VALUE ? Integer.toString(this.metadata) : "*";
        return this.item.name() + ":" + metaChar;
    }

    public ItemStack getItemStack() {
        int meta = this.metadata == Short.MAX_VALUE ? 0 : this.metadata;
        return new ItemStack((Item)this.item.get(), 1, meta, null);
    }

    @Override
    public boolean isEmpty() {
        return this.item.get() == Items.field_190931_a;
    }
}

