/*
 * Decompiled with CFR 0.152.
 */
package wanion.lib.common.matching.matcher;

import javax.annotation.Nonnull;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.oredict.OreDictionary;
import wanion.lib.common.matching.Matching;
import wanion.lib.common.matching.matcher.AbstractMatcher;
import wanion.lib.common.matching.matcher.ItemStackMatcher;
import wanion.lib.common.matching.matcher.MatcherEnum;

public class OreDictMatcher
extends AbstractMatcher {
    private final int[] ores;
    private int actualOre;

    public OreDictMatcher(@Nonnull Matching matching) {
        super(matching);
        this.ores = !this.matching.getStack().func_190926_b() ? OreDictionary.getOreIDs((ItemStack)this.getStack()) : new int[]{};
        this.actualOre = 0;
    }

    @Override
    public void writeToNBT(@Nonnull NBTTagCompound nbtTagCompound) {
        nbtTagCompound.func_74768_a("actualOre", this.actualOre);
    }

    @Override
    public void readFromNBT(@Nonnull NBTTagCompound nbtTagCompound) {
        this.actualOre = nbtTagCompound.func_74762_e("actualOre");
    }

    @Override
    @Nonnull
    public MatcherEnum getMatcherEnum() {
        return MatcherEnum.ORE_DICT;
    }

    @Override
    @Nonnull
    public AbstractMatcher validate() {
        return this.ores.length > 0 && this.actualOre < this.ores.length ? this : new ItemStackMatcher(this.matching);
    }

    @Override
    @Nonnull
    public AbstractMatcher next() {
        return ++this.actualOre < this.ores.length ? this : new ItemStackMatcher(this.matching);
    }

    @Override
    public boolean matches(@Nonnull ItemStack otherItemStack) {
        int[] ores = OreDictionary.getOreIDs((ItemStack)otherItemStack);
        return ores.length != 0 && this.matches(ores);
    }

    @Override
    @Nonnull
    public String getDescription() {
        return I18n.func_135052_a((String)("wanionlib.matching.matcher." + this.getMatcherEnum().name().toLowerCase()), (Object[])new Object[0]) + " " + TextFormatting.GOLD + OreDictionary.getOreName((int)this.ores[this.actualOre]);
    }

    @Override
    @Nonnull
    public String ctFormat() {
        return "<ore:" + OreDictionary.getOreName((int)this.ores[this.actualOre]) + ">";
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof OreDictMatcher) {
            OreDictMatcher oreDictMatcher = (OreDictMatcher)obj;
            if (this.actualOre != oreDictMatcher.actualOre || this.ores.length != oreDictMatcher.ores.length) {
                return false;
            }
            for (int i = 0; i < this.ores.length; ++i) {
                if (this.ores[i] == oreDictMatcher.ores[i]) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    private boolean matches(int[] ores) {
        int actualOre = this.ores[this.actualOre];
        for (int ore : ores) {
            if (ore != actualOre) continue;
            return true;
        }
        return false;
    }
}

