/*
 * Decompiled with CFR 0.152.
 */
package com.blakebr0.ironjetpacks.handler;

import java.util.HashMap;
import java.util.Map;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;

@Mod.EventBusSubscriber(modid="ironjetpacks")
public class InputHandler {
    public static final Map<EntityPlayer, Boolean> holdingUp = new HashMap<EntityPlayer, Boolean>();
    public static final Map<EntityPlayer, Boolean> holdingDown = new HashMap<EntityPlayer, Boolean>();
    public static final Map<EntityPlayer, Boolean> holdingForwards = new HashMap<EntityPlayer, Boolean>();
    public static final Map<EntityPlayer, Boolean> holdingBackwards = new HashMap<EntityPlayer, Boolean>();
    public static final Map<EntityPlayer, Boolean> holdingLeft = new HashMap<EntityPlayer, Boolean>();
    public static final Map<EntityPlayer, Boolean> holdingRight = new HashMap<EntityPlayer, Boolean>();

    public static boolean isHoldingUp(EntityPlayer player) {
        return holdingUp.containsKey(player) && holdingUp.get(player) != false;
    }

    public static boolean isHoldingDown(EntityPlayer player) {
        return holdingDown.containsKey(player) && holdingDown.get(player) != false;
    }

    public static boolean isHoldingForwards(EntityPlayer player) {
        return holdingForwards.containsKey(player) && holdingForwards.get(player) != false;
    }

    public static boolean isHoldingBackwards(EntityPlayer player) {
        return holdingBackwards.containsKey(player) && holdingBackwards.get(player) != false;
    }

    public static boolean isHoldingLeft(EntityPlayer player) {
        return holdingLeft.containsKey(player) && holdingLeft.get(player) != false;
    }

    public static boolean isHoldingRight(EntityPlayer player) {
        return holdingRight.containsKey(player) && holdingRight.get(player) != false;
    }

    public static void update(EntityPlayer player, boolean up, boolean down, boolean forwards, boolean backwards, boolean left, boolean right) {
        holdingUp.put(player, up);
        holdingDown.put(player, down);
        holdingForwards.put(player, forwards);
        holdingBackwards.put(player, backwards);
        holdingLeft.put(player, left);
        holdingRight.put(player, right);
    }

    public static void remove(EntityPlayer player) {
        holdingUp.remove(player);
        holdingDown.remove(player);
        holdingForwards.remove(player);
        holdingBackwards.remove(player);
        holdingLeft.remove(player);
        holdingRight.remove(player);
    }

    public static void clear() {
        holdingUp.clear();
        holdingDown.clear();
        holdingForwards.clear();
        holdingBackwards.clear();
        holdingLeft.clear();
        holdingRight.clear();
    }

    @SubscribeEvent
    public static void onLogout(PlayerEvent.PlayerLoggedOutEvent event) {
        InputHandler.remove(event.player);
    }

    @SubscribeEvent
    public static void onChangeDimension(PlayerEvent.PlayerChangedDimensionEvent event) {
        InputHandler.remove(event.player);
    }
}

