/*
 * Decompiled with CFR 0.152.
 */
package com.blakebr0.ironjetpacks.config.json;

import com.blakebr0.cucumber.json.SerializerBase;
import com.blakebr0.cucumber.lib.ItemPlaceholder;
import com.blakebr0.ironjetpacks.registry.Jetpack;
import com.blakebr0.ironjetpacks.registry.JetpackRegistry;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import java.lang.reflect.Type;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.registry.ForgeRegistries;

public class Serializers {
    public static final SerializerBase<Jetpack> JETPACK = new SerializerBase<Jetpack>(){

        public Jetpack deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            JsonObject obj = json.getAsJsonObject();
            String name = obj.get("name").getAsString();
            boolean disable = obj.get("disable").getAsBoolean();
            int tier = obj.get("tier").getAsInt();
            int color = Integer.parseInt(obj.get("color").getAsString(), 16);
            int armorPoints = obj.get("armorPoints").getAsInt();
            int enchantability = obj.get("enchantability").getAsInt();
            String craftingItem = obj.get("craftingMaterial").getAsString();
            ItemPlaceholder craftingMaterial = null;
            if (!craftingItem.equalsIgnoreCase("null")) {
                if (craftingItem.startsWith("ore:")) {
                    craftingMaterial = ItemPlaceholder.of((String)craftingItem.substring(4));
                } else {
                    String[] parts = craftingItem.split(":");
                    Item item = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(parts[0], parts[1]));
                    craftingMaterial = ItemPlaceholder.of((ItemStack)new ItemStack(item, 1, Integer.valueOf(parts[2]).intValue()));
                }
            }
            boolean forceRecipes = obj.get("forceRecipes").getAsBoolean();
            boolean creative = false;
            if (obj.has("creative")) {
                creative = obj.get("creative").getAsBoolean();
            }
            EnumRarity rarity = EnumRarity.COMMON;
            if (obj.has("rarity")) {
                rarity = EnumRarity.values()[obj.get("rarity").getAsInt()];
            }
            Jetpack jetpack = JetpackRegistry.createJetpack(name, tier, color, armorPoints, enchantability, craftingMaterial).setRarity(rarity).setCreative(creative);
            int capacity = obj.get("capacity").getAsInt();
            int usage = obj.get("usage").getAsInt();
            double speedVert = obj.get("speedVertical").getAsDouble();
            double accelVert = obj.get("accelVertical").getAsDouble();
            double speedSide = obj.get("speedSideways").getAsDouble();
            double speedHover = obj.get("speedHoverDescend").getAsDouble();
            double speedHoverSlow = obj.get("speedHover").getAsDouble();
            double sprintSpeed = obj.get("sprintSpeedMulti").getAsDouble();
            double sprintFuel = obj.get("sprintFuelMulti").getAsDouble();
            jetpack.setStats(capacity, usage, speedVert, accelVert, speedSide, speedHover, speedHoverSlow, sprintSpeed, sprintFuel);
            return jetpack;
        }

        public JsonElement serialize(Jetpack src, Type typeOfSrc, JsonSerializationContext context) {
            JsonObject obj = new JsonObject();
            obj.addProperty("name", src.name);
            obj.addProperty("disable", Boolean.valueOf(src.disabled));
            obj.addProperty("tier", (Number)src.tier);
            obj.addProperty("color", Integer.toHexString(src.color));
            obj.addProperty("armorPoints", (Number)src.armorPoints);
            obj.addProperty("enchantability", (Number)src.enchantablilty);
            String mat = src.craftingMaterial == null ? "null" : (!src.craftingMaterial.getOreName().isEmpty() ? "ore:" + src.craftingMaterial.getOreName() : src.craftingMaterial.getStack().func_77973_b().getRegistryName().toString() + ":" + src.craftingMaterial.getStack().func_77960_j());
            obj.addProperty("craftingMaterial", mat);
            obj.addProperty("forceRecipes", Boolean.valueOf(false));
            if (src.creative) {
                obj.addProperty("creative", Boolean.valueOf(true));
            }
            obj.addProperty("rarity", (Number)src.rarity.ordinal());
            obj.addProperty("capacity", (Number)src.capacity);
            obj.addProperty("usage", (Number)src.usage);
            obj.addProperty("speedVertical", (Number)src.speedVert);
            obj.addProperty("accelVertical", (Number)src.accelVert);
            obj.addProperty("speedSideways", (Number)src.speedSide);
            obj.addProperty("speedHoverDescend", (Number)src.speedHover);
            obj.addProperty("speedHover", (Number)src.speedHoverSlow);
            obj.addProperty("sprintSpeedMulti", (Number)src.sprintSpeed);
            obj.addProperty("sprintFuelMulti", (Number)src.sprintFuel);
            return obj;
        }

        public Type getType() {
            return Jetpack.class;
        }
    };

    public static Gson initGson() {
        GsonBuilder gson = new GsonBuilder();
        gson.setPrettyPrinting();
        gson.serializeNulls();
        gson.disableHtmlEscaping();
        gson.registerTypeAdapter(JETPACK.getType(), JETPACK);
        return gson.create();
    }
}

