/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.util;

import com.ldtteam.structures.helpers.Structure;
import com.ldtteam.structurize.util.BlockInfo;
import com.minecolonies.api.entity.ai.Status;
import com.minecolonies.api.entity.citizen.AbstractEntityCitizen;
import com.minecolonies.api.entity.pathfinding.PathResult;
import com.minecolonies.api.util.EntityUtils;
import com.minecolonies.api.util.LanguageHandler;
import com.minecolonies.api.util.Tuple;
import com.minecolonies.api.util.constant.IToolType;
import com.minecolonies.api.util.constant.ToolType;
import com.minecolonies.coremod.colony.buildings.workerbuildings.BuildingFlorist;
import com.minecolonies.coremod.entity.ai.citizen.miner.Level;
import com.minecolonies.coremod.entity.citizen.EntityCitizen;
import com.minecolonies.coremod.tileentities.TileEntityCompostedDirt;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.MoverType;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemTool;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.pathfinding.PathPoint;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntitySign;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class WorkerUtil {
    private static final double MIDDLE_BLOCK_OFFSET = 0.5;
    private static final String LEVEL_SIGN_TEXT = "{\"text\":\"level_placeholder\"}";
    private static final String LEVEL_SIGN_FIRST_ROW = "Text1";
    public static List<Tuple<ToolType, ItemStack>> tools;

    private WorkerUtil() {
    }

    public static List<Tuple<ToolType, ItemStack>> getOrInitTestTools() {
        if (tools == null) {
            tools = new ArrayList<Tuple<ToolType, ItemStack>>();
            tools.add(new Tuple<ToolType, ItemStack>(ToolType.SHOVEL, new ItemStack(Items.field_151038_n)));
            tools.add(new Tuple<ToolType, ItemStack>(ToolType.AXE, new ItemStack(Items.field_151053_p)));
            tools.add(new Tuple<ToolType, ItemStack>(ToolType.PICKAXE, new ItemStack(Items.field_151039_o)));
        }
        return tools;
    }

    public static boolean isWorkerAtSiteWithMove(@NotNull EntityCitizen worker, @NotNull BlockPos site, int range) {
        return WorkerUtil.isWorkerAtSiteWithMove(worker, site.func_177958_n(), site.func_177956_o(), site.func_177952_p(), range);
    }

    public static boolean isWorkerAtSiteWithMove(@NotNull EntityCitizen worker, int x, int y, int z, int range) {
        if (!EntityUtils.isLivingAtSiteWithMove((EntityLiving)worker, x, y, z, range)) {
            if (worker.getNavigator().func_75500_f() && !EntityUtils.tryMoveLivingToXYZ((EntityLiving)worker, x, y, z)) {
                worker.getCitizenStatusHandler().setStatus(Status.PATHFINDING_ERROR);
            }
            return false;
        }
        return true;
    }

    public static PathResult moveLivingToXYZ(@NotNull AbstractEntityCitizen citizen, @NotNull BlockPos destination) {
        return citizen.getNavigator().moveToXYZ(destination.func_177958_n(), destination.func_177956_o(), destination.func_177952_p(), 1.0);
    }

    public static boolean setSpawnPoint(@Nullable BlockPos spawnPoint, @NotNull AbstractEntityCitizen citizen) {
        if (spawnPoint == null) {
            return false;
        }
        citizen.func_70012_b((double)spawnPoint.func_177958_n() + 0.5, spawnPoint.func_177956_o(), (double)spawnPoint.func_177952_p() + 0.5, citizen.getRotationYaw(), citizen.getRotationPitch());
        citizen.getNavigator().func_75499_g();
        return true;
    }

    public static IToolType getBestToolForBlock(Block target) {
        IToolType toolType;
        String toolName = target.getHarvestTool(target.func_176223_P());
        if (toolName == null) {
            for (Tuple<ToolType, ItemStack> tool : WorkerUtil.getOrInitTestTools()) {
                if (tool.getSecond() == null || !(tool.getSecond().func_77973_b() instanceof ItemTool)) continue;
                ItemTool toolItem = (ItemTool)tool.getSecond().func_77973_b();
                if (!(tool.getSecond().func_150997_a(target.func_176223_P()) >= toolItem.field_77862_b.func_77998_b())) continue;
                toolName = tool.getFirst().getName();
                break;
            }
        }
        if ((toolType = ToolType.getToolType(toolName)) == ToolType.NONE && target.func_176223_P().func_185904_a() == Material.field_151575_d) {
            return ToolType.AXE;
        }
        if (target == Blocks.field_150405_ch || target == Blocks.field_150406_ce) {
            return ToolType.PICKAXE;
        }
        return toolType;
    }

    public static int getCorrectHavestLevelForBlock(Block target) {
        int required = target.getHarvestLevel(target.func_176223_P());
        if (required == -1 && target.func_176223_P().func_185904_a() == Material.field_151575_d || target == Blocks.field_150405_ch || target == Blocks.field_150406_ce) {
            return 0;
        }
        return required;
    }

    public static boolean isPathingTo(@NotNull AbstractEntityCitizen citizen, int x, int z) {
        PathPoint pathpoint = citizen.getNavigator().func_75505_d().func_75870_c();
        return pathpoint != null && pathpoint.field_75839_a == x && pathpoint.field_75838_c == z;
    }

    public static void faceBlock(@Nullable BlockPos block, AbstractEntityCitizen citizen) {
        if (block == null) {
            return;
        }
        double xDifference = block.func_177958_n() - citizen.func_180425_c().func_177958_n();
        double zDifference = block.func_177952_p() - citizen.func_180425_c().func_177952_p();
        double yDifference = (float)block.func_177956_o() - ((float)citizen.func_180425_c().func_177956_o() + citizen.func_70047_e());
        double squareDifference = Math.sqrt(xDifference * xDifference + zDifference * zDifference);
        double intendedRotationYaw = Math.atan2(zDifference, xDifference) * 180.0 / Math.PI - 90.0;
        double intendedRotationPitch = -(Math.atan2(yDifference, squareDifference) * 180.0 / Math.PI);
        citizen.setOwnRotation((float)EntityUtils.updateRotation(citizen.getRotationYaw(), intendedRotationYaw, 30.0), (float)EntityUtils.updateRotation(citizen.getRotationPitch(), intendedRotationPitch, 30.0));
        double goToX = xDifference > 0.0 ? 0.001 : -0.001;
        double goToZ = zDifference > 0.0 ? 0.001 : -0.001;
        citizen.func_70091_d(MoverType.SELF, (float)goToX, 0.0, (float)goToZ);
    }

    @Nullable
    public static BlockPos findFirstLevelSign(Structure structure) {
        for (int j = 0; j < structure.getHeight(); ++j) {
            for (int k = 0; k < structure.getLength(); ++k) {
                for (int i = 0; i < structure.getWidth(); ++i) {
                    NBTTagCompound teData;
                    BlockPos localPos = new BlockPos(i, j, k);
                    BlockInfo te = structure.getBlockInfo(localPos);
                    if (te == null || (teData = te.getTileEntityData()) == null || !teData.func_74779_i(LEVEL_SIGN_FIRST_ROW).equals(LEVEL_SIGN_TEXT)) continue;
                    BlockPos zeroAnchor = structure.getPosition();
                    zeroAnchor = zeroAnchor.func_177971_a((Vec3i)new BlockPos(-(structure.getWidth() / 2), 0, -(structure.getLength() / 2)));
                    return zeroAnchor.func_177971_a((Vec3i)localPos);
                }
            }
        }
        return null;
    }

    public static void updateLevelSign(World world, Level level, int levelId) {
        TileEntity te;
        BlockPos levelSignPos = level.getLevelSign();
        if (levelSignPos != null && (te = world.func_175625_s(levelSignPos)) instanceof TileEntitySign) {
            IBlockState iblockstate = world.func_180495_p(levelSignPos);
            TileEntitySign teLevelSign = (TileEntitySign)te;
            teLevelSign.field_145915_a[0] = new TextComponentString(TextFormatting.func_110646_a((String)(LanguageHandler.format("com.minecolonies.coremod.gui.workerHuts.minerMineNode", new Object[0]) + ": " + levelId)));
            teLevelSign.field_145915_a[1] = new TextComponentString(TextFormatting.func_110646_a((String)("Y: " + (level.getDepth() + 1))));
            teLevelSign.field_145915_a[2] = new TextComponentString(TextFormatting.func_110646_a((String)(LanguageHandler.format("com.minecolonies.coremod.gui.workerHuts.minerNode", new Object[0]) + ": " + level.getNumberOfBuiltNodes())));
            teLevelSign.field_145915_a[3] = new TextComponentString(TextFormatting.func_110646_a((String)""));
            teLevelSign.func_70296_d();
            world.func_184138_a(levelSignPos, iblockstate, iblockstate, 3);
        }
    }

    public static boolean isThereCompostedLand(BuildingFlorist buildingFlorist, World world) {
        for (BlockPos pos : buildingFlorist.getPlantGround()) {
            if (!world.func_175667_e(pos)) continue;
            TileEntity entity = world.func_175625_s(pos);
            if (entity instanceof TileEntityCompostedDirt) {
                if (!((TileEntityCompostedDirt)entity).isComposted()) continue;
                return true;
            }
            buildingFlorist.removePlantableGround(pos);
        }
        return false;
    }

    public static int getLastLadder(@NotNull BlockPos pos, World world) {
        if (world.func_180495_p(pos).func_177230_c().isLadder(world.func_180495_p(pos), (IBlockAccess)world, pos, null)) {
            return WorkerUtil.getLastLadder(pos.func_177977_b(), world);
        }
        return pos.func_177956_o() + 1;
    }
}

