/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.util;

import com.google.common.io.Files;
import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.IColonyManager;
import com.minecolonies.api.colony.IColonyTagCapability;
import com.minecolonies.api.colony.buildings.IBuilding;
import com.minecolonies.api.configuration.Configurations;
import com.minecolonies.api.util.Log;
import com.minecolonies.coremod.MineColonies;
import com.minecolonies.coremod.colony.Colony;
import com.minecolonies.coremod.colony.IColonyManagerCapability;
import com.minecolonies.coremod.util.ChunkDataHelper;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.fml.common.FMLCommonHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class BackUpHelper {
    private static final int MAX_COLONY_LOAD = 5000;

    private BackUpHelper() {
    }

    public static boolean backupColonyData() {
        BackUpHelper.saveColonies();
        try (FileOutputStream fos = new FileOutputStream(BackUpHelper.getBackupSaveLocation(new Date()));){
            File saveDir = new File(DimensionManager.getWorld((int)0).func_72860_G().func_75765_b(), "minecolonies");
            ZipOutputStream zos = new ZipOutputStream(fos);
            for (int dim = 0; dim < FMLCommonHandler.instance().getMinecraftServerInstance().field_71305_c.length; ++dim) {
                for (int i = 1; i <= IColonyManager.getInstance().getTopColonyId() + 1; ++i) {
                    File file = new File(saveDir, String.format("colony%d_%d.dat", i, dim));
                    File fileDeleted = new File(saveDir, String.format("colony%d_%d.dat.deleted", i, dim));
                    if (file.exists()) {
                        if (IColonyManager.getInstance().getColonyByDimension(i, dim) == null) {
                            BackUpHelper.markColonyDeleted(i, dim);
                            BackUpHelper.addToZipFile(String.format("colony%d_%d.dat.deleted", i, dim), zos, saveDir);
                            continue;
                        }
                        BackUpHelper.addToZipFile(String.format("colony%d_%d.dat", i, dim), zos, saveDir);
                        continue;
                    }
                    if (!fileDeleted.exists()) continue;
                    BackUpHelper.addToZipFile(String.format("colony%d_%d.dat.deleted", i, dim), zos, saveDir);
                }
            }
            BackUpHelper.addToZipFile(BackUpHelper.getSaveLocation().getName(), zos, saveDir);
            zos.close();
        }
        catch (Exception e) {
            Log.getLogger().warn("Unable to backup colony data, please contact an administrator", (Throwable)e);
            return false;
        }
        return true;
    }

    public static void loadMissingColonies() {
        File saveDir = new File(DimensionManager.getWorld((int)0).func_72860_G().func_75765_b(), "minecolonies");
        for (int dim = 0; dim < FMLCommonHandler.instance().getMinecraftServerInstance().field_71305_c.length; ++dim) {
            int missingFilesInRow = 0;
            for (int i = 1; i <= 5000 && missingFilesInRow < 5; ++i) {
                File file = new File(saveDir, String.format("colony%d_%d.dat", i, dim));
                if (file.exists()) {
                    missingFilesInRow = 0;
                    if (IColonyManager.getInstance().getColonyByDimension(i, dim) != null) continue;
                    BackUpHelper.loadColonyBackup(i, dim, false);
                    continue;
                }
                ++missingFilesInRow;
            }
        }
    }

    @NotNull
    private static File getBackupSaveLocation(Date date) {
        File saveDir = new File(DimensionManager.getWorld((int)0).func_72860_G().func_75765_b(), "minecolonies");
        return new File(saveDir, String.format("colonies-%s.zip", new SimpleDateFormat("yyyy-MM-dd_HH.mm.ss").format(date)));
    }

    private static void addToZipFile(String fileName, ZipOutputStream zos, File folder) {
        File file = new File(folder, fileName);
        try (FileInputStream fis = new FileInputStream(file);){
            zos.putNextEntry(new ZipEntry(fileName));
            Files.copy((File)file, (OutputStream)zos);
        }
        catch (Exception e) {
            Log.getLogger().warn("Error packing " + fileName + " into the zip.");
        }
    }

    @NotNull
    public static File getSaveLocation() {
        File saveDir = new File(DimensionManager.getWorld((int)0).func_72860_G().func_75765_b(), "minecolonies");
        return new File(saveDir, "colonies.dat");
    }

    public static void saveNBTToPath(@Nullable File file, @NotNull NBTTagCompound compound) {
        try {
            if (file != null) {
                file.getParentFile().mkdir();
                CompressedStreamTools.func_74793_a((NBTTagCompound)compound, (File)file);
            }
        }
        catch (IOException exception) {
            Log.getLogger().error("Exception when saving ColonyManager", (Throwable)exception);
        }
    }

    public static NBTTagCompound loadNBTFromPath(@Nullable File file) {
        try {
            if (file != null && file.exists()) {
                return CompressedStreamTools.func_74797_a((File)file);
            }
        }
        catch (IOException exception) {
            Log.getLogger().error("Exception when loading file from path in ColonyManager!", (Throwable)exception);
        }
        return null;
    }

    public static void saveColonies() {
        NBTTagCompound compound = new NBTTagCompound();
        IColonyManager.getInstance().writeToNBT(compound);
        File file = BackUpHelper.getSaveLocation();
        BackUpHelper.saveNBTToPath(file, compound);
        File saveDir = new File(DimensionManager.getWorld((int)0).func_72860_G().func_75765_b(), "minecolonies");
        for (IColony colony : IColonyManager.getInstance().getAllColonies()) {
            NBTTagCompound colonyCompound = new NBTTagCompound();
            colony.writeToNBT(colonyCompound);
            BackUpHelper.saveNBTToPath(new File(saveDir, String.format("colony%d_%d.dat", colony.getID(), colony.getDimension())), colonyCompound);
        }
    }

    public static void markColonyDeleted(int colonyID, int dimensionID) {
        File saveDir = new File(DimensionManager.getWorld((int)0).func_72860_G().func_75765_b(), "minecolonies");
        File todelete = new File(saveDir, String.format("colony%d_%d.dat", colonyID, dimensionID));
        if (todelete.exists()) {
            new File(saveDir, String.format("colony%d_%d.dat.deleted", colonyID, dimensionID)).delete();
            todelete.renameTo(new File(saveDir, String.format("colony%d_%d.dat.deleted", colonyID, dimensionID)));
        }
    }

    public static void loadColonyBackup(int colonyId, int dimension, boolean claimChunks) {
        File saveDir = new File(DimensionManager.getWorld((int)0).func_72860_G().func_75765_b(), "minecolonies");
        NBTTagCompound compound = BackUpHelper.loadNBTFromPath(new File(saveDir, String.format("colony%d_%d.dat", colonyId, dimension)));
        if (compound == null && (compound = BackUpHelper.loadNBTFromPath(new File(saveDir, String.format("colony%d_%d.dat.deleted", colonyId, dimension)))) == null) {
            Log.getLogger().warn("Can't find NBT of colony: " + colonyId + " at location: " + new File(saveDir, String.format("colony%d_%d.dat", colonyId, dimension)));
            return;
        }
        IColony colony = IColonyManager.getInstance().getColonyByDimension(colonyId, dimension);
        if (colony != null) {
            colony.readFromNBT(compound);
        } else {
            IColonyTagCapability cap;
            Log.getLogger().warn("Colony:" + colonyId + " is missing, loading backup!");
            WorldServer colonyWorld = FMLCommonHandler.instance().getMinecraftServerInstance().func_71218_a(dimension);
            colony = Colony.loadColony(compound, (World)colonyWorld);
            if (colony == null) {
                Log.getLogger().warn("Colony:" + colonyId + " loadBackup failed!");
                return;
            }
            ((IColonyManagerCapability)colonyWorld.getCapability(MineColonies.COLONY_MANAGER_CAP, null)).addColony(colony);
            if (claimChunks && (cap = (IColonyTagCapability)colonyWorld.func_175726_f(colony.getCenter()).getCapability(MineColonies.CLOSE_COLONY_CAP, null)) != null && cap.getOwningColony() != colonyId) {
                if (Configurations.gameplay.enableDynamicColonySizes) {
                    for (IBuilding building : colony.getBuildingManager().getBuildings().values()) {
                        ChunkDataHelper.claimColonyChunks((World)colonyWorld, true, colony.getID(), building.getPosition(), colony.getDimension(), building.getClaimRadius(building.getBuildingLevel()));
                    }
                } else {
                    ChunkDataHelper.claimColonyChunks((World)colonyWorld, true, colony.getID(), colony.getCenter(), colony.getDimension());
                }
            }
        }
        Log.getLogger().warn("Successfully restored colony:" + colonyId);
    }
}

