/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.network.messages;

import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.IColonyManager;
import com.minecolonies.api.colony.buildings.IBuilding;
import com.minecolonies.api.colony.requestsystem.requestable.Stack;
import com.minecolonies.api.util.BlockPosUtil;
import com.minecolonies.api.util.Log;
import com.minecolonies.coremod.colony.buildings.views.AbstractBuildingView;
import com.minecolonies.coremod.network.messages.AbstractMessage;
import io.netty.buffer.ByteBuf;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import org.jetbrains.annotations.NotNull;

public class PostBoxRequestMessage
extends AbstractMessage<PostBoxRequestMessage, IMessage> {
    private BlockPos buildingId;
    private int colonyId;
    private ItemStack itemStack;
    private int dimension;

    public PostBoxRequestMessage() {
    }

    public PostBoxRequestMessage(@NotNull AbstractBuildingView building, ItemStack itemStack, int quantity) {
        this.colonyId = building.getColony().getID();
        this.buildingId = building.getID();
        this.itemStack = itemStack;
        this.itemStack.func_190920_e(quantity);
        this.dimension = building.getColony().getDimension();
    }

    public void fromBytes(@NotNull ByteBuf buf) {
        this.colonyId = buf.readInt();
        this.buildingId = BlockPosUtil.readFromByteBuf(buf);
        this.itemStack = ByteBufUtils.readItemStack((ByteBuf)buf);
        this.dimension = buf.readInt();
    }

    public void toBytes(@NotNull ByteBuf buf) {
        buf.writeInt(this.colonyId);
        BlockPosUtil.writeToByteBuf(buf, this.buildingId);
        ByteBufUtils.writeItemStack((ByteBuf)buf, (ItemStack)this.itemStack);
        buf.writeInt(this.dimension);
    }

    @Override
    public void messageOnServerThread(PostBoxRequestMessage message, EntityPlayerMP player) {
        IColony colony = IColonyManager.getInstance().getColonyByDimension(message.colonyId, message.dimension);
        if (colony == null) {
            Log.getLogger().warn("TransferItemsRequestMessage colony is null");
            return;
        }
        IBuilding building = colony.getBuildingManager().getBuilding(message.buildingId);
        if (building == null) {
            Log.getLogger().warn("TransferItemsRequestMessage building is null");
            return;
        }
        building.createRequest(new Stack(message.itemStack), false);
    }
}

