/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.network.messages;

import com.minecolonies.api.colony.ICitizenData;
import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.IColonyManager;
import com.minecolonies.api.colony.buildings.IBuilding;
import com.minecolonies.api.colony.buildings.views.IBuildingView;
import com.minecolonies.api.colony.permissions.Action;
import com.minecolonies.api.util.BlockPosUtil;
import com.minecolonies.coremod.colony.buildings.workerbuildings.BuildingHome;
import com.minecolonies.coremod.network.messages.AbstractMessage;
import io.netty.buffer.ByteBuf;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import org.jetbrains.annotations.NotNull;

public class AssignUnassignMessage
extends AbstractMessage<AssignUnassignMessage, IMessage> {
    private int colonyId;
    private BlockPos buildingId;
    private boolean assign;
    private int citizenID;
    private int dimension;

    public AssignUnassignMessage() {
    }

    public AssignUnassignMessage(@NotNull IBuildingView building, boolean assign, int citizenID) {
        this.colonyId = building.getColony().getID();
        this.buildingId = building.getID();
        this.assign = assign;
        this.citizenID = citizenID;
        this.dimension = building.getColony().getDimension();
    }

    public void fromBytes(@NotNull ByteBuf buf) {
        this.colonyId = buf.readInt();
        this.buildingId = BlockPosUtil.readFromByteBuf(buf);
        this.assign = buf.readBoolean();
        this.citizenID = buf.readInt();
        this.dimension = buf.readInt();
    }

    public void toBytes(@NotNull ByteBuf buf) {
        buf.writeInt(this.colonyId);
        BlockPosUtil.writeToByteBuf(buf, this.buildingId);
        buf.writeBoolean(this.assign);
        buf.writeInt(this.citizenID);
        buf.writeInt(this.dimension);
    }

    @Override
    public void messageOnServerThread(AssignUnassignMessage message, EntityPlayerMP player) {
        IColony colony = IColonyManager.getInstance().getColonyByDimension(message.colonyId, message.dimension);
        if (colony != null) {
            if (!colony.getPermissions().hasPermission((EntityPlayer)player, Action.MANAGE_HUTS)) {
                return;
            }
            IBuilding building = colony.getBuildingManager().getBuilding(message.buildingId);
            if (!(building instanceof BuildingHome)) {
                return;
            }
            ICitizenData citizen = colony.getCitizenManager().getCitizen(message.citizenID);
            if (message.assign && !building.isFull() && !building.equals(citizen.getHomeBuilding())) {
                if (citizen.getHomeBuilding() != null) {
                    citizen.getHomeBuilding().removeCitizen(citizen);
                }
                building.assignCitizen(citizen);
            } else if (building.hasAssignedCitizen(citizen)) {
                building.removeCitizen(citizen);
            }
        }
    }
}

