/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.entity.pathfinding;

import com.minecolonies.api.entity.pathfinding.WaterPathResult;
import com.minecolonies.api.util.Pond;
import com.minecolonies.coremod.entity.pathfinding.AbstractPathJob;
import com.minecolonies.coremod.entity.pathfinding.Node;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import org.jetbrains.annotations.NotNull;

public class PathJobFindWater
extends AbstractPathJob {
    private static final int MIN_DISTANCE = 40;
    private static final int MAX_RANGE = 250;
    private final BlockPos hutLocation;
    @NotNull
    private final ArrayList<BlockPos> ponds;

    PathJobFindWater(World world, @NotNull BlockPos start, BlockPos home, int range, @NotNull List<BlockPos> ponds, EntityLivingBase entity) {
        super(world, start, start, range, new WaterPathResult(), entity);
        this.ponds = new ArrayList<BlockPos>(ponds);
        this.hutLocation = home;
    }

    private static double squareDistance(@NotNull BlockPos currentPond, @NotNull BlockPos nextPond) {
        return currentPond.func_177954_c((double)nextPond.func_177958_n(), (double)nextPond.func_177956_o(), (double)nextPond.func_177952_p());
    }

    @Override
    @NotNull
    public WaterPathResult getResult() {
        return (WaterPathResult)super.getResult();
    }

    @Override
    protected double computeHeuristic(@NotNull BlockPos pos) {
        int dx = pos.func_177958_n() - this.hutLocation.func_177958_n();
        int dy = pos.func_177956_o() - this.hutLocation.func_177956_o();
        int dz = pos.func_177952_p() - this.hutLocation.func_177952_p();
        return (double)(Math.abs(dx) + Math.abs(dy) + Math.abs(dz)) * 0.501;
    }

    @Override
    protected boolean isAtDestination(@NotNull Node n) {
        if (n.parent == null) {
            return false;
        }
        if (PathJobFindWater.squareDistance(this.hutLocation, n.pos) > 250.0) {
            return false;
        }
        if (n.pos.func_177958_n() == n.parent.pos.func_177958_n()) {
            int dz = n.pos.func_177952_p() > n.parent.pos.func_177952_p() ? 1 : -1;
            return this.isWater(n.pos.func_177982_a(0, -1, dz)) || this.isWater(n.pos.func_177982_a(-1, -1, 0)) || this.isWater(n.pos.func_177982_a(1, -1, 0));
        }
        int dx = n.pos.func_177958_n() > n.parent.pos.func_177958_n() ? 1 : -1;
        return this.isWater(n.pos.func_177982_a(dx, -1, 0)) || this.isWater(n.pos.func_177982_a(0, -1, -1)) || this.isWater(n.pos.func_177982_a(0, -1, 1));
    }

    private boolean isWater(@NotNull BlockPos newPond) {
        if (this.ponds.contains(newPond) || PathJobFindWater.pondsAreNear(this.ponds, newPond)) {
            return false;
        }
        Pond pond = Pond.createWater(this.world, newPond);
        if (pond != null) {
            this.getResult().pond = newPond;
            this.getResult().isEmpty = this.ponds.isEmpty();
            return true;
        }
        return false;
    }

    private static Predicate<BlockPos> generateDistanceFrom(int range, @NotNull BlockPos newPond) {
        return pond -> PathJobFindWater.squareDistance(pond, newPond) < (double)range;
    }

    private static boolean pondsAreNear(@NotNull ArrayList<BlockPos> ponds, @NotNull BlockPos newPond) {
        if (ponds.isEmpty()) {
            return false;
        }
        Predicate<BlockPos> compare = PathJobFindWater.generateDistanceFrom(40, newPond);
        return ponds.stream().anyMatch(compare);
    }

    @Override
    protected double getNodeResultScore(Node n) {
        return 0.0;
    }
}

