/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.entity.ai.registry;

import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import com.minecolonies.api.entity.ai.registry.IMobAIRegistry;
import com.minecolonies.api.entity.mobs.AbstractEntityMinecoloniesMob;
import com.minecolonies.api.entity.mobs.IArcherMobEntity;
import com.minecolonies.coremod.entity.ai.minimal.EntityAIOpenFenceGate;
import com.minecolonies.coremod.entity.citizen.EntityCitizen;
import com.minecolonies.coremod.entity.mobs.aitasks.EntityAIAttackArcher;
import com.minecolonies.coremod.entity.mobs.aitasks.EntityAIBreakDoor;
import com.minecolonies.coremod.entity.mobs.aitasks.EntityAIRaiderAttackMelee;
import com.minecolonies.coremod.entity.mobs.aitasks.EntityAIWalkToRandomHuts;
import com.minecolonies.coremod.util.MultimapCollector;
import java.util.List;
import java.util.function.Function;
import java.util.function.Predicate;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.player.EntityPlayer;
import org.jetbrains.annotations.NotNull;

public class MobAIRegistry
implements IMobAIRegistry {
    private final List<TaskInformationWrapper<AbstractEntityMinecoloniesMob>> mobAiTasks = Lists.newArrayList();
    private final List<TaskInformationWrapper<AbstractEntityMinecoloniesMob>> mobAiTargetTasks = Lists.newArrayList();

    public MobAIRegistry() {
        MobAIRegistry.setupMobAiTasks(this);
    }

    private static void setupMobAiTasks(IMobAIRegistry registry) {
        registry.registerNewAiTaskForMobs(0, EntityAISwimming::new).registerNewAiTaskForMobs(4, mob -> new EntityAIWalkToRandomHuts((AbstractEntityMinecoloniesMob)((Object)mob), 2.0)).registerNewAiTargetTaskForMobs(3, mob -> new EntityAIOpenFenceGate((EntityLiving)mob, true)).registerNewAiTargetTaskForMobs(3, mob -> new EntityAIBreakDoor((EntityLiving)mob)).registerNewAiTargetTaskForMobs(2, mob -> new EntityAINearestAttackableTarget((EntityCreature)mob, EntityPlayer.class, true, false)).registerNewAiTargetTaskForMobs(3, mob -> new EntityAINearestAttackableTarget((EntityCreature)mob, EntityCitizen.class, true, false)).registerNewAiTaskForMobs(5, mob -> new EntityAIWatchClosest((EntityLiving)mob, EntityPlayer.class, 8.0f)).registerNewAiTaskForMobs(6, mob -> new EntityAIWatchClosest((EntityLiving)mob, EntityCitizen.class, 8.0f)).registerNewAiTaskForMobs(1, EntityAIAttackArcher::new, mob -> mob instanceof IArcherMobEntity).registerNewAiTaskForMobs(1, EntityAIRaiderAttackMelee::new, mob -> !(mob instanceof IArcherMobEntity));
    }

    @Override
    @NotNull
    public Multimap<Integer, EntityAIBase> getEntityAiTasksForMobs(AbstractEntityMinecoloniesMob mob) {
        return (Multimap)this.mobAiTasks.stream().filter(wrapper -> ((TaskInformationWrapper)wrapper).entityPredicate.test(mob)).collect(MultimapCollector.toMultimap(TaskInformationWrapper::getPriority, wrapper -> wrapper.getAiTaskProducer().apply(mob)));
    }

    @Override
    @NotNull
    public IMobAIRegistry registerNewAiTaskForMobs(int priority, Function<AbstractEntityMinecoloniesMob, EntityAIBase> aiTaskProducer, Predicate<AbstractEntityMinecoloniesMob> applyPredicate) {
        this.mobAiTasks.add(new TaskInformationWrapper<AbstractEntityMinecoloniesMob>(priority, aiTaskProducer, applyPredicate));
        return this;
    }

    @Override
    @NotNull
    public Multimap<Integer, EntityAIBase> getEntityAiTargetTasksForMobs(AbstractEntityMinecoloniesMob mob) {
        return (Multimap)this.mobAiTargetTasks.stream().filter(wrapper -> wrapper.getEntityPredicate().test(mob)).collect(MultimapCollector.toMultimap(TaskInformationWrapper::getPriority, wrapper -> wrapper.getAiTaskProducer().apply(mob)));
    }

    @Override
    @NotNull
    public IMobAIRegistry registerNewAiTargetTaskForMobs(int priority, Function<AbstractEntityMinecoloniesMob, EntityAIBase> aiTaskProducer, Predicate<AbstractEntityMinecoloniesMob> applyPredicate) {
        this.mobAiTargetTasks.add(new TaskInformationWrapper<AbstractEntityMinecoloniesMob>(priority, aiTaskProducer, applyPredicate));
        return this;
    }

    private final class TaskInformationWrapper<M extends Entity> {
        private final int priority;
        private final Function<AbstractEntityMinecoloniesMob, EntityAIBase> aiTaskProducer;
        private final Predicate<M> entityPredicate;

        TaskInformationWrapper(int priority, Function<AbstractEntityMinecoloniesMob, EntityAIBase> aiTaskProducer, Predicate<M> entityPredicate) {
            this.priority = priority;
            this.aiTaskProducer = aiTaskProducer;
            this.entityPredicate = entityPredicate;
        }

        public int getPriority() {
            return this.priority;
        }

        public Function<AbstractEntityMinecoloniesMob, EntityAIBase> getAiTaskProducer() {
            return this.aiTaskProducer;
        }

        public Predicate<M> getEntityPredicate() {
            return this.entityPredicate;
        }
    }
}

