/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.entity.ai.citizen.guard;

import com.minecolonies.api.compatibility.tinkers.TinkersWeaponHelper;
import com.minecolonies.api.configuration.Configurations;
import com.minecolonies.api.entity.ai.citizen.guards.GuardGear;
import com.minecolonies.api.entity.ai.statemachine.AITarget;
import com.minecolonies.api.entity.ai.statemachine.states.AIWorkerState;
import com.minecolonies.api.entity.ai.statemachine.states.IAIState;
import com.minecolonies.api.util.InventoryUtils;
import com.minecolonies.api.util.ItemStackUtils;
import com.minecolonies.api.util.SoundUtils;
import com.minecolonies.api.util.constant.GuardConstants;
import com.minecolonies.api.util.constant.ToolType;
import com.minecolonies.coremod.colony.jobs.JobKnight;
import com.minecolonies.coremod.entity.ai.citizen.guard.AbstractEntityAIGuard;
import java.util.List;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EnumCreatureAttribute;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Enchantments;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemSword;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EntityDamageSource;
import net.minecraft.util.EnumHand;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.InvWrapper;
import org.jetbrains.annotations.NotNull;

public class EntityAIKnight
extends AbstractEntityAIGuard<JobKnight> {
    private static final int GUARD_ATTACK_INTERVAL = 8;

    public EntityAIKnight(@NotNull JobKnight job) {
        super(job);
        super.registerTargets(new AITarget((IAIState)AIWorkerState.GUARD_ATTACK_PROTECT, this::attackProtect, 8), new AITarget((IAIState)AIWorkerState.GUARD_ATTACK_PHYSICAL, this::attackPhysical, 8));
        this.toolsNeeded.add(ToolType.SWORD);
        for (List list : this.itemsNeeded) {
            list.add(new GuardGear(ToolType.SHIELD, EntityEquipmentSlot.MAINHAND, 0, 0, GuardConstants.SHIELD_LEVEL_RANGE, GuardConstants.SHIELD_BUILDING_LEVEL_RANGE));
        }
    }

    @Override
    public IAIState getAttackState() {
        return AIWorkerState.GUARD_ATTACK_PHYSICAL;
    }

    @Override
    protected int getAttackRange() {
        return 2;
    }

    @Override
    public boolean hasMainWeapon() {
        return InventoryUtils.getFirstSlotOfItemHandlerContainingTool((IItemHandler)new InvWrapper((IInventory)this.getInventory()), ToolType.SWORD, 0, this.buildingGuards.getMaxToolLevel()) != -1;
    }

    @Override
    public void wearWeapon() {
        int weaponSlot = InventoryUtils.getFirstSlotOfItemHandlerContainingTool((IItemHandler)new InvWrapper((IInventory)this.getInventory()), ToolType.SWORD, 0, this.buildingGuards.getMaxToolLevel());
        if (weaponSlot != -1) {
            this.worker.getCitizenItemHandler().setHeldItem(EnumHand.MAIN_HAND, weaponSlot);
        }
    }

    @Override
    protected int getAttackDelay() {
        return 32;
    }

    @Override
    @NotNull
    protected List<ItemStack> itemsNiceToHave() {
        List<ItemStack> list = super.itemsNiceToHave();
        list.add(new ItemStack(Items.field_185159_cQ, 1));
        return list;
    }

    protected IAIState attackProtect() {
        int shieldSlot = InventoryUtils.findFirstSlotInItemHandlerWith((IItemHandler)new InvWrapper((IInventory)this.getInventory()), Items.field_185159_cQ, -1);
        if (this.target != null && !this.target.field_70128_L && shieldSlot != -1) {
            this.worker.getCitizenItemHandler().setHeldItem(EnumHand.OFF_HAND, shieldSlot);
            this.worker.func_184598_c(EnumHand.OFF_HAND);
            this.worker.func_70625_a((Entity)this.target, 180.0f, 180.0f);
            this.worker.decreaseSaturationForContinuousAction();
        }
        return AIWorkerState.GUARD_ATTACK_PHYSICAL;
    }

    protected IAIState attackPhysical() {
        IAIState state = this.preAttackChecks();
        if (state != this.getState()) {
            this.worker.getNavigator().func_75499_g();
            this.worker.func_70605_aq().func_188488_a(0.0f, 0.0f);
            this.setDelay(5);
            return state;
        }
        this.moveInAttackPosition();
        this.reduceAttackDelay(8);
        if (this.currentAttackDelay > 0) {
            return AIWorkerState.GUARD_ATTACK_PROTECT;
        }
        if (!this.isInAttackDistance(this.target.func_180425_c())) {
            return this.getState();
        }
        if (this.getOwnBuilding() != null) {
            int fireLevel;
            this.currentAttackDelay = this.getAttackDelay();
            this.worker.func_70625_a((Entity)this.target, 180.0f, 180.0f);
            this.worker.func_184609_a(EnumHand.MAIN_HAND);
            this.worker.func_184185_a(SoundEvents.field_187730_dW, 1.0f, (float)SoundUtils.getRandomPitch(this.worker.getRandom()));
            double damageToBeDealt = this.getAttackDamage();
            if ((double)this.worker.func_110143_aJ() <= (double)this.worker.func_110138_aP() * 0.2) {
                damageToBeDealt *= 2.0;
            }
            EntityDamageSource source = new EntityDamageSource(this.worker.func_70005_c_(), (Entity)this.worker);
            if (Configurations.gameplay.pvp_mode && this.target instanceof EntityPlayer) {
                source.func_76348_h();
            }
            if ((fireLevel = EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_77334_n, (ItemStack)this.worker.func_184586_b(EnumHand.MAIN_HAND))) > 0) {
                this.target.func_70015_d(fireLevel * 80);
            }
            this.target.func_70097_a((DamageSource)source, (float)damageToBeDealt);
            this.target.func_70604_c((EntityLivingBase)this.worker);
            this.worker.decreaseSaturationForContinuousAction();
            this.worker.getCitizenItemHandler().damageItemInHand(EnumHand.MAIN_HAND, 1);
        }
        return AIWorkerState.GUARD_ATTACK_PHYSICAL;
    }

    private int getAttackDamage() {
        if (this.worker.getCitizenData() != null) {
            int addDmg = 0;
            ItemStack heldItem = this.worker.func_184586_b(EnumHand.MAIN_HAND);
            if (ItemStackUtils.doesItemServeAsWeapon(heldItem)) {
                addDmg = heldItem.func_77973_b() instanceof ItemSword ? (int)((float)addDmg + (((ItemSword)heldItem.func_77973_b()).func_150931_i() + 3.0f)) : (int)((double)addDmg + TinkersWeaponHelper.getDamage(heldItem));
                addDmg = (int)((double)addDmg + (double)EnchantmentHelper.func_152377_a((ItemStack)heldItem, (EnumCreatureAttribute)this.target.func_70668_bt()) / 2.5);
            }
            return (int)((double)(addDmg += this.getLevelDamage()) * Configurations.gameplay.knightDamageMult);
        }
        return (int)(3.0 * Configurations.gameplay.knightDamageMult);
    }

    @Override
    public void moveInAttackPosition() {
        this.worker.getNavigator().func_75497_a((Entity)this.target, this.getCombatMovementSpeed());
    }
}

