/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.entity.ai.citizen.florist;

import com.minecolonies.api.colony.interactionhandling.ChatPriority;
import com.minecolonies.api.colony.interactionhandling.TranslationTextComponent;
import com.minecolonies.api.entity.ai.statemachine.AITarget;
import com.minecolonies.api.entity.ai.statemachine.states.AIWorkerState;
import com.minecolonies.api.entity.ai.statemachine.states.IAIState;
import com.minecolonies.api.items.ModItems;
import com.minecolonies.api.util.BlockPosUtil;
import com.minecolonies.api.util.InventoryUtils;
import com.minecolonies.api.util.ItemStackUtils;
import com.minecolonies.coremod.colony.buildings.AbstractSchematicProvider;
import com.minecolonies.coremod.colony.buildings.workerbuildings.BuildingFlorist;
import com.minecolonies.coremod.colony.interactionhandling.StandardInteractionResponseHandler;
import com.minecolonies.coremod.colony.jobs.JobFlorist;
import com.minecolonies.coremod.entity.ai.basic.AbstractEntityAIInteract;
import com.minecolonies.coremod.tileentities.TileEntityCompostedDirt;
import com.minecolonies.coremod.util.WorkerUtil;
import net.minecraft.block.Block;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.InvWrapper;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EntityAIWorkFlorist
extends AbstractEntityAIInteract<JobFlorist> {
    private static final int INTELLIGENCE_MULTIPLIER = 1;
    private static final int CHARISMA_MULTIPLIER = 2;
    private static final long MAX_DISTANCE = 50L;
    private static final int HARVEST_ACTIONS_TO_DUMP = 10;
    private static final double PERCENT_CHANGE_FOR_GROWTH = 0.5;
    private static final double BASE_XP_GAIN = 0.5;
    private static final int COMPOST_REQUEST_QTY = 16;
    private static final int BASE_BLOCK_MINING_DELAY = 10;
    private static final double PER_LEVEL_BONUS = 0.1;
    private static final double MAX_BONUS = 5.0;
    private BlockPos harvestPosition;
    private BlockPos compostPosition;

    public EntityAIWorkFlorist(@NotNull JobFlorist job) {
        super(job);
        super.registerTargets(new AITarget((IAIState)AIWorkerState.IDLE, AIWorkerState.START_WORKING, 1), new AITarget((IAIState)AIWorkerState.START_WORKING, AIWorkerState.DECIDE, 20), new AITarget((IAIState)AIWorkerState.DECIDE, this::decide, 20), new AITarget((IAIState)AIWorkerState.FLORIST_HARVEST, this::harvest, 20), new AITarget((IAIState)AIWorkerState.FLORIST_COMPOST, this::compost, 20));
        this.worker.getCitizenExperienceHandler().setSkillModifier(2 * this.worker.getCitizenData().getCharisma() + 1 * this.worker.getCitizenData().getIntelligence());
        this.worker.func_98053_h(true);
    }

    private IAIState decide() {
        if (this.getOwnBuilding(BuildingFlorist.class).getPlantGround().isEmpty()) {
            this.worker.getCitizenData().triggerInteraction(new StandardInteractionResponseHandler((ITextComponent)new TranslationTextComponent("com.minecolonies.coremod.florist.noplantground", new Object[0]), ChatPriority.BLOCKING));
            return AIWorkerState.IDLE;
        }
        this.worker.func_184611_a(EnumHand.MAIN_HAND, ItemStack.field_190927_a);
        long distance = BlockPosUtil.getDistance2D(this.worker.func_180425_c(), ((AbstractSchematicProvider)this.getOwnBuilding()).getPosition());
        if (distance > 50L && this.walkToBuilding()) {
            return AIWorkerState.DECIDE;
        }
        int amountOfCompostInInv = InventoryUtils.getItemCountInItemHandler((IItemHandler)new InvWrapper((IInventory)this.worker.getInventoryCitizen()), ItemStackUtils.IS_COMPOST);
        if (amountOfCompostInInv <= 0) {
            int amountOfCompostInBuilding = InventoryUtils.getItemCountInProvider(this.getOwnBuilding(), ItemStackUtils.IS_COMPOST);
            if (amountOfCompostInBuilding > 0) {
                this.needsCurrently = ItemStackUtils.IS_COMPOST;
                return AIWorkerState.GATHERING_REQUIRED_MATERIALS;
            }
            this.checkIfRequestForItemExistOrCreateAsynch(new ItemStack(ModItems.compost, 16));
        }
        this.harvestPosition = this.areThereFlowersToGather();
        if (this.harvestPosition != null) {
            return AIWorkerState.FLORIST_HARVEST;
        }
        if (amountOfCompostInInv <= 0) {
            if (!WorkerUtil.isThereCompostedLand(this.getOwnBuilding(BuildingFlorist.class), this.world)) {
                this.worker.getCitizenData().triggerInteraction(new StandardInteractionResponseHandler((ITextComponent)new TranslationTextComponent("com.minecolonies.coremod.florist.nocompost", new Object[0]), ChatPriority.BLOCKING));
                return AIWorkerState.START_WORKING;
            }
            return AIWorkerState.DECIDE;
        }
        this.compostPosition = this.getFirstNotCompostedLand();
        return AIWorkerState.FLORIST_COMPOST;
    }

    private IAIState compost() {
        if (this.compostPosition == null) {
            return AIWorkerState.START_WORKING;
        }
        if (this.walkToBlock(this.compostPosition)) {
            return this.getState();
        }
        TileEntity entity = this.world.func_175625_s(this.compostPosition);
        if (entity instanceof TileEntityCompostedDirt) {
            ItemStack stack = this.getOwnBuilding(BuildingFlorist.class).getFlowerToGrow();
            if (stack != null && InventoryUtils.shrinkItemCountInItemHandler((IItemHandler)new InvWrapper((IInventory)this.worker.getInventoryCitizen()), ItemStackUtils.IS_COMPOST)) {
                ((TileEntityCompostedDirt)entity).compost(0.5, this.getOwnBuilding(BuildingFlorist.class).getFlowerToGrow());
            } else {
                this.worker.getCitizenData().triggerInteraction(new StandardInteractionResponseHandler((ITextComponent)new TranslationTextComponent("com.minecolonies.coremod.florist.noflowers", new Object[0]), ChatPriority.BLOCKING));
            }
        }
        this.worker.getCitizenExperienceHandler().addExperience(0.5);
        this.incrementActionsDone();
        this.worker.decreaseSaturationForContinuousAction();
        this.compostPosition = null;
        return AIWorkerState.START_WORKING;
    }

    private IAIState harvest() {
        if (this.harvestPosition == null) {
            return AIWorkerState.START_WORKING;
        }
        if (this.walkToBlock(this.harvestPosition)) {
            return this.getState();
        }
        if (!this.mineBlock(this.harvestPosition)) {
            return this.getState();
        }
        this.worker.getCitizenExperienceHandler().addExperience(0.5);
        this.incrementActionsDone();
        this.worker.decreaseSaturationForContinuousAction();
        this.harvestPosition = null;
        return AIWorkerState.START_WORKING;
    }

    @Override
    protected int getActionsDoneUntilDumping() {
        return 10 * ((AbstractSchematicProvider)this.getOwnBuilding()).getBuildingLevel();
    }

    @Override
    public int getBlockMiningDelay(@NotNull Block block, @NotNull BlockPos pos) {
        return 10 * (int)(1.0 + Math.max(0.0, 5.0 - 0.1 * (double)this.worker.getCitizenExperienceHandler().getLevel()));
    }

    @Nullable
    private BlockPos areThereFlowersToGather() {
        for (BlockPos pos : this.getOwnBuilding(BuildingFlorist.class).getPlantGround()) {
            if (this.world.func_175623_d(pos.func_177984_a())) continue;
            return pos.func_177984_a();
        }
        return null;
    }

    private BlockPos getFirstNotCompostedLand() {
        for (BlockPos pos : this.getOwnBuilding(BuildingFlorist.class).getPlantGround()) {
            if (!this.world.func_175667_e(pos)) continue;
            TileEntity entity = this.world.func_175625_s(pos);
            if (entity instanceof TileEntityCompostedDirt) {
                if (((TileEntityCompostedDirt)entity).isComposted()) continue;
                return pos;
            }
            this.getOwnBuilding(BuildingFlorist.class).removePlantableGround(pos);
        }
        return null;
    }
}

