/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.entity.ai.basic;

import com.minecolonies.api.colony.jobs.IJob;
import com.minecolonies.api.configuration.Configurations;
import com.minecolonies.api.entity.ai.DesiredActivity;
import com.minecolonies.api.entity.ai.Status;
import com.minecolonies.api.entity.ai.statemachine.AIOneTimeEventTarget;
import com.minecolonies.api.entity.ai.statemachine.states.AIWorkerState;
import com.minecolonies.api.entity.ai.statemachine.states.IAIState;
import com.minecolonies.api.entity.ai.statemachine.tickratestatemachine.ITickRateStateMachine;
import com.minecolonies.api.entity.ai.statemachine.tickratestatemachine.TickRateStateMachine;
import com.minecolonies.api.entity.ai.statemachine.tickratestatemachine.TickingTransition;
import com.minecolonies.api.entity.citizen.AbstractEntityCitizen;
import com.minecolonies.api.util.CompatibilityUtils;
import java.util.Arrays;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.world.World;
import org.jetbrains.annotations.NotNull;

public abstract class AbstractAISkeleton<J extends IJob>
extends EntityAIBase {
    private static final int MUTEX_MASK = 3;
    @NotNull
    protected final J job;
    @NotNull
    protected final AbstractEntityCitizen worker;
    protected final World world;
    @NotNull
    private final ITickRateStateMachine<IAIState> stateMachine;

    protected AbstractAISkeleton(@NotNull J job) {
        if (!job.getCitizen().getCitizenEntity().isPresent()) {
            throw new IllegalArgumentException("Cannot instantiate a AI from a Job that is attached to a Citizen without entity.");
        }
        this.func_75248_a(3);
        this.job = job;
        this.worker = this.job.getCitizen().getCitizenEntity().get();
        this.world = CompatibilityUtils.getWorldFromCitizen(this.worker);
        this.stateMachine = new TickRateStateMachine<AIWorkerState>(AIWorkerState.INIT, this::onException);
        this.stateMachine.setTickRate(Configurations.gameplay.updateRate);
    }

    public void registerTarget(TickingTransition target) {
        this.stateMachine.addTransition(target);
    }

    protected final void registerTargets(TickingTransition ... targets) {
        Arrays.asList(targets).forEach(this::registerTarget);
    }

    public final boolean func_75250_a() {
        return this.worker.getDesiredActivity() == DesiredActivity.WORK;
    }

    public final boolean func_75253_b() {
        return super.func_75253_b();
    }

    public final void func_75249_e() {
        this.worker.getCitizenStatusHandler().setStatus(Status.WORKING);
    }

    public final void func_75251_c() {
        this.resetAI();
    }

    public final void func_75246_d() {
        this.stateMachine.tick();
    }

    protected void onException(RuntimeException e) {
    }

    public final void func_75248_a(int mutexBits) {
        super.func_75248_a(mutexBits);
    }

    public final IAIState getState() {
        return (IAIState)this.stateMachine.getState();
    }

    public int getTickRate() {
        return this.stateMachine.getTickRate();
    }

    public void resetAI() {
        this.stateMachine.addTransition(new AIOneTimeEventTarget(AIWorkerState.IDLE));
    }
}

