/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.colony.requestsystem.resolvers;

import com.google.common.collect.Lists;
import com.google.common.reflect.TypeToken;
import com.minecolonies.api.colony.ICitizenData;
import com.minecolonies.api.colony.requestsystem.location.ILocation;
import com.minecolonies.api.colony.requestsystem.manager.IRequestManager;
import com.minecolonies.api.colony.requestsystem.request.IRequest;
import com.minecolonies.api.colony.requestsystem.requestable.Delivery;
import com.minecolonies.api.colony.requestsystem.token.IToken;
import com.minecolonies.api.util.BlockPosUtil;
import com.minecolonies.coremod.MineColonies;
import com.minecolonies.coremod.colony.Colony;
import com.minecolonies.coremod.colony.jobs.JobDeliveryman;
import com.minecolonies.coremod.colony.requestsystem.resolvers.core.AbstractRequestResolver;
import java.util.Comparator;
import java.util.List;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DeliveryRequestResolver
extends AbstractRequestResolver<Delivery> {
    public DeliveryRequestResolver(@NotNull ILocation location, @NotNull IToken<?> token) {
        super(location, token);
    }

    @Override
    public TypeToken<? extends Delivery> getRequestType() {
        return TypeToken.of(Delivery.class);
    }

    @Override
    public boolean canResolveRequest(@NotNull IRequestManager manager, IRequest<? extends Delivery> requestToCheck) {
        if (manager.getColony().getWorld().field_72995_K) {
            return false;
        }
        Colony colony = (Colony)manager.getColony();
        ICitizenData freeDeliveryMan = colony.getCitizenManager().getCitizens().stream().filter(citizenData -> citizenData.getCitizenEntity().map(entityCitizen -> ((Delivery)requestToCheck.getRequest()).getTarget().isReachableFromLocation(entityCitizen.getLocation())).orElse(false)).filter(c -> c.getJob() instanceof JobDeliveryman).findFirst().orElse(null);
        return freeDeliveryMan != null;
    }

    @Override
    @Nullable
    public List<IToken<?>> attemptResolveRequest(@NotNull IRequestManager manager, @NotNull IRequest<? extends Delivery> request) {
        if (manager.getColony().getWorld().field_72995_K) {
            return null;
        }
        Colony colony = (Colony)manager.getColony();
        ICitizenData freeDeliveryMan = colony.getCitizenManager().getCitizens().stream().filter(citizenData -> citizenData.getCitizenEntity().map(entityCitizen -> ((Delivery)request.getRequest()).getTarget().isReachableFromLocation(entityCitizen.getLocation())).orElse(false)).filter(c -> c.getJob() instanceof JobDeliveryman).filter(c -> ((JobDeliveryman)c.getJob()).isActive()).min(Comparator.comparing(c -> ((JobDeliveryman)c.getJob()).getTaskQueue().size()).thenComparing(Comparator.comparing(c -> {
            BlockPos targetPos = ((Delivery)request.getRequest()).getTarget().getInDimensionLocation();
            BlockPos entityLocation = c.getCitizenEntity().get().getLocation().getInDimensionLocation();
            return BlockPosUtil.getDistanceSquared(targetPos, entityLocation);
        }))).orElse(null);
        if (freeDeliveryMan == null) {
            return null;
        }
        JobDeliveryman job = (JobDeliveryman)freeDeliveryMan.getJob();
        job.addRequest((IToken<?>)request.getId());
        return Lists.newArrayList();
    }

    @Override
    public void resolveRequest(@NotNull IRequestManager manager, @NotNull IRequest<? extends Delivery> request) throws RuntimeException {
    }

    @Override
    @Nullable
    public List<IRequest<?>> getFollowupRequestForCompletion(@NotNull IRequestManager manager, @NotNull IRequest<? extends Delivery> completedRequest) {
        return null;
    }

    @Override
    @Nullable
    public void onAssignedRequestBeingCancelled(@NotNull IRequestManager manager, @NotNull IRequest<? extends Delivery> request) {
    }

    @Override
    public void onAssignedRequestCancelled(@NotNull IRequestManager manager, @NotNull IRequest<? extends Delivery> request) {
        if (!manager.getColony().getWorld().field_72995_K) {
            Colony colony = (Colony)manager.getColony();
            ICitizenData freeDeliveryMan = colony.getCitizenManager().getCitizens().stream().filter(c -> c.getJob() instanceof JobDeliveryman && ((JobDeliveryman)c.getJob()).getTaskQueue().contains(request.getId())).findFirst().orElse(null);
            if (freeDeliveryMan == null) {
                MineColonies.getLogger().error("Parent cancellation of delivery request failed! Unknown request: " + request.getId());
            } else {
                JobDeliveryman job = (JobDeliveryman)freeDeliveryMan.getJob();
                job.onTaskDeletion((IToken<?>)request.getId());
            }
        }
    }

    @Override
    @NotNull
    public void onRequestedRequestComplete(@NotNull IRequestManager manager, @NotNull IRequest<?> request) {
    }

    @Override
    @NotNull
    public void onRequestedRequestCancelled(@NotNull IRequestManager manager, @NotNull IRequest<?> request) {
    }

    @Override
    @NotNull
    public ITextComponent getRequesterDisplayName(@NotNull IRequestManager manager, @NotNull IRequest<?> request) {
        return new TextComponentTranslation("com.minecolonies.coremod.job.Deliveryman", new Object[0]);
    }
}

