/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.colony.managers;

import com.ldtteam.structures.helpers.Structure;
import com.ldtteam.structurize.Structurize;
import com.ldtteam.structurize.items.ItemScanTool;
import com.ldtteam.structurize.management.StructureName;
import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.managers.interfaces.IEventStructureManager;
import com.minecolonies.api.util.BlockPosUtil;
import com.minecolonies.api.util.InstantStructurePlacer;
import com.minecolonies.api.util.Log;
import com.minecolonies.coremod.colony.managers.EventManager;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.Mirror;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import org.jetbrains.annotations.NotNull;

public class EventStructureManager
implements IEventStructureManager {
    private static final String TAG_EVENT_STRUCTURE_MANAGER = "eventstructure_manager";
    public static final String STRUCTURE_BACKUP_FOLDER = "structbackup";
    private final Map<BlockPos, Integer> backupSchematics = new HashMap<BlockPos, Integer>();
    private final EventManager eventManager;
    private final IColony colony;

    public EventStructureManager(EventManager eventManager, IColony colony) {
        this.eventManager = eventManager;
        this.colony = colony;
    }

    @Override
    public boolean spawnTemporaryStructure(Structure structure, String schematicPath, BlockPos targetSpawnPoint, int eventID, int rotations, Mirror mirror) {
        if (this.eventManager.getEventByID(eventID) == null) {
            return false;
        }
        World world = this.colony.getWorld();
        String backupPath = "schematicsstructbackup" + this.colony.getID() + this.colony.getDimension() + targetSpawnPoint.func_177979_c(3);
        if (!ItemScanTool.saveStructureOnServer((World)world, (BlockPos)targetSpawnPoint.func_177982_a(structure.getWidth() - 1, structure.getHeight(), structure.getLength() - 1).func_177973_b((Vec3i)structure.getOffset()), (BlockPos)targetSpawnPoint.func_177979_c(3).func_177973_b((Vec3i)structure.getOffset()), (String)backupPath, (boolean)false)) {
            Log.getLogger().info("Failed to save schematics for event");
            return false;
        }
        this.backupSchematics.put(targetSpawnPoint.func_177979_c(3), eventID);
        InstantStructurePlacer.loadAndPlaceStructureWithRotation(world, schematicPath, targetSpawnPoint.func_177979_c(3), rotations, mirror, false);
        return true;
    }

    @Override
    public void loadBackupForEvent(int eventID) {
        Iterator<Map.Entry<BlockPos, Integer>> iterator = this.backupSchematics.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<BlockPos, Integer> entry = iterator.next();
            if (entry.getValue() != eventID) continue;
            String backupPath = String.valueOf(this.colony.getID()) + this.colony.getDimension() + entry.getKey();
            String fileName = new StructureName("cache", "backup", "schematicsstructbackup").toString() + backupPath;
            InstantStructurePlacer.loadAndPlaceStructureWithRotation(this.colony.getWorld(), fileName, entry.getKey(), 0, Mirror.NONE, true);
            try {
                Structurize.proxy.getSchematicsFolder().toPath().resolve(fileName + ".blueprint").toFile().delete();
            }
            catch (Exception e) {
                Log.getLogger().info("Minor issue: Failed at deleteing a backup schematic at " + fileName, (Throwable)e);
            }
            iterator.remove();
        }
    }

    @Override
    public void readFromNBT(@NotNull NBTTagCompound compound) {
        if (compound.func_74764_b(TAG_EVENT_STRUCTURE_MANAGER)) {
            this.backupSchematics.clear();
            NBTTagCompound structureManagerCompound = compound.func_74775_l(TAG_EVENT_STRUCTURE_MANAGER);
            NBTTagList schematicTags = structureManagerCompound.func_150295_c("ships", 10);
            for (NBTBase base : schematicTags) {
                NBTTagCompound tagCompound = (NBTTagCompound)base;
                BlockPos pos = BlockPosUtil.readFromNBT(tagCompound, "pos");
                int eventID = tagCompound.func_74762_e("mc_event_id");
                if (this.eventManager.getEventByID(eventID) != null) {
                    this.backupSchematics.put(pos, eventID);
                    continue;
                }
                this.loadBackupForEvent(eventID);
                Log.getLogger().debug("Discarding schematic backup for event id:" + eventID + " seems the event went missing.");
            }
        }
    }

    @Override
    public void writeToNBT(@NotNull NBTTagCompound compound) {
        NBTTagCompound structureManagerCompound = new NBTTagCompound();
        NBTTagList schematicTagList = new NBTTagList();
        for (Map.Entry<BlockPos, Integer> entry : this.backupSchematics.entrySet()) {
            NBTTagCompound entryCompound = new NBTTagCompound();
            entryCompound.func_74768_a("mc_event_id", entry.getValue().intValue());
            BlockPosUtil.writeToNBT(entryCompound, "pos", entry.getKey());
            schematicTagList.func_74742_a((NBTBase)entryCompound);
        }
        structureManagerCompound.func_74782_a("ships", (NBTBase)schematicTagList);
        compound.func_74782_a(TAG_EVENT_STRUCTURE_MANAGER, (NBTBase)structureManagerCompound);
    }
}

