/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.colony.colonyEvents.raidEvents.pirateEvent;

import com.ldtteam.structures.helpers.Structure;
import com.ldtteam.structurize.util.PlacementSettings;
import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.colonyEvents.EventStatus;
import com.minecolonies.api.colony.colonyEvents.IColonyEvent;
import com.minecolonies.api.colony.colonyEvents.IColonyRaidEvent;
import com.minecolonies.api.colony.colonyEvents.IColonyStructureSpawnEvent;
import com.minecolonies.api.configuration.Configurations;
import com.minecolonies.api.entity.mobs.AbstractEntityMinecoloniesMob;
import com.minecolonies.api.entity.mobs.RaiderMobUtils;
import com.minecolonies.api.util.BlockPosUtil;
import com.minecolonies.api.util.LanguageHandler;
import com.minecolonies.api.util.Tuple;
import com.minecolonies.coremod.colony.ColonyState;
import com.minecolonies.coremod.colony.colonyEvents.raidEvents.pirateEvent.PirateEventUtils;
import com.minecolonies.coremod.colony.colonyEvents.raidEvents.pirateEvent.ShipSize;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.WeakHashMap;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.init.MobEffects;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.PotionEffect;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityMobSpawner;
import net.minecraft.util.Mirror;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.fml.common.registry.EntityRegistry;
import org.jetbrains.annotations.NotNull;

public class PirateRaidEvent
implements IColonyRaidEvent,
IColonyStructureSpawnEvent {
    public static final ResourceLocation PIRATE_RAID_EVENT_TYPE_ID = new ResourceLocation("minecolonies", "pirate_raid");
    public static final String TAG_DAYS_LEFT = "pirateDaysLeft";
    public static final String TAG_SPAWNER_COUNT = "spawnerCount";
    public static final String TAG_SHIPSIZE = "shipSize";
    private static final int MAX_LANDING_DISTANCE = 200;
    private static final int MIN_CENTER_DISTANCE = 200;
    private static final int ADD_MAX_PIRATES = 10;
    private EventStatus status = EventStatus.STARTING;
    private int id = 0;
    private IColony colony;
    private BlockPos spawnPoint;
    private ShipSize shipSize;
    private int spawnerCount;
    private int daysToGo;
    Map<Entity, UUID> pirates;
    List<Tuple<ResourceLocation, BlockPos>> respawns;

    public PirateRaidEvent(@NotNull IColony colony) {
        this.daysToGo = Configurations.gameplay.daysUntilPirateshipsDespawn;
        this.pirates = new WeakHashMap<Entity, UUID>();
        this.respawns = new ArrayList<Tuple<ResourceLocation, BlockPos>>();
        this.colony = colony;
        this.id = colony.getEventManager().getAndTakeNextEventID();
    }

    @Override
    public void onStart() {
        this.status = EventStatus.PROGRESSING;
        this.daysToGo = Configurations.gameplay.daysUntilPirateshipsDespawn;
        this.spawnerCount = this.shipSize.spawnerCount;
        Structure structure = new Structure(this.colony.getWorld(), "schematics/ships/" + this.shipSize.schematicName, new PlacementSettings());
        structure.rotate(BlockPosUtil.getRotationFromRotations(0), this.colony.getWorld(), this.spawnPoint, Mirror.NONE);
        if (!PirateEventUtils.canPlaceShipAt(this.spawnPoint, structure, (IBlockAccess)this.colony.getWorld())) {
            this.spawnPoint = this.spawnPoint.func_177977_b();
        }
        if (!PirateEventUtils.spawnPirateShip(this.spawnPoint, this.colony.getWorld(), this.colony, this.shipSize.schematicName, this.id)) {
            this.status = EventStatus.CANCELED;
            return;
        }
        LanguageHandler.sendPlayersMessage(this.colony.getImportantMessageEntityPlayers(), "event.minecolonies.raidMessage_p" + this.shipSize.messageID, BlockPosUtil.calcDirection(this.colony.getCenter(), this.spawnPoint), this.colony.getName());
        this.colony.markDirty();
    }

    @Override
    public void onUpdate() {
        BlockPos spawnPos;
        this.colony.getRaiderManager().setNightsSinceLastRaid(0);
        if (!this.respawns.isEmpty()) {
            for (Tuple<ResourceLocation, BlockPos> entry : this.respawns) {
                BlockPos spawnPos2 = PirateEventUtils.getLoadedPositionTowardsCenter(entry.getSecond(), this.colony, 200, this.spawnPoint, 200, 10);
                if (spawnPos2 == null) continue;
                RaiderMobUtils.spawn(entry.getFirst(), 1, spawnPos2, this.colony.getWorld(), this.colony, this.id);
            }
            this.respawns.clear();
            return;
        }
        if (this.pirates.size() < this.spawnerCount * 2 && (spawnPos = PirateEventUtils.getLoadedPositionTowardsCenter(this.spawnPoint.func_177982_a(0, 0, -2), this.colony, 200, this.spawnPoint, 200, 10)) != null) {
            for (ResourceLocation mobType : this.shipSize.pirates) {
                RaiderMobUtils.spawn(mobType, 1, spawnPos, this.colony.getWorld(), this.colony, this.id);
            }
        }
        if (this.colony.getRaiderManager().areSpiesEnabled()) {
            for (Entity entity : this.getEntities()) {
                if (!(entity instanceof EntityLivingBase)) continue;
                ((EntityLivingBase)entity).func_70690_d(new PotionEffect(MobEffects.field_188423_x, 550));
            }
        }
    }

    @Override
    public void onFinish() {
        LanguageHandler.sendPlayersMessage(this.colony.getImportantMessageEntityPlayers(), "com.minecolonies.coremod.pirates.sailing.away", BlockPosUtil.calcDirection(this.colony.getCenter(), this.spawnPoint), this.colony.getName(), this.colony.getName());
        for (Entity entity : this.pirates.keySet()) {
            entity.func_130014_f_().func_175667_e(entity.func_180425_c());
            entity.func_70106_y();
        }
    }

    @Override
    public void onTileEntityBreak(TileEntity te) {
        if (te instanceof TileEntityMobSpawner) {
            --this.spawnerCount;
            if (this.spawnerCount <= 0) {
                this.daysToGo = 1;
            }
        }
    }

    @Override
    public void onNightFall() {
        --this.daysToGo;
        if (this.daysToGo <= 0) {
            this.status = EventStatus.DONE;
        }
    }

    @Override
    public void onEntityDeath(EntityLiving entity) {
        this.pirates.remove(entity);
    }

    @Override
    public void registerEntity(Entity entity) {
        if (!(entity instanceof AbstractEntityMinecoloniesMob) || !entity.func_70089_S()) {
            entity.func_70106_y();
            return;
        }
        if (this.pirates.keySet().size() < this.getMaxPirates()) {
            this.pirates.put(entity, entity.func_110124_au());
        } else {
            entity.func_70106_y();
        }
    }

    @Override
    public void unregisterEntity(Entity entity) {
        if (!this.pirates.containsKey(entity) || this.status != EventStatus.PROGRESSING || this.colony.getState() != ColonyState.ACTIVE) {
            return;
        }
        this.pirates.remove(entity);
        ResourceLocation entityID = EntityRegistry.getEntry(entity.getClass()).getRegistryName();
        this.respawns.add(new Tuple<ResourceLocation, BlockPos>(entityID, entity.func_180425_c()));
    }

    private int getMaxPirates() {
        return this.spawnerCount * 2 + 10;
    }

    public void setShipSize(ShipSize shipSize) {
        this.shipSize = shipSize;
    }

    @Override
    public void setColony(@NotNull IColony colony) {
        this.colony = colony;
    }

    @Override
    public void setSpawnPoint(BlockPos spawnPoint) {
        this.spawnPoint = spawnPoint;
    }

    @Override
    public BlockPos getSpawnPos() {
        return this.spawnPoint;
    }

    @Override
    public List<Entity> getEntities() {
        return new ArrayList<Entity>(this.pirates.keySet());
    }

    @Override
    public EventStatus getStatus() {
        return this.status;
    }

    @Override
    public void setStatus(EventStatus status) {
        this.status = status;
    }

    @Override
    public int getID() {
        return this.id;
    }

    @Override
    public ResourceLocation getEventTypeID() {
        return PIRATE_RAID_EVENT_TYPE_ID;
    }

    @Override
    public List<Tuple<String, BlockPos>> getSchematicSpawns() {
        ArrayList<Tuple<String, BlockPos>> paths = new ArrayList<Tuple<String, BlockPos>>();
        paths.add(new Tuple<String, BlockPos>("schematics/ships/" + this.shipSize.schematicName, this.spawnPoint));
        return paths;
    }

    @Override
    public NBTTagCompound writeToNBT(NBTTagCompound compound) {
        compound.func_74768_a("mc_event_id", this.id);
        compound.func_74768_a(TAG_DAYS_LEFT, this.daysToGo);
        compound.func_74768_a("eventStatus", this.status.ordinal());
        compound.func_74768_a(TAG_SPAWNER_COUNT, this.spawnerCount);
        BlockPosUtil.writeToNBT(compound, "spawnPos", this.spawnPoint);
        compound.func_74768_a(TAG_SHIPSIZE, this.shipSize.ordinal());
        return compound;
    }

    @Override
    public void readFromNBT(NBTTagCompound compound) {
        this.id = compound.func_74762_e("mc_event_id");
        this.status = EventStatus.values()[compound.func_74762_e("eventStatus")];
        this.daysToGo = compound.func_74762_e(TAG_DAYS_LEFT);
        this.spawnerCount = compound.func_74762_e(TAG_SPAWNER_COUNT);
        this.spawnPoint = BlockPosUtil.readFromNBT(compound, "spawnPos");
        this.shipSize = ShipSize.values()[compound.func_74762_e(TAG_SHIPSIZE)];
    }

    public static IColonyEvent loadFromNBT(@NotNull IColony colony, @NotNull NBTTagCompound compound) {
        PirateRaidEvent raidEvent = new PirateRaidEvent(colony);
        raidEvent.readFromNBT(compound);
        return raidEvent;
    }
}

