/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.colony.buildings.workerbuildings;

import com.minecolonies.api.colony.ICitizenData;
import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.IColonyView;
import com.minecolonies.api.colony.buildings.IBuildingWorker;
import com.minecolonies.api.colony.buildings.ModBuildings;
import com.minecolonies.api.colony.buildings.registry.BuildingEntry;
import com.minecolonies.api.colony.jobs.IJob;
import com.minecolonies.blockout.views.Window;
import com.minecolonies.coremod.client.gui.WindowHutWorkerPlaceholder;
import com.minecolonies.coremod.colony.buildings.AbstractBuildingWorker;
import com.minecolonies.coremod.colony.jobs.JobSwineHerder;
import net.minecraft.util.math.BlockPos;
import org.jetbrains.annotations.NotNull;

public class BuildingSwineHerder
extends AbstractBuildingWorker {
    private static final String JOB = "SwineHerder";
    private static final String HUT_NAME = "swineHerderHut";
    private static final int MAX_BUILDING_LEVEL = 5;

    public BuildingSwineHerder(IColony c, BlockPos l) {
        super(c, l);
    }

    @Override
    @NotNull
    public String getSchematicName() {
        return JOB;
    }

    @Override
    public int getMaxBuildingLevel() {
        return 5;
    }

    @Override
    @NotNull
    public String getJobName() {
        return JOB;
    }

    @Override
    @NotNull
    public IJob createJob(ICitizenData citizen) {
        return new JobSwineHerder(citizen);
    }

    @Override
    public BuildingEntry getBuildingRegistryEntry() {
        return ModBuildings.swineHerder;
    }

    public static class View
    extends AbstractBuildingWorker.View {
        public View(IColonyView c, BlockPos l) {
            super(c, l);
        }

        @Override
        @NotNull
        public Window getWindow() {
            return new WindowHutWorkerPlaceholder<View>(this, BuildingSwineHerder.HUT_NAME);
        }

        @Override
        @NotNull
        public IBuildingWorker.Skill getPrimarySkill() {
            return IBuildingWorker.Skill.DEXTERITY;
        }

        @Override
        @NotNull
        public IBuildingWorker.Skill getSecondarySkill() {
            return IBuildingWorker.Skill.STRENGTH;
        }
    }
}

