/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.colony.buildings.workerbuildings;

import com.minecolonies.api.colony.ICitizenData;
import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.IColonyManager;
import com.minecolonies.api.colony.IColonyView;
import com.minecolonies.api.colony.buildings.IBuildingWorker;
import com.minecolonies.api.colony.buildings.ModBuildings;
import com.minecolonies.api.colony.buildings.registry.BuildingEntry;
import com.minecolonies.api.colony.jobs.IJob;
import com.minecolonies.api.util.ItemStackUtils;
import com.minecolonies.blockout.views.Window;
import com.minecolonies.coremod.client.gui.WindowHutSmelter;
import com.minecolonies.coremod.colony.buildings.AbstractBuildingFurnaceUser;
import com.minecolonies.coremod.colony.buildings.views.AbstractFilterableListsView;
import com.minecolonies.coremod.colony.jobs.JobSmelter;
import java.util.Random;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemSword;
import net.minecraft.item.ItemTool;
import net.minecraft.tileentity.TileEntityFurnace;
import net.minecraft.util.Tuple;
import net.minecraft.util.math.BlockPos;
import org.jetbrains.annotations.NotNull;

public class BuildingSmeltery
extends AbstractBuildingFurnaceUser {
    private static final String SMELTERY_DESC = "Smeltery";
    private static final int MAX_BUILDING_LEVEL = 5;
    private static final int STUFF_TO_KEEP = 10;

    public BuildingSmeltery(IColony c, BlockPos l) {
        super(c, l);
        this.keepX.put(IColonyManager.getInstance().getCompatibilityManager()::isOre, new Tuple((Object)Integer.MAX_VALUE, (Object)true));
        this.keepX.put(TileEntityFurnace::func_145954_b, new Tuple((Object)Integer.MAX_VALUE, (Object)true));
        this.keepX.put(stack -> ItemStackUtils.isEmpty(stack) == false && (stack.func_77973_b() instanceof ItemSword || stack.func_77973_b() instanceof ItemTool || stack.func_77973_b() instanceof ItemArmor), new Tuple((Object)10, (Object)true));
    }

    @Override
    @NotNull
    public String getSchematicName() {
        return SMELTERY_DESC;
    }

    @Override
    public int getMaxBuildingLevel() {
        return 5;
    }

    @Override
    @NotNull
    public IJob createJob(ICitizenData citizen) {
        return new JobSmelter(citizen);
    }

    @Override
    @NotNull
    public String getJobName() {
        return SMELTERY_DESC;
    }

    public int ingotMultiplier(int citizenLevel, Random random) {
        switch (this.getBuildingLevel()) {
            case 1: {
                return random.nextInt(100 - citizenLevel) == 0 ? 2 : 1;
            }
            case 2: {
                return random.nextInt(100 - citizenLevel * 2) == 2 ? 2 : 1;
            }
            case 3: {
                return 2;
            }
            case 4: 
            case 5: {
                return random.nextInt(100 - citizenLevel) == 0 ? 3 : 2;
            }
        }
        return 1;
    }

    @Override
    public BuildingEntry getBuildingRegistryEntry() {
        return ModBuildings.smeltery;
    }

    public static class View
    extends AbstractFilterableListsView {
        public View(IColonyView c, BlockPos l) {
            super(c, l);
        }

        @Override
        @NotNull
        public Window getWindow() {
            return new WindowHutSmelter(this);
        }

        @Override
        @NotNull
        public IBuildingWorker.Skill getPrimarySkill() {
            return IBuildingWorker.Skill.STRENGTH;
        }

        @Override
        @NotNull
        public IBuildingWorker.Skill getSecondarySkill() {
            return IBuildingWorker.Skill.INTELLIGENCE;
        }
    }
}

