/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.colony;

import com.minecolonies.api.colony.CompactColonyReference;
import com.minecolonies.api.colony.HappinessData;
import com.minecolonies.api.colony.ICitizenDataManager;
import com.minecolonies.api.colony.ICitizenDataView;
import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.IColonyManager;
import com.minecolonies.api.colony.IColonyTagCapability;
import com.minecolonies.api.colony.IColonyView;
import com.minecolonies.api.colony.buildings.IBuilding;
import com.minecolonies.api.colony.buildings.registry.IBuildingDataManager;
import com.minecolonies.api.colony.buildings.views.IBuildingView;
import com.minecolonies.api.colony.buildings.workerbuildings.ITownHallView;
import com.minecolonies.api.colony.managers.interfaces.IBuildingManager;
import com.minecolonies.api.colony.managers.interfaces.ICitizenManager;
import com.minecolonies.api.colony.managers.interfaces.IColonyHappinessManager;
import com.minecolonies.api.colony.managers.interfaces.IColonyPackageManager;
import com.minecolonies.api.colony.managers.interfaces.IEventManager;
import com.minecolonies.api.colony.managers.interfaces.IProgressManager;
import com.minecolonies.api.colony.managers.interfaces.IRaiderManager;
import com.minecolonies.api.colony.managers.interfaces.IStatisticAchievementManager;
import com.minecolonies.api.colony.permissions.Action;
import com.minecolonies.api.colony.permissions.IPermissions;
import com.minecolonies.api.colony.permissions.Player;
import com.minecolonies.api.colony.permissions.Rank;
import com.minecolonies.api.colony.requestsystem.manager.IRequestManager;
import com.minecolonies.api.colony.requestsystem.requester.IRequester;
import com.minecolonies.api.colony.workorders.IWorkManager;
import com.minecolonies.api.colony.workorders.WorkOrderView;
import com.minecolonies.api.entity.citizen.AbstractEntityCitizen;
import com.minecolonies.api.util.BlockPosUtil;
import com.minecolonies.coremod.MineColonies;
import com.minecolonies.coremod.colony.Colony;
import com.minecolonies.coremod.colony.ColonyState;
import com.minecolonies.coremod.colony.buildings.workerbuildings.BuildingTownHall;
import com.minecolonies.coremod.colony.permissions.PermissionsView;
import com.minecolonies.coremod.colony.requestsystem.management.manager.StandardRequestManager;
import com.minecolonies.coremod.colony.workorders.AbstractWorkOrder;
import com.minecolonies.coremod.network.messages.PermissionsMessage;
import com.minecolonies.coremod.network.messages.TownHallRenameMessage;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ColonyView
implements IColonyView {
    private static final int MAX_BYTES_NBTCOMPOUND = 1000000;
    private final int id;
    private final Map<Integer, WorkOrderView> workOrders = new HashMap<Integer, WorkOrderView>();
    @NotNull
    private final PermissionsView permissions = new PermissionsView();
    @NotNull
    private final Map<BlockPos, IBuildingView> buildings = new HashMap<BlockPos, IBuildingView>();
    @NotNull
    private final Map<Integer, ICitizenDataView> citizens = new HashMap<Integer, ICitizenDataView>();
    private final HappinessData happinessData = new HappinessData();
    private String name = "Unknown";
    private int dimensionId;
    private TextFormatting teamColonyColor = TextFormatting.WHITE;
    private BlockPos center = BlockPos.field_177992_a;
    private boolean manualHiring = false;
    private boolean manualHousing = false;
    private boolean moveIn = true;
    @Nullable
    private ITownHallView townHall;
    private int citizenCount = 0;
    private int citizenCountWithEmptyGuardTowers = 0;
    private boolean hasColonyWarehouse;
    private final List<BlockPos> lastSpawnPoints = new ArrayList<BlockPos>();
    private final Set<BlockPos> freePositions = new HashSet<BlockPos>();
    private final Set<Block> freeBlocks = new HashSet<Block>();
    private final Map<BlockPos, IBlockState> wayPoints = new HashMap<BlockPos, IBlockState>();
    private double overallHappiness = 5.0;
    private int lastContactInHours = 0;
    private IRequestManager requestManager;
    private boolean isUnderRaid;
    private World world;
    private boolean printProgress;
    private int boughtCitizenCost;
    private long mercenaryLastUseTime = 0L;
    private String style = "";
    private List<CompactColonyReference> allies;
    private List<CompactColonyReference> feuds;
    private boolean spiesEnabled;

    private ColonyView(int id) {
        this.id = id;
    }

    @NotNull
    public static ColonyView createFromNetwork(int id) {
        return new ColonyView(id);
    }

    public static void serializeNetworkData(@NotNull Colony colony, @NotNull ByteBuf buf, boolean hasNewSubscribers) {
        ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)colony.getName());
        buf.writeInt(colony.getDimension());
        BlockPosUtil.writeToByteBuf(buf, colony.getCenter());
        buf.writeBoolean(colony.isManualHiring());
        buf.writeInt(colony.getCitizenManager().getMaxCitizens());
        buf.writeInt(colony.getCitizenManager().getPotentialMaxCitizens());
        Set<Block> freeBlocks = colony.getFreeBlocks();
        Set<BlockPos> freePos = colony.getFreePositions();
        Map<BlockPos, IBlockState> waypoints = colony.getWayPoints();
        buf.writeInt(freeBlocks.size());
        for (Block block : freeBlocks) {
            ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)block.getRegistryName().toString());
        }
        buf.writeInt(freePos.size());
        for (BlockPos blockPos : freePos) {
            BlockPosUtil.writeToByteBuf(buf, blockPos);
        }
        buf.writeDouble(colony.getOverallHappiness());
        buf.writeBoolean(colony.hasWarehouse());
        buf.writeInt(waypoints.size());
        for (Map.Entry entry : waypoints.entrySet()) {
            BlockPosUtil.writeToByteBuf(buf, (BlockPos)entry.getKey());
            ByteBufUtils.writeTag((ByteBuf)buf, (NBTTagCompound)NBTUtil.func_190009_a((NBTTagCompound)new NBTTagCompound(), (IBlockState)((IBlockState)entry.getValue())));
        }
        buf.writeInt(colony.getLastContactInHours());
        buf.writeBoolean(colony.isManualHousing());
        buf.writeBoolean(colony.canMoveIn());
        if (colony.getRequestManager() != null && (colony.getRequestManager().isDirty() || hasNewSubscribers)) {
            int preSize = buf.writerIndex();
            int n = buf.readerIndex();
            buf.writeBoolean(true);
            ByteBufUtils.writeTag((ByteBuf)buf, (NBTTagCompound)((NBTTagCompound)colony.getRequestManager().serializeNBT()));
            int postSize = buf.writerIndex();
            if (postSize - preSize >= 1000000) {
                colony.getRequestManager().reset();
                buf.setIndex(n, preSize);
                buf.writeBoolean(true);
                ByteBufUtils.writeTag((ByteBuf)buf, (NBTTagCompound)((NBTTagCompound)colony.getRequestManager().serializeNBT()));
            }
        } else {
            buf.writeBoolean(false);
        }
        buf.writeInt(colony.getRaiderManager().getLastSpawnPoints().size());
        for (BlockPos blockPos : colony.getRaiderManager().getLastSpawnPoints()) {
            BlockPosUtil.writeToByteBuf(buf, blockPos);
        }
        buf.writeInt(colony.getTeamColonyColor().ordinal());
        buf.writeBoolean(colony.getProgressManager().isPrintingProgress());
        buf.writeInt(colony.getBoughtCitizenCost());
        buf.writeLong(colony.getMercenaryUseTime());
        ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)colony.getStyle());
        buf.writeBoolean(colony.getRaiderManager().isRaided());
        buf.writeBoolean(colony.getRaiderManager().areSpiesEnabled());
        ArrayList<IColony> allies = new ArrayList<IColony>();
        for (Player player : colony.getPermissions().getPlayersByRank(Rank.OFFICER)) {
            IColony col = IColonyManager.getInstance().getIColonyByOwner(colony.getWorld(), player.getID());
            if (col == null) continue;
            for (Player owner : colony.getPermissions().getPlayersByRank(Rank.OWNER)) {
                if (col.getPermissions().getRank(owner.getID()) != Rank.OFFICER) continue;
                allies.add(col);
            }
        }
        buf.writeInt(allies.size());
        for (IColony col : allies) {
            ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)col.getName());
            BlockPosUtil.writeToByteBuf(buf, col.getCenter());
            buf.writeInt(col.getID());
            buf.writeBoolean(col.hasTownHall());
            buf.writeInt(col.getDimension());
        }
        ArrayList<IColony> arrayList = new ArrayList<IColony>();
        for (Player player : colony.getPermissions().getPlayersByRank(Rank.HOSTILE)) {
            IColony col = IColonyManager.getInstance().getIColonyByOwner(colony.getWorld(), player.getID());
            if (col == null) continue;
            for (Player owner : colony.getPermissions().getPlayersByRank(Rank.OWNER)) {
                if (col.getPermissions().getRank(owner.getID()) != Rank.HOSTILE) continue;
                arrayList.add(col);
            }
        }
        buf.writeInt(arrayList.size());
        for (IColony col : arrayList) {
            ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)col.getName());
            BlockPosUtil.writeToByteBuf(buf, col.getCenter());
            buf.writeInt(col.getID());
            buf.writeInt(col.getDimension());
        }
    }

    @Override
    public List<BlockPos> getFreePositions() {
        return new ArrayList<BlockPos>(this.freePositions);
    }

    @Override
    public List<Block> getFreeBlocks() {
        return new ArrayList<Block>(this.freeBlocks);
    }

    @Override
    public void addFreePosition(@NotNull BlockPos pos) {
        this.freePositions.add(pos);
    }

    @Override
    public void addFreeBlock(@NotNull Block block) {
        this.freeBlocks.add(block);
    }

    @Override
    public void removeFreePosition(@NotNull BlockPos pos) {
        this.freePositions.remove(pos);
    }

    @Override
    public void removeFreeBlock(@NotNull Block block) {
        this.freeBlocks.remove(block);
    }

    @Override
    public void setCanBeAutoDeleted(boolean canBeDeleted) {
    }

    @Override
    public int getDimension() {
        return this.dimensionId;
    }

    @Override
    public boolean isManualHiring() {
        return this.manualHiring;
    }

    @Override
    public void setManualHiring(boolean manualHiring) {
        this.manualHiring = manualHiring;
    }

    @Override
    public NBTTagCompound writeToNBT(NBTTagCompound colonyCompound) {
        return new NBTTagCompound();
    }

    @Override
    public void readFromNBT(NBTTagCompound compound) {
    }

    @Override
    public boolean isManualHousing() {
        return this.manualHousing;
    }

    @Override
    public void setManualHousing(boolean manualHousing) {
        this.manualHousing = manualHousing;
    }

    @Override
    public void addWayPoint(BlockPos pos, IBlockState newWayPointState) {
    }

    @Override
    public boolean isValidAttackingGuard(AbstractEntityCitizen entity) {
        return false;
    }

    @Override
    public boolean canMoveIn() {
        return this.moveIn;
    }

    @Override
    public boolean useAdditionalChildTime(int amount) {
        return false;
    }

    @Override
    public void updateHasChilds() {
    }

    @Override
    public void addLoadedChunk(long chunkPos) {
    }

    @Override
    public void removeLoadedChunk(long chunkPos) {
    }

    @Override
    public int getLoadedChunkCount() {
        return 0;
    }

    @Override
    public ColonyState getState() {
        return null;
    }

    @Override
    public void setMoveIn(boolean newMoveIn) {
        this.moveIn = newMoveIn;
    }

    @Override
    @Nullable
    public ITownHallView getTownHall() {
        return this.townHall;
    }

    @Override
    public IBuildingView getBuilding(int x, int y, int z) {
        return this.getBuilding(new BlockPos(x, y, z));
    }

    @Override
    public IBuildingView getBuilding(BlockPos buildingId) {
        return this.buildings.get(buildingId);
    }

    @Override
    @NotNull
    public Map<UUID, Player> getPlayers() {
        return this.permissions.getPlayers();
    }

    @Override
    public void setPermission(Rank rank, @NotNull Action action) {
        if (this.permissions.setPermission(rank, action)) {
            MineColonies.getNetwork().sendToServer((IMessage)new PermissionsMessage.Permission(this, PermissionsMessage.MessageType.SET_PERMISSION, rank, action));
        }
    }

    @Override
    public void removePermission(Rank rank, @NotNull Action action) {
        if (this.permissions.removePermission(rank, action)) {
            MineColonies.getNetwork().sendToServer((IMessage)new PermissionsMessage.Permission(this, PermissionsMessage.MessageType.REMOVE_PERMISSION, rank, action));
        }
    }

    @Override
    public void togglePermission(Rank rank, @NotNull Action action) {
        this.permissions.togglePermission(rank, action);
        MineColonies.getNetwork().sendToServer((IMessage)new PermissionsMessage.Permission(this, PermissionsMessage.MessageType.TOGGLE_PERMISSION, rank, action));
    }

    @Override
    public int getCitizenCount() {
        return this.citizenCount;
    }

    @Override
    public int getCitizenCountLimit() {
        return this.citizenCountWithEmptyGuardTowers;
    }

    @Override
    public Map<Integer, ICitizenDataView> getCitizens() {
        return Collections.unmodifiableMap(this.citizens);
    }

    @Override
    public Collection<WorkOrderView> getWorkOrders() {
        return Collections.unmodifiableCollection(this.workOrders.values());
    }

    @Override
    public ICitizenDataView getCitizen(int id) {
        return this.citizens.get(id);
    }

    @Override
    @Nullable
    public IMessage handleColonyViewMessage(@NotNull ByteBuf buf, @NotNull World world, boolean isNewSubscription) {
        this.world = world;
        this.name = ByteBufUtils.readUTF8String((ByteBuf)buf);
        this.dimensionId = buf.readInt();
        this.center = BlockPosUtil.readFromByteBuf(buf);
        this.manualHiring = buf.readBoolean();
        this.citizenCount = buf.readInt();
        this.citizenCountWithEmptyGuardTowers = buf.readInt();
        if (isNewSubscription) {
            this.citizens.clear();
            this.townHall = null;
            this.buildings.clear();
        }
        this.freePositions.clear();
        this.freeBlocks.clear();
        this.wayPoints.clear();
        this.lastSpawnPoints.clear();
        int blockListSize = buf.readInt();
        for (int i = 0; i < blockListSize; ++i) {
            this.freeBlocks.add(Block.func_149684_b((String)ByteBufUtils.readUTF8String((ByteBuf)buf)));
        }
        int posListSize = buf.readInt();
        for (int i = 0; i < posListSize; ++i) {
            this.freePositions.add(BlockPosUtil.readFromByteBuf(buf));
        }
        this.overallHappiness = buf.readDouble();
        this.hasColonyWarehouse = buf.readBoolean();
        int wayPointListSize = buf.readInt();
        for (int i = 0; i < wayPointListSize; ++i) {
            this.wayPoints.put(BlockPosUtil.readFromByteBuf(buf), NBTUtil.func_190008_d((NBTTagCompound)ByteBufUtils.readTag((ByteBuf)buf)));
        }
        this.lastContactInHours = buf.readInt();
        this.manualHousing = buf.readBoolean();
        this.moveIn = buf.readBoolean();
        if (buf.readBoolean()) {
            NBTTagCompound compound = ByteBufUtils.readTag((ByteBuf)buf);
            this.requestManager = new StandardRequestManager(this);
            this.requestManager.deserializeNBT((NBTBase)compound);
        }
        int barbSpawnListSize = buf.readInt();
        for (int i = 0; i < barbSpawnListSize; ++i) {
            this.lastSpawnPoints.add(BlockPosUtil.readFromByteBuf(buf));
        }
        Collections.reverse(this.lastSpawnPoints);
        this.teamColonyColor = TextFormatting.values()[buf.readInt()];
        this.printProgress = buf.readBoolean();
        this.boughtCitizenCost = buf.readInt();
        this.mercenaryLastUseTime = buf.readLong();
        this.style = ByteBufUtils.readUTF8String((ByteBuf)buf);
        this.isUnderRaid = buf.readBoolean();
        this.spiesEnabled = buf.readBoolean();
        this.allies = new ArrayList<CompactColonyReference>();
        this.feuds = new ArrayList<CompactColonyReference>();
        int noOfAllies = buf.readInt();
        for (int i = 0; i < noOfAllies; ++i) {
            this.allies.add(new CompactColonyReference(ByteBufUtils.readUTF8String((ByteBuf)buf), BlockPosUtil.readFromByteBuf(buf), buf.readInt(), buf.readBoolean(), buf.readInt()));
        }
        int noOfFeuds = buf.readInt();
        for (int i = 0; i < noOfFeuds; ++i) {
            this.feuds.add(new CompactColonyReference(ByteBufUtils.readUTF8String((ByteBuf)buf), BlockPosUtil.readFromByteBuf(buf), buf.readInt(), false, buf.readInt()));
        }
        return null;
    }

    @Override
    @Nullable
    public IMessage handlePermissionsViewMessage(@NotNull ByteBuf buf) {
        this.permissions.deserialize(buf);
        return null;
    }

    @Override
    @Nullable
    public IMessage handleColonyViewWorkOrderMessage(ByteBuf buf) {
        WorkOrderView workOrder = AbstractWorkOrder.createWorkOrderView(buf);
        if (workOrder != null) {
            this.workOrders.put(workOrder.getId(), workOrder);
        }
        return null;
    }

    @Override
    @Nullable
    public IMessage handleColonyViewCitizensMessage(int id, ByteBuf buf) {
        ICitizenDataView citizen = ICitizenDataManager.getInstance().createFromNetworkData(id, buf, this);
        if (citizen != null) {
            this.citizens.put(citizen.getId(), citizen);
        }
        return null;
    }

    @Override
    @Nullable
    public IMessage handleColonyViewRemoveCitizenMessage(int citizen) {
        this.citizens.remove(citizen);
        return null;
    }

    @Override
    @Nullable
    public IMessage handleColonyViewRemoveBuildingMessage(BlockPos buildingId) {
        IBuildingView building = this.buildings.remove(buildingId);
        if (this.townHall == building) {
            this.townHall = null;
        }
        return null;
    }

    @Override
    @Nullable
    public IMessage handleColonyViewRemoveWorkOrderMessage(int workOrderId) {
        this.workOrders.remove(workOrderId);
        return null;
    }

    @Override
    @Nullable
    public IMessage handleColonyBuildingViewMessage(BlockPos buildingId, @NotNull ByteBuf buf) {
        IBuildingView building = IBuildingDataManager.getInstance().createViewFrom(this, buildingId, buf);
        if (building != null) {
            this.buildings.put(building.getID(), building);
            if (building instanceof BuildingTownHall.View) {
                this.townHall = (ITownHallView)building;
            }
        }
        return null;
    }

    @Override
    public IMessage handleHappinessDataMessage(HappinessData happinessData) {
        this.happinessData.setValues(happinessData);
        return null;
    }

    @Override
    public void addPlayer(String player) {
        MineColonies.getNetwork().sendToServer((IMessage)new PermissionsMessage.AddPlayer(this, player));
    }

    @Override
    public void removePlayer(UUID player) {
        MineColonies.getNetwork().sendToServer((IMessage)new PermissionsMessage.RemovePlayer(this, player));
    }

    @Override
    public double getOverallHappiness() {
        return this.overallHappiness;
    }

    @Override
    public BlockPos getCenter() {
        return this.center;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public TextFormatting getTeamColonyColor() {
        return this.teamColonyColor;
    }

    @Override
    public void setName(String name) {
        this.name = name;
        MineColonies.getNetwork().sendToServer((IMessage)new TownHallRenameMessage(this, name));
    }

    @Override
    @NotNull
    public IPermissions getPermissions() {
        return this.permissions;
    }

    @Override
    public boolean isCoordInColony(@NotNull World w, @NotNull BlockPos pos) {
        Chunk chunk = w.func_175726_f(pos);
        IColonyTagCapability cap = (IColonyTagCapability)chunk.getCapability(MineColonies.CLOSE_COLONY_CAP, null);
        return cap.getOwningColony() == this.getID();
    }

    @Override
    public long getDistanceSquared(@NotNull BlockPos pos) {
        return BlockPosUtil.getDistanceSquared2D(this.center, pos);
    }

    @Override
    public boolean hasTownHall() {
        return this.townHall != null;
    }

    @Override
    public int getID() {
        return this.id;
    }

    @Override
    public boolean hasWarehouse() {
        return this.hasColonyWarehouse;
    }

    @Override
    public int getLastContactInHours() {
        return this.lastContactInHours;
    }

    @Override
    public World getWorld() {
        return this.world;
    }

    @Override
    @Nullable
    public IRequestManager getRequestManager() {
        return this.requestManager;
    }

    @Override
    public void markDirty() {
    }

    @Override
    public boolean canBeAutoDeleted() {
        return false;
    }

    @Override
    @Nullable
    public IRequester getRequesterBuildingForPosition(@NotNull BlockPos pos) {
        return this.getBuilding(pos);
    }

    @Override
    public void removeVisitingPlayer(EntityPlayer player) {
    }

    @Override
    @NotNull
    public Set<EntityPlayer> getMessageEntityPlayers() {
        return new HashSet<EntityPlayer>();
    }

    @Override
    public void onBuildingUpgradeComplete(@Nullable IBuilding building, int level) {
    }

    @Override
    public void addVisitingPlayer(EntityPlayer player) {
    }

    @Override
    public void onWorldLoad(@NotNull World w) {
    }

    @Override
    public void onWorldUnload(@NotNull World w) {
    }

    @Override
    public void onServerTick(@NotNull TickEvent.ServerTickEvent event) {
    }

    @Override
    @NotNull
    public IWorkManager getWorkManager() {
        return null;
    }

    @Override
    public HappinessData getHappinessData() {
        return this.happinessData;
    }

    @Override
    public void onWorldTick(@NotNull TickEvent.WorldTickEvent event) {
    }

    @Override
    public boolean areAllColonyChunksLoaded() {
        return false;
    }

    @Override
    public Map<BlockPos, IBlockState> getWayPoints() {
        return this.wayPoints;
    }

    @Override
    public List<BlockPos> getLastSpawnPoints() {
        return new ArrayList<BlockPos>(this.lastSpawnPoints);
    }

    @Override
    public boolean isPrintingProgress() {
        return this.printProgress;
    }

    @Override
    public boolean isRemote() {
        return true;
    }

    @Override
    public NBTTagCompound getColonyTag() {
        return null;
    }

    @Override
    public boolean isNeedToMourn() {
        return false;
    }

    @Override
    public void setNeedToMourn(boolean needToMourn, String name) {
    }

    @Override
    public boolean isMourning() {
        return false;
    }

    @Override
    public boolean isColonyUnderAttack() {
        return false;
    }

    @Override
    public boolean isValidAttackingPlayer(EntityPlayer entity) {
        return false;
    }

    @Override
    public void addGuardToAttackers(AbstractEntityCitizen entityCitizen, EntityPlayer followPlayer) {
    }

    @Override
    public void setColonyColor(TextFormatting color) {
    }

    @Override
    public List<IBuildingView> getBuildings() {
        return new ArrayList<IBuildingView>(this.buildings.values());
    }

    @Override
    public int getBoughtCitizenCost() {
        return this.boughtCitizenCost;
    }

    @Override
    public void increaseBoughtCitizenCost() {
    }

    @Override
    public Set<EntityPlayer> getImportantMessageEntityPlayers() {
        return new HashSet<EntityPlayer>();
    }

    @Override
    public String getStyle() {
        return this.style;
    }

    @Override
    public void setStyle(String style) {
    }

    @Override
    public IBuildingManager getBuildingManager() {
        return null;
    }

    @Override
    public ICitizenManager getCitizenManager() {
        return null;
    }

    @Override
    public IColonyHappinessManager getColonyHappinessManager() {
        return null;
    }

    @Override
    public IStatisticAchievementManager getStatsManager() {
        return null;
    }

    @Override
    public IRaiderManager getRaiderManager() {
        return null;
    }

    @Override
    public IEventManager getEventManager() {
        return null;
    }

    @Override
    public IColonyPackageManager getPackageManager() {
        return null;
    }

    @Override
    public IProgressManager getProgressManager() {
        return null;
    }

    @Override
    public boolean isRaiding() {
        return this.isUnderRaid;
    }

    @Override
    public long getMercenaryUseTime() {
        return this.mercenaryLastUseTime;
    }

    @Override
    public void usedMercenaries() {
        this.mercenaryLastUseTime = this.world.func_82737_E();
    }

    @Override
    public List<CompactColonyReference> getAllies() {
        return this.allies;
    }

    @Override
    public List<CompactColonyReference> getFeuds() {
        return this.feuds;
    }

    @Override
    public boolean areSpiesEnabled() {
        return this.spiesEnabled;
    }
}

