/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.client.gui;

import com.ldtteam.structures.blueprints.v1.Blueprint;
import com.ldtteam.structures.helpers.Settings;
import com.ldtteam.structures.lib.BlueprintUtils;
import com.ldtteam.structurize.api.util.LanguageHandler;
import com.ldtteam.structurize.client.gui.WindowBuildTool;
import com.ldtteam.structurize.management.StructureName;
import com.ldtteam.structurize.placementhandlers.PlacementError;
import com.ldtteam.structurize.util.BlockUtils;
import com.minecolonies.coremod.MineColonies;
import com.minecolonies.coremod.items.ItemSupplyCampDeployer;
import com.minecolonies.coremod.items.ItemSupplyChestDeployer;
import com.minecolonies.coremod.network.messages.BuildToolPasteMessage;
import com.minecolonies.coremod.network.messages.BuildToolPlaceMessage;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import org.jetbrains.annotations.Nullable;

public class WindowMinecoloniesBuildTool
extends WindowBuildTool {
    public WindowMinecoloniesBuildTool(@Nullable BlockPos pos, String structureName, int rotation, WindowBuildTool.FreeMode mode) {
        super(pos, structureName, rotation, mode);
    }

    public WindowMinecoloniesBuildTool(@Nullable BlockPos pos) {
        super(pos);
    }

    public void place(StructureName structureName) {
        BlockPos offset = BlueprintUtils.getPrimaryBlockOffset((Blueprint)Settings.instance.getActiveStructure().getBluePrint());
        IBlockState state = Settings.instance.getActiveStructure().getBlockState(offset);
        MineColonies.getNetwork().sendToServer((IMessage)new BuildToolPlaceMessage(structureName.toString(), structureName.toString(), Settings.instance.getPosition(), Settings.instance.getRotation(), structureName.isHut(), Settings.instance.getMirror(), state));
    }

    public boolean hasPermission() {
        return true;
    }

    public boolean pasteDirectly() {
        return false;
    }

    public void paste(StructureName name, boolean complete) {
        BlockPos offset = BlueprintUtils.getPrimaryBlockOffset((Blueprint)Settings.instance.getActiveStructure().getBluePrint());
        IBlockState state = Settings.instance.getActiveStructure().getBlockState(offset);
        MineColonies.getNetwork().sendToServer((IMessage)new BuildToolPasteMessage(name.toString(), name.toString(), Settings.instance.getPosition(), Settings.instance.getRotation(), name.isHut(), Settings.instance.getMirror(), complete, Settings.instance.getFreeMode(), state));
    }

    public void checkAndPlace() {
        if (WindowBuildTool.FreeMode.SUPPLYSHIP == Settings.instance.getFreeMode()) {
            if (ItemSupplyChestDeployer.canShipBePlaced((World)Minecraft.func_71410_x().field_71441_e, Settings.instance.getPosition(), Settings.instance.getActiveStructure().getSize(BlockUtils.getRotation((int)Settings.instance.getRotation()), Settings.instance.getMirror()))) {
                super.pasteNice();
            } else {
                LanguageHandler.sendPlayerMessage((EntityPlayer)Minecraft.func_71410_x().field_71439_g, (String)"item.supplyChestDeployer.invalid", (Object[])new Object[0]);
            }
        } else if (WindowBuildTool.FreeMode.SUPPLYCAMP == Settings.instance.getFreeMode()) {
            ArrayList<PlacementError> placementErrorList = new ArrayList<PlacementError>();
            if (ItemSupplyCampDeployer.canCampBePlaced((World)Minecraft.func_71410_x().field_71441_e, Settings.instance.getPosition(), Settings.instance.getActiveStructure().getSize(BlockUtils.getRotation((int)Settings.instance.getRotation()), Settings.instance.getMirror()), placementErrorList)) {
                super.pasteNice();
            } else {
                Map blockPosListByErrorTypeMap = PlacementError.partitionPlacementErrorsByErrorType(placementErrorList);
                block5: for (Map.Entry entry : blockPosListByErrorTypeMap.entrySet()) {
                    String errorMessage;
                    PlacementError.PlacementErrorType placementErrorType = (PlacementError.PlacementErrorType)entry.getKey();
                    List blockPosList = (List)entry.getValue();
                    int numberOfBlocksTOReport = blockPosList.size() > 5 ? 5 : blockPosList.size();
                    List blocksToReportList = blockPosList.subList(0, numberOfBlocksTOReport);
                    String outputList = PlacementError.blockListToCommaSeparatedString(blocksToReportList);
                    if (blockPosList.size() > numberOfBlocksTOReport) {
                        outputList = outputList + "...";
                    }
                    switch (placementErrorType) {
                        case NOT_SOLID: {
                            errorMessage = String.format("item.supplyCampDeployer.invalid.solid_block_needed", outputList);
                            LanguageHandler.sendPlayerMessage((EntityPlayer)Minecraft.func_71410_x().field_71439_g, (String)errorMessage, (Object[])new Object[]{outputList});
                            continue block5;
                        }
                        case NEEDS_AIR_ABOVE: {
                            errorMessage = String.format("item.supplyCampDeployer.invalid.air_block_needed", outputList);
                            LanguageHandler.sendPlayerMessage((EntityPlayer)Minecraft.func_71410_x().field_71439_g, (String)errorMessage, (Object[])new Object[]{outputList});
                            continue block5;
                        }
                        case INSIDE_COLONY: {
                            errorMessage = "item.supplyCampDeployer.invalid.inside_existing_colony";
                            LanguageHandler.sendPlayerMessage((EntityPlayer)Minecraft.func_71410_x().field_71439_g, (String)errorMessage, (Object[])new Object[0]);
                            continue block5;
                        }
                    }
                    errorMessage = "item.supplyCampDeployer.invalid";
                    LanguageHandler.sendPlayerMessage((EntityPlayer)Minecraft.func_71410_x().field_71439_g, (String)errorMessage, (Object[])new Object[0]);
                }
            }
        }
        if (!GuiScreen.func_146272_n()) {
            super.cancelClicked();
        }
    }
}

