/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.client.gui;

import com.minecolonies.api.colony.buildings.views.IBuildingView;
import com.minecolonies.api.util.LanguageHandler;
import com.minecolonies.blockout.controls.Button;
import com.minecolonies.blockout.controls.Label;
import com.minecolonies.coremod.MineColonies;
import com.minecolonies.coremod.client.gui.AbstractWindowSkeleton;
import com.minecolonies.coremod.client.gui.WindowBuildBuilding;
import com.minecolonies.coremod.client.gui.WindowHutNameEntry;
import com.minecolonies.coremod.client.gui.WindowInfo;
import com.minecolonies.coremod.network.messages.BuildRequestMessage;
import com.minecolonies.coremod.network.messages.OpenInventoryMessage;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public abstract class AbstractWindowBuilding<B extends IBuildingView>
extends AbstractWindowSkeleton {
    public static final String BUTTON_INFO_HUTS = "hut_info_button";
    protected final B building;
    private final Label title;
    private final Button buttonBuild;

    public AbstractWindowBuilding(B building, String resource) {
        super(resource);
        this.building = building;
        this.registerButton("build", this::buildClicked);
        this.registerButton(BUTTON_INFO_HUTS, this::infoClicked);
        this.registerButton("inventory", this::inventoryClicked);
        this.registerButton("editName", this::editName);
        this.title = this.findPaneOfTypeByID("name", Label.class);
        this.buttonBuild = this.findPaneOfTypeByID("build", Button.class);
        Button buttonInfo = this.findPaneOfTypeByID(BUTTON_INFO_HUTS, Button.class);
        if (buttonInfo != null) {
            buttonInfo.setVisible(I18n.func_188566_a((String)("com.minecolonies.coremod.info." + building.getSchematicName() + ".0")));
        }
    }

    private void editName() {
        WindowHutNameEntry window = new WindowHutNameEntry((IBuildingView)this.building);
        window.open();
    }

    private void infoClicked() {
        WindowInfo window = new WindowInfo((IBuildingView)this.building);
        window.open();
    }

    private void buildClicked() {
        String buttonLabel = this.buttonBuild.getLabel();
        if (buttonLabel.equalsIgnoreCase(LanguageHandler.format("com.minecolonies.coremod.gui.workerHuts.cancelBuild", new Object[0])) || buttonLabel.equalsIgnoreCase(LanguageHandler.format("com.minecolonies.coremod.gui.workerHuts.cancelUpgrade", new Object[0]))) {
            MineColonies.getNetwork().sendToServer((IMessage)new BuildRequestMessage((IBuildingView)this.building, 0, BlockPos.field_177992_a));
        } else if (buttonLabel.equalsIgnoreCase(LanguageHandler.format("com.minecolonies.coremod.gui.workerHuts.cancelRepair", new Object[0]))) {
            MineColonies.getNetwork().sendToServer((IMessage)new BuildRequestMessage((IBuildingView)this.building, 1, BlockPos.field_177992_a));
        } else {
            WindowBuildBuilding window = new WindowBuildBuilding(this.building.getColony(), (IBuildingView)this.building);
            window.open();
        }
    }

    private void inventoryClicked() {
        MineColonies.getNetwork().sendToServer((IMessage)new OpenInventoryMessage(this.building.getID()));
    }

    @Override
    public void onUpdate() {
        super.onUpdate();
        if (this.switchView.getCurrentView().getID().equals("pageActions")) {
            B buildingView = this.building;
            if (this.title != null && buildingView != null) {
                String name;
                String string = name = this.building.getCustomName().isEmpty() ? LanguageHandler.format(this.getBuildingName(), new Object[0]) : this.building.getCustomName();
                if (this.switchView.getID().equals("switchpageActions")) {
                    this.title.setLabelText(name);
                    this.findPaneOfTypeByID("level", Label.class).setLabelText(LanguageHandler.format("com.minecolonies.coremod.gui.townHall.buildingLevel", new Object[0]) + ": " + buildingView.getBuildingLevel());
                } else {
                    this.title.setLabelText(name + " " + buildingView.getBuildingLevel());
                }
            }
            this.updateButtonBuild((IBuildingView)buildingView);
        }
    }

    public abstract String getBuildingName();

    private void updateButtonBuild(IBuildingView buildingView) {
        if (this.buttonBuild == null) {
            return;
        }
        if (buildingView.isBuilding()) {
            if (buildingView.getBuildingLevel() == 0) {
                this.buttonBuild.setLabel(LanguageHandler.format("com.minecolonies.coremod.gui.workerHuts.cancelBuild", new Object[0]));
            } else {
                this.buttonBuild.setLabel(LanguageHandler.format("com.minecolonies.coremod.gui.workerHuts.cancelUpgrade", new Object[0]));
            }
        } else if (buildingView.isRepairing()) {
            this.buttonBuild.setLabel(LanguageHandler.format("com.minecolonies.coremod.gui.workerHuts.cancelRepair", new Object[0]));
        } else {
            this.buttonBuild.setLabel(LanguageHandler.format("com.minecolonies.coremod.gui.workerHuts.buildRepair", new Object[0]));
        }
    }

    @Override
    public void onOpened() {
        super.onOpened();
        this.setPage("");
    }
}

