/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.api.util;

import java.util.Iterator;
import java.util.Spliterators;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;

public class NBTUtils {
    public static Stream<NBTTagCompound> streamCompound(NBTTagList list) {
        return NBTUtils.streamBase(list).filter(b -> b instanceof NBTTagCompound).map(b -> (NBTTagCompound)b);
    }

    public static Stream<NBTBase> streamBase(NBTTagList list) {
        return StreamSupport.stream(Spliterators.spliteratorUnknownSize(new TagListIterator(list), 16), false);
    }

    public static Collector<NBTTagCompound, ?, NBTTagList> toNBTTagList() {
        return Collectors.collectingAndThen(Collectors.toList(), list -> {
            NBTTagList tagList = new NBTTagList();
            list.forEach(arg_0 -> ((NBTTagList)tagList).func_74742_a(arg_0));
            return tagList;
        });
    }

    private static class TagListIterator
    implements Iterator<NBTBase> {
        private final NBTTagList list;
        private int currentIndex = 0;

        private TagListIterator(NBTTagList list) {
            this.list = list;
        }

        @Override
        public boolean hasNext() {
            return this.currentIndex < this.list.func_74745_c();
        }

        @Override
        public NBTBase next() {
            return this.list.func_150305_b(this.currentIndex++);
        }
    }
}

