/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.api.util;

import com.minecolonies.api.colony.IColonyTagCapability;
import com.minecolonies.api.util.BlockPosUtil;
import com.minecolonies.api.util.NBTUtils;
import com.minecolonies.api.util.Tuple;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.chunk.Chunk;

public class ChunkLoadStorage {
    public static final String TAG_CLAIM_LIST = "claimsToAdd";
    private static final String TAG_COLONIES_TO_ADD = "coloniesToAdd";
    private static final String TAG_COLONIES_TO_REMOVE = "coloniesToRemove";
    private static final int MAX_CHUNK_CLAIMS = 20;
    private final List<Short> colonyId = new ArrayList<Short>();
    private final List<Short> coloniesToRemove = new ArrayList<Short>();
    private final List<Short> coloniesToAdd = new ArrayList<Short>();
    private final long xz;
    private final int dimension;
    private final List<Tuple<Short, BlockPos>> claimingBuilding = new ArrayList<Tuple<Short, BlockPos>>();
    private final List<Tuple<Short, BlockPos>> unClaimingBuilding = new ArrayList<Tuple<Short, BlockPos>>();

    public ChunkLoadStorage(NBTTagCompound compound) {
        if (compound.func_74764_b("id")) {
            this.colonyId.add((short)compound.func_74762_e("id"));
        }
        this.xz = compound.func_74763_f("pos");
        this.dimension = compound.func_74762_e("dimension");
        this.colonyId.addAll(NBTUtils.streamCompound(compound.func_150295_c(TAG_CLAIM_LIST, 10)).map(tempCompound -> tempCompound.func_74765_d("colony")).collect(Collectors.toList()));
        this.coloniesToAdd.addAll(NBTUtils.streamCompound(compound.func_150295_c(TAG_COLONIES_TO_ADD, 10)).map(tempCompound -> tempCompound.func_74765_d("colony")).collect(Collectors.toList()));
        this.coloniesToRemove.addAll(NBTUtils.streamCompound(compound.func_150295_c(TAG_COLONIES_TO_REMOVE, 10)).map(tempCompound -> tempCompound.func_74765_d("colony")).collect(Collectors.toList()));
        this.claimingBuilding.addAll(NBTUtils.streamCompound(compound.func_150295_c("buildingsClaim", 10)).map(ChunkLoadStorage::readTupleFromNbt).collect(Collectors.toList()));
        this.unClaimingBuilding.addAll(NBTUtils.streamCompound(compound.func_150295_c("buildingUnclaim", 10)).map(ChunkLoadStorage::readTupleFromNbt).collect(Collectors.toList()));
    }

    public ChunkLoadStorage(int colonyId, long xz, boolean add, int dimension, boolean owning) {
        this.colonyId.add((short)(owning && add ? colonyId : 0));
        this.xz = xz;
        this.dimension = dimension;
        if (add) {
            this.coloniesToAdd.add((short)colonyId);
            this.coloniesToRemove.add((short)0);
        } else {
            this.coloniesToAdd.add((short)0);
            this.coloniesToRemove.add((short)colonyId);
        }
    }

    public ChunkLoadStorage(int colonyId, long xz, int dimension, BlockPos building) {
        this.xz = xz;
        this.dimension = dimension;
        this.claimingBuilding.add(new Tuple<Short, BlockPos>((short)colonyId, building));
    }

    public NBTTagCompound toNBT() {
        NBTTagCompound compound = new NBTTagCompound();
        compound.func_74772_a("pos", this.xz);
        compound.func_74768_a("dimension", this.dimension);
        compound.func_74782_a(TAG_CLAIM_LIST, (NBTBase)this.colonyId.stream().map(ChunkLoadStorage::getCompoundOfColonyId).collect(NBTUtils.toNBTTagList()));
        compound.func_74782_a(TAG_COLONIES_TO_ADD, (NBTBase)this.coloniesToAdd.stream().map(ChunkLoadStorage::getCompoundOfColonyId).collect(NBTUtils.toNBTTagList()));
        compound.func_74782_a(TAG_COLONIES_TO_REMOVE, (NBTBase)this.coloniesToRemove.stream().map(ChunkLoadStorage::getCompoundOfColonyId).collect(NBTUtils.toNBTTagList()));
        compound.func_74782_a("buildings", (NBTBase)this.claimingBuilding.stream().map(ChunkLoadStorage::writeTupleToNBT).collect(NBTUtils.toNBTTagList()));
        compound.func_74782_a("buildings", (NBTBase)this.unClaimingBuilding.stream().map(ChunkLoadStorage::writeTupleToNBT).collect(NBTUtils.toNBTTagList()));
        return compound;
    }

    private static NBTTagCompound getCompoundOfColonyId(int id) {
        NBTTagCompound compound = new NBTTagCompound();
        compound.func_74768_a("colony", id);
        return compound;
    }

    public int getDimension() {
        return this.dimension;
    }

    public long getXz() {
        return this.xz;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ChunkLoadStorage storage = (ChunkLoadStorage)o;
        return this.xz == storage.xz && this.dimension == storage.dimension && Objects.equals(this.colonyId, storage.colonyId) && Objects.equals(this.coloniesToRemove, storage.coloniesToRemove) && Objects.equals(this.coloniesToAdd, storage.coloniesToAdd) && Objects.equals(this.claimingBuilding, storage.claimingBuilding) && Objects.equals(this.unClaimingBuilding, storage.unClaimingBuilding);
    }

    public int hashCode() {
        return Objects.hash(this.colonyId, this.coloniesToRemove, this.coloniesToAdd, this.xz, this.dimension, this.claimingBuilding, this.unClaimingBuilding);
    }

    public void applyToCap(IColonyTagCapability cap, Chunk chunk) {
        if (this.claimingBuilding.isEmpty() && this.unClaimingBuilding.isEmpty()) {
            int amountOfOperations = Math.max(Math.max(this.colonyId.size(), this.coloniesToAdd.size()), this.coloniesToRemove.size());
            for (int i = 0; i < amountOfOperations; ++i) {
                short claimID;
                if (i < this.colonyId.size() && (claimID = this.colonyId.get(i).shortValue()) > 0) {
                    cap.setOwningColony(claimID, chunk);
                }
                if (i < this.coloniesToAdd.size() && this.coloniesToAdd.get(i) > 0) {
                    cap.addColony(this.coloniesToAdd.get(i).shortValue(), chunk);
                }
                if (i >= this.coloniesToRemove.size() || this.coloniesToRemove.get(i) <= 0) continue;
                cap.removeColony(this.coloniesToRemove.get(i).shortValue(), chunk);
            }
        } else {
            for (Tuple<Short, BlockPos> tuple : this.unClaimingBuilding) {
                cap.removeBuildingClaim(tuple.getFirst().shortValue(), tuple.getSecond(), chunk);
            }
            for (Tuple<Short, BlockPos> tuple : this.claimingBuilding) {
                cap.addBuildingClaim(tuple.getFirst().shortValue(), tuple.getSecond(), chunk);
            }
        }
        chunk.func_76630_e();
    }

    public boolean isEmpty() {
        return this.coloniesToAdd.isEmpty() && this.coloniesToRemove.isEmpty();
    }

    public void merge(ChunkLoadStorage newStorage) {
        if (this.claimingBuilding.isEmpty() && this.unClaimingBuilding.isEmpty()) {
            this.colonyId.addAll(newStorage.colonyId);
            this.coloniesToAdd.addAll(newStorage.coloniesToAdd);
            this.coloniesToRemove.addAll(newStorage.coloniesToRemove);
            if (this.coloniesToAdd.size() > 20) {
                this.colonyId.clear();
                this.coloniesToAdd.clear();
                this.coloniesToRemove.clear();
            }
        } else {
            this.claimingBuilding.removeIf(newStorage.unClaimingBuilding::contains);
            this.unClaimingBuilding.removeIf(newStorage.claimingBuilding::contains);
            for (Tuple<Short, BlockPos> tuple : newStorage.unClaimingBuilding) {
                if (this.unClaimingBuilding.contains(tuple)) continue;
                this.unClaimingBuilding.add(tuple);
            }
            for (Tuple<Short, BlockPos> tuple : newStorage.claimingBuilding) {
                if (this.claimingBuilding.contains(tuple)) continue;
                this.claimingBuilding.add(tuple);
            }
        }
    }

    private static NBTTagCompound writeTupleToNBT(Tuple<Short, BlockPos> tuple) {
        NBTTagCompound compound = new NBTTagCompound();
        compound.func_74777_a("colony", tuple.getFirst().shortValue());
        BlockPosUtil.writeToNBT(compound, "building", tuple.getSecond());
        return compound;
    }

    private static Tuple<Short, BlockPos> readTupleFromNbt(NBTTagCompound compound) {
        return new Tuple<Short, BlockPos>(compound.func_74765_d("colony"), BlockPosUtil.readFromNBT(compound, "building"));
    }
}

