/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.api.sounds;

import com.minecolonies.api.sounds.AbstractWorkerSounds;
import com.minecolonies.api.sounds.CitizenSounds;
import com.minecolonies.api.sounds.ModSoundEvents;
import com.minecolonies.api.util.SoundUtils;
import java.util.Random;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public final class BakerSounds
extends AbstractWorkerSounds {
    private static final int NUMBER_OF_SOUNDS = 3;
    private static final Random rand = new Random();

    @Override
    public void playSound(World worldIn, BlockPos position, boolean isFemale, double saturation) {
        if (!isFemale) {
            SoundUtils.playSoundAtCitizenWithChance(worldIn, position, CitizenSounds.Male.say, this.getPhraseChance());
            return;
        }
        switch (rand.nextInt(4)) {
            case 1: {
                SoundEvent noises = Female.noises;
                SoundUtils.playSoundAtCitizenWithChance(worldIn, position, noises, this.getBasicSoundChance());
                break;
            }
            case 2: {
                this.playSaturationSound(worldIn, position, isFemale, saturation);
                break;
            }
            default: {
                SoundEvent generalPhrases = Female.generalPhrases;
                SoundUtils.playSoundAtCitizenWithChance(worldIn, position, generalPhrases, this.getPhraseChance());
            }
        }
    }

    @Override
    public String getWorkerString() {
        return "Baker";
    }

    @Override
    public void playInteractionSound(World worldIn, BlockPos position, boolean isFemale) {
        if (!isFemale) {
            SoundUtils.playSoundAtCitizenWithChance(worldIn, position, CitizenSounds.Male.say, this.getPhraseChance());
            return;
        }
        SoundUtils.playSoundAtCitizenWithChance(worldIn, position, Female.interaction, this.getBasicSoundChance());
    }

    public void playSaturationSound(World worldIn, BlockPos position, boolean isFemale, double saturation) {
        if (!isFemale) {
            return;
        }
        SoundEvent saturationFeedback = saturation < 3.0 ? Female.saturationVeryLow : (saturation < 5.0 ? Female.saturationLow : Female.saturationHigh);
        SoundUtils.playSoundAtCitizenWithChance(worldIn, position, saturationFeedback, this.getBasicSoundChance());
    }

    public static final class Male {
        private Male() {
        }
    }

    public static final class Female {
        public static final SoundEvent generalPhrases = ModSoundEvents.getSoundID("mob.bakery.female.generalPhrases");
        public static final SoundEvent noises = ModSoundEvents.getSoundID("mob.bakery.female.noise");
        public static final SoundEvent hostile = ModSoundEvents.getSoundID("mob.bakery.female.hostile");
        public static final SoundEvent offToBed = ModSoundEvents.getSoundID("mob.bakery.female.offToBed");
        public static final SoundEvent badWeather = ModSoundEvents.getSoundID("mob.bakery.female.badWeather");
        public static final SoundEvent saturationVeryLow = ModSoundEvents.getSoundID("mob.bakery.female.saturationVeryLow");
        public static final SoundEvent saturationLow = ModSoundEvents.getSoundID("mob.bakery.female.saturationLow");
        public static final SoundEvent saturationHigh = ModSoundEvents.getSoundID("mob.bakery.female.saturationHigh");
        public static final SoundEvent greeting = ModSoundEvents.getSoundID("mob.bakery.female.greeting");
        public static final SoundEvent farewell = ModSoundEvents.getSoundID("mob.bakery.female.farewell");
        public static final SoundEvent interaction = ModSoundEvents.getSoundID("mob.bakery.female.interaction");

        private Female() {
        }
    }
}

