/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.api.entity.citizen;

import com.minecolonies.api.client.render.modeltype.BipedModelType;
import com.minecolonies.api.client.render.modeltype.IModelType;
import com.minecolonies.api.colony.ICitizenData;
import com.minecolonies.api.colony.requestsystem.location.ILocation;
import com.minecolonies.api.entity.ai.DesiredActivity;
import com.minecolonies.api.entity.ai.pathfinding.IWalkToProxy;
import com.minecolonies.api.entity.citizen.citizenhandlers.ICitizenChatHandler;
import com.minecolonies.api.entity.citizen.citizenhandlers.ICitizenColonyHandler;
import com.minecolonies.api.entity.citizen.citizenhandlers.ICitizenExperienceHandler;
import com.minecolonies.api.entity.citizen.citizenhandlers.ICitizenInventoryHandler;
import com.minecolonies.api.entity.citizen.citizenhandlers.ICitizenItemHandler;
import com.minecolonies.api.entity.citizen.citizenhandlers.ICitizenJobHandler;
import com.minecolonies.api.entity.citizen.citizenhandlers.ICitizenSleepHandler;
import com.minecolonies.api.entity.citizen.citizenhandlers.ICitizenStatusHandler;
import com.minecolonies.api.entity.citizen.citizenhandlers.ICitizenStuckHandler;
import com.minecolonies.api.entity.pathfinding.AbstractAdvancedPathNavigate;
import com.minecolonies.api.entity.pathfinding.registry.IPathNavigateRegistry;
import com.minecolonies.api.inventory.InventoryCitizen;
import com.minecolonies.api.util.CompatibilityUtils;
import com.minecolonies.api.util.SoundUtils;
import java.util.Random;
import net.minecraft.block.state.IBlockState;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityAgeable;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAITasks;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemShield;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.common.util.ITeleporter;
import net.minecraftforge.items.IItemHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractEntityCitizen
extends EntityAgeable
implements ICommandSender,
ICapabilitySerializable<NBTTagCompound> {
    public static final DataParameter<Integer> DATA_LEVEL = EntityDataManager.func_187226_a(AbstractEntityCitizen.class, (DataSerializer)DataSerializers.field_187192_b);
    public static final DataParameter<Integer> DATA_TEXTURE = EntityDataManager.func_187226_a(AbstractEntityCitizen.class, (DataSerializer)DataSerializers.field_187192_b);
    public static final DataParameter<Integer> DATA_IS_FEMALE = EntityDataManager.func_187226_a(AbstractEntityCitizen.class, (DataSerializer)DataSerializers.field_187192_b);
    public static final DataParameter<Integer> DATA_COLONY_ID = EntityDataManager.func_187226_a(AbstractEntityCitizen.class, (DataSerializer)DataSerializers.field_187192_b);
    public static final DataParameter<Integer> DATA_CITIZEN_ID = EntityDataManager.func_187226_a(AbstractEntityCitizen.class, (DataSerializer)DataSerializers.field_187192_b);
    public static final DataParameter<String> DATA_MODEL = EntityDataManager.func_187226_a(AbstractEntityCitizen.class, (DataSerializer)DataSerializers.field_187194_d);
    public static final DataParameter<String> DATA_RENDER_METADATA = EntityDataManager.func_187226_a(AbstractEntityCitizen.class, (DataSerializer)DataSerializers.field_187194_d);
    public static final DataParameter<Boolean> DATA_IS_ASLEEP = EntityDataManager.func_187226_a(AbstractEntityCitizen.class, (DataSerializer)DataSerializers.field_187198_h);
    public static final DataParameter<Boolean> DATA_IS_CHILD = EntityDataManager.func_187226_a(AbstractEntityCitizen.class, (DataSerializer)DataSerializers.field_187198_h);
    public static final DataParameter<BlockPos> DATA_BED_POS = EntityDataManager.func_187226_a(AbstractEntityCitizen.class, (DataSerializer)DataSerializers.field_187200_j);
    private IModelType modelId = BipedModelType.SETTLER;
    private int textureId;
    private String renderMetadata;
    private boolean female;
    private ResourceLocation texture;
    private AbstractAdvancedPathNavigate pathNavigate;

    public AbstractEntityCitizen(World world) {
        super(world);
    }

    public EntityAITasks getTasks() {
        return this.field_70714_bg;
    }

    public int getTicksExisted() {
        return this.field_70173_aa;
    }

    public Entity changeDimension(int dimensionIn, ITeleporter teleporter) {
        return null;
    }

    @NotNull
    public BlockPos func_180425_c() {
        return new BlockPos(this.field_70165_t, this.field_70163_u, this.field_70161_v);
    }

    public void setCanCaptureDrops(boolean b) {
        this.captureDrops = b;
    }

    public float getPreviousRotationPitch() {
        return this.field_70127_C;
    }

    public float getPreviousRotationYaw() {
        return this.field_70126_B;
    }

    public float getPreviousRenderYawOffset() {
        return this.field_70760_ar;
    }

    public float getRenderYawOffset() {
        return this.field_70761_aq;
    }

    public double getPreviousPosX() {
        return this.field_70169_q;
    }

    public double getPreviousPosY() {
        return this.field_70167_r;
    }

    public double getPreviousPosZ() {
        return this.field_70166_s;
    }

    @NotNull
    public EnumActionResult func_184199_a(EntityPlayer player, Vec3d vec, EnumHand hand) {
        SoundUtils.playInteractionSoundAtCitizenWithChance(CompatibilityUtils.getWorldFromCitizen(this), this.func_180425_c(), 100, this);
        return super.func_184199_a(player, vec, hand);
    }

    public boolean func_175446_cd() {
        return false;
    }

    public void setTexture() {
        if (!CompatibilityUtils.getWorldFromCitizen((AbstractEntityCitizen)this).field_72995_K) {
            return;
        }
        IModelType model = this.getModelType();
        String textureBase = "textures/entity/" + model.getTextureBase() + (this.female ? "Female" : "Male");
        int moddedTextureId = this.textureId % model.getNumTextures() + 1;
        this.texture = new ResourceLocation("minecolonies", textureBase + moddedTextureId + this.renderMetadata + ".png");
    }

    public ResourceLocation getTexture() {
        return this.texture;
    }

    public IModelType getModelType() {
        return this.modelId;
    }

    public EntityAgeable func_90011_a(@NotNull EntityAgeable child) {
        return null;
    }

    public void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(DATA_TEXTURE, (Object)0);
        this.field_70180_af.func_187214_a(DATA_LEVEL, (Object)0);
        this.field_70180_af.func_187214_a(DATA_IS_FEMALE, (Object)0);
        this.field_70180_af.func_187214_a(DATA_MODEL, (Object)BipedModelType.SETTLER.name());
        this.field_70180_af.func_187214_a(DATA_RENDER_METADATA, (Object)"");
        this.field_70180_af.func_187214_a(DATA_IS_ASLEEP, (Object)false);
        this.field_70180_af.func_187214_a(DATA_IS_CHILD, (Object)false);
        this.field_70180_af.func_187214_a(DATA_BED_POS, (Object)new BlockPos(0, 0, 0));
    }

    public double getPosX() {
        return this.field_70165_t;
    }

    public double getPosY() {
        return this.field_70163_u;
    }

    public double getPosZ() {
        return this.field_70161_v;
    }

    public boolean isFemale() {
        return this.female;
    }

    public void setFemale(boolean female) {
        this.female = female;
    }

    @NotNull
    public AbstractAdvancedPathNavigate getNavigator() {
        if (this.pathNavigate == null) {
            this.pathNavigate = IPathNavigateRegistry.getInstance().getNavigateFor((EntityLiving)this);
            this.field_70699_by = this.pathNavigate;
            this.pathNavigate.func_179693_d(true);
            this.pathNavigate.func_179691_c(true);
            this.pathNavigate.func_189566_q().func_186321_b(true);
        }
        return this.pathNavigate;
    }

    public void setOwnRotation(float yaw, float pitch) {
        this.func_70101_b(yaw, pitch);
    }

    public void setModelId(IModelType model) {
        this.modelId = model;
    }

    public void setRenderMetadata(String renderMetadata) {
        this.renderMetadata = renderMetadata;
        this.field_70180_af.func_187227_b(DATA_RENDER_METADATA, (Object)this.getRenderMetadata());
    }

    public int getTextureId() {
        return this.textureId;
    }

    public void setTextureId(int textureId) {
        this.textureId = textureId;
    }

    public String getRenderMetadata() {
        return this.renderMetadata;
    }

    protected void func_175445_a(EntityItem itemEntity) {
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(20.0);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.3);
        this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(100.0);
    }

    public Random getRandom() {
        return this.field_70146_Z;
    }

    public int getOffsetTicks() {
        return this.field_70173_aa + 7 * this.func_145782_y();
    }

    public boolean func_184585_cz() {
        return this.func_184607_cu().func_77973_b() instanceof ItemShield;
    }

    public int getRecentlyHit() {
        return this.field_70718_bc;
    }

    protected void func_184231_a(double y, boolean onGroundIn, @NotNull IBlockState state, @NotNull BlockPos pos) {
        if (!this.field_70122_E) {
            int px = MathHelper.func_76128_c((double)this.field_70165_t);
            int py = (int)this.field_70163_u;
            int pz = MathHelper.func_76128_c((double)this.field_70161_v);
            this.field_70122_E = CompatibilityUtils.getWorldFromCitizen(this).func_180495_p(new BlockPos(px, py, pz)).func_177230_c().isLadder(this.field_70170_p.func_180495_p(new BlockPos(px, py, pz)), (IBlockAccess)this.field_70170_p, new BlockPos(px, py, pz), (EntityLivingBase)this);
        }
        super.func_184231_a(y, onGroundIn, state, pos);
    }

    public void updateArmSwingProg() {
        this.func_82168_bl();
    }

    public boolean checkCanDropLoot() {
        return this.func_146066_aG();
    }

    public abstract ILocation getLocation();

    public abstract boolean isWorkerAtSiteWithMove(@NotNull BlockPos var1, int var2);

    @Nullable
    public abstract ICitizenData getCitizenData();

    public abstract void setCitizenData(@Nullable ICitizenData var1);

    @NotNull
    public abstract InventoryCitizen getInventoryCitizen();

    @NotNull
    public abstract IItemHandler getItemHandlerCitizen();

    public abstract void markDirty();

    @NotNull
    public abstract DesiredActivity getDesiredActivity();

    public abstract void setCitizensize(@NotNull float var1, @NotNull float var2);

    public abstract void setIsChild(boolean var1);

    public abstract void playMoveAwaySound();

    public abstract IWalkToProxy getProxy();

    public abstract void decreaseSaturationForAction();

    public abstract void decreaseSaturationForContinuousAction();

    public abstract int getCitizenId();

    public abstract void setCitizenId(int var1);

    public abstract BlockPos getCurrentPosition();

    public abstract void setCurrentPosition(BlockPos var1);

    public abstract void spawnEatingParticle();

    public abstract ICitizenExperienceHandler getCitizenExperienceHandler();

    public abstract ICitizenChatHandler getCitizenChatHandler();

    public abstract ICitizenStatusHandler getCitizenStatusHandler();

    public abstract ICitizenItemHandler getCitizenItemHandler();

    public abstract ICitizenInventoryHandler getCitizenInventoryHandler();

    public abstract ICitizenColonyHandler getCitizenColonyHandler();

    public abstract ICitizenJobHandler getCitizenJobHandler();

    public abstract ICitizenSleepHandler getCitizenSleepHandler();

    public abstract ICitizenStuckHandler getCitizenStuckHandler();

    public abstract boolean isOkayToEat();

    public abstract boolean shouldBeFed();

    public abstract boolean isIdlingAtJob();

    public abstract boolean isMourning();

    public abstract void setMourning(boolean var1);

    public abstract float getRotationYaw();

    public abstract float getRotationPitch();

    public abstract boolean isDead();
}

