/*
 * Decompiled with CFR 0.152.
 */
package com.teammetallurgy.aquaculture.handlers;

import com.google.common.base.Preconditions;
import com.teammetallurgy.aquaculture.handlers.EntityCustomFishHook;
import java.util.function.Function;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.world.World;
import net.minecraftforge.fml.client.FMLClientHandler;
import net.minecraftforge.fml.common.network.internal.FMLMessage;
import net.minecraftforge.fml.common.registry.EntityRegistry;
import net.minecraftforge.fml.relauncher.ReflectionHelper;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class AquacultureEntitySpawnHandler {
    @SideOnly(value=Side.CLIENT)
    public static void init() {
        EntityRegistry.EntityRegistration customFishHookRegistration = EntityRegistry.instance().lookupModSpawn(EntityCustomFishHook.class, false);
        Function<FMLMessage.EntitySpawnMessage, Entity> fishHookSpawnHandler = input -> {
            int anglerId = 0;
            double posX = 0.0;
            double posY = 0.0;
            double posZ = 0.0;
            try {
                anglerId = ReflectionHelper.findField(FMLMessage.EntitySpawnMessage.class, (String[])new String[]{"throwerId"}).getInt(input);
                posX = ReflectionHelper.findField(FMLMessage.EntitySpawnMessage.class, (String[])new String[]{"rawX"}).getDouble(input);
                posY = ReflectionHelper.findField(FMLMessage.EntitySpawnMessage.class, (String[])new String[]{"rawY"}).getDouble(input);
                posZ = ReflectionHelper.findField(FMLMessage.EntitySpawnMessage.class, (String[])new String[]{"rawZ"}).getDouble(input);
            }
            catch (IllegalAccessException | IllegalArgumentException e) {
                e.printStackTrace();
            }
            WorldClient world = FMLClientHandler.instance().getWorldClient();
            Entity angler = world.func_73045_a(anglerId);
            if (!(angler instanceof EntityPlayer)) {
                return null;
            }
            return new EntityCustomFishHook((World)world, (EntityPlayer)angler, posX, posY, posZ);
        };
        Preconditions.checkNotNull((Object)customFishHookRegistration, (Object)"fishHookRegistration");
        customFishHookRegistration.setCustomSpawning(fishHookSpawnHandler, false);
    }
}

