/*
 * Decompiled with CFR 0.152.
 */
package com.elytradev.movingworld.common.util;

import com.elytradev.movingworld.common.chunk.LocatedBlock;
import com.elytradev.movingworld.common.chunk.mobilechunk.MobileChunk;
import com.elytradev.movingworld.common.util.LocatedBlockList;
import java.util.ArrayList;
import java.util.Iterator;
import net.minecraft.block.BlockAir;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.math.BlockPos;

public class FloodFiller {
    private LocatedBlockList lbList = new LocatedBlockList();
    private ArrayList<BlockPos> posStack;

    public LocatedBlockList floodFillMobileChunk(MobileChunk mobileChunk) {
        this.lbList = new LocatedBlockList();
        this.fillCoord(mobileChunk, mobileChunk.maxX() / 2, mobileChunk.maxY() + 1, mobileChunk.maxZ() / 2);
        this.cleanList(mobileChunk);
        return this.lbList;
    }

    private void cleanList(MobileChunk mobileChunk) {
        Iterator lbIterator = this.lbList.iterator();
        while (lbIterator.hasNext()) {
            BlockPos lbPos = ((LocatedBlock)lbIterator.next()).blockPos;
            if (lbPos.func_177958_n() <= mobileChunk.maxX() - 1 && lbPos.func_177958_n() >= mobileChunk.minX() && lbPos.func_177956_o() <= mobileChunk.maxY() - 1 && lbPos.func_177956_o() >= mobileChunk.minY() && lbPos.func_177952_p() <= mobileChunk.maxZ() - 1 && lbPos.func_177952_p() >= mobileChunk.minZ()) continue;
            lbIterator.remove();
        }
    }

    private void fillCoord(MobileChunk mobileChunk, int startX, int startY, int startZ) {
        this.posStack = new ArrayList();
        this.posStack.add(new BlockPos(startX, startY, startZ));
        while (!this.posStack.isEmpty()) {
            BlockPos pos = this.posStack.get(this.posStack.size() - 1);
            this.posStack.remove(this.posStack.size() - 1);
            IBlockState state = mobileChunk.func_180495_p(pos);
            int x = pos.func_177958_n();
            int y = pos.func_177956_o();
            int z = pos.func_177952_p();
            if (state != null && !(state.func_177230_c() instanceof BlockAir) || x > mobileChunk.maxX() || x < mobileChunk.minX() - 1 || y > mobileChunk.maxY() + 1 || y < mobileChunk.minY() - 1 || z > mobileChunk.maxZ() || z < mobileChunk.minZ() - 1 || this.lbList.containsLBOfPos(pos)) continue;
            this.lbList.add(new LocatedBlock(mobileChunk.func_180495_p(pos), pos));
            this.posStack.add(pos.func_177982_a(1, 0, 0));
            this.posStack.add(pos.func_177982_a(0, 1, 0));
            this.posStack.add(pos.func_177982_a(0, 0, 1));
            this.posStack.add(pos.func_177982_a(-1, 0, 0));
            this.posStack.add(pos.func_177982_a(0, -1, 0));
            this.posStack.add(pos.func_177982_a(0, 0, -1));
        }
    }
}

