/*
 * Decompiled with CFR 0.152.
 */
package betteradvancements.gui;

import betteradvancements.advancements.BetterDisplayInfo;
import betteradvancements.api.event.AdvancementDrawConnectionsEvent;
import betteradvancements.gui.GuiBetterAdvancementTab;
import betteradvancements.gui.GuiScreenBetterAdvancements;
import betteradvancements.reference.Resources;
import betteradvancements.util.CriterionGrid;
import betteradvancements.util.RenderUtil;
import com.google.common.collect.Lists;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementProgress;
import net.minecraft.advancements.DisplayInfo;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.gui.advancements.AdvancementState;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.input.Keyboard;

@SideOnly(value=Side.CLIENT)
public class GuiBetterAdvancement
extends Gui {
    protected static final int ADVANCEMENT_SIZE = 26;
    private static final int CORNER_SIZE = 10;
    private static final int WIDGET_WIDTH = 256;
    private static final int WIDGET_HEIGHT = 26;
    private static final int TITLE_SIZE = 32;
    private static final int ICON_OFFSET = 128;
    private static final int ICON_SIZE = 26;
    private final GuiBetterAdvancementTab guiBetterAdvancementTab;
    private final Advancement advancement;
    protected final BetterDisplayInfo betterDisplayInfo;
    private final DisplayInfo displayInfo;
    private final String title;
    private int width;
    private List<String> description;
    private CriterionGrid criterionGrid;
    private final Minecraft minecraft;
    private GuiBetterAdvancement parent;
    private final List<GuiBetterAdvancement> children = Lists.newArrayList();
    private AdvancementProgress advancementProgress;
    protected int x;
    protected int y;
    private final int screenScale;

    public GuiBetterAdvancement(GuiBetterAdvancementTab guiBetterAdvancementTab, Minecraft mc, Advancement advancement, DisplayInfo displayInfo) {
        this.guiBetterAdvancementTab = guiBetterAdvancementTab;
        this.advancement = advancement;
        this.betterDisplayInfo = guiBetterAdvancementTab.getBetterDisplayInfo(advancement);
        this.displayInfo = displayInfo;
        this.minecraft = mc;
        this.title = mc.field_71466_p.func_78269_a(displayInfo.func_192297_a().func_150254_d(), 163);
        this.x = this.betterDisplayInfo.getPosX() != null ? this.betterDisplayInfo.getPosX() : MathHelper.func_76141_d((float)(displayInfo.func_192299_e() * 32.0f));
        this.y = this.betterDisplayInfo.getPosY() != null ? this.betterDisplayInfo.getPosY() : MathHelper.func_76141_d((float)(displayInfo.func_192296_f() * 27.0f));
        this.refreshHover();
        this.screenScale = new ScaledResolution(mc).func_78325_e();
    }

    private void refreshHover() {
        Minecraft mc = this.minecraft;
        int k = 0;
        if (this.advancement.func_193124_g() > 1) {
            int strLengthRequirementCount = String.valueOf(this.advancement.func_193124_g()).length();
            k = mc.field_71466_p.func_78256_a("  ") + mc.field_71466_p.func_78256_a("0") * strLengthRequirementCount * 2 + mc.field_71466_p.func_78256_a("/");
        }
        int titleWidth = 29 + mc.field_71466_p.func_78256_a(this.title) + k;
        GuiScreenBetterAdvancements screen = this.guiBetterAdvancementTab.getScreen();
        this.criterionGrid = CriterionGrid.findOptimalCriterionGrid(this.advancement, this.advancementProgress, screen.field_146294_l / 2, mc.field_71466_p);
        int maxWidth = !CriterionGrid.requiresShift || Keyboard.isKeyDown((int)42) || Keyboard.isKeyDown((int)54) ? Math.max(titleWidth, this.criterionGrid.width) : titleWidth;
        String s = this.displayInfo.func_193222_b().func_150254_d();
        this.description = this.findOptimalLines(s, maxWidth);
        for (String line : this.description) {
            maxWidth = Math.max(maxWidth, mc.field_71466_p.func_78256_a(line));
        }
        this.width = maxWidth + 8;
    }

    private List<String> findOptimalLines(String line, int width) {
        if (line.isEmpty()) {
            return Collections.emptyList();
        }
        List list = this.minecraft.field_71466_p.func_78271_c(line, width);
        if (list.size() > 1) {
            width = Math.max(width, this.guiBetterAdvancementTab.getScreen().internalWidth / 4);
            list = this.minecraft.field_71466_p.func_78271_c(line, width);
        }
        while (list.size() > 5 && (double)width < 384.0 && (double)width < (double)this.guiBetterAdvancementTab.getScreen().internalWidth / 2.5) {
            width += width / 4;
            list = this.minecraft.field_71466_p.func_78271_c(line, width);
        }
        return list;
    }

    @Nullable
    private GuiBetterAdvancement getFirstVisibleParent(Advancement advancementIn) {
        while ((advancementIn = advancementIn.func_192070_b()) != null && advancementIn.func_192068_c() == null) {
        }
        if (advancementIn != null && advancementIn.func_192068_c() != null) {
            return this.guiBetterAdvancementTab.getAdvancementGui(advancementIn);
        }
        return null;
    }

    public void drawConnectivity(int scrollX, int scrollY, boolean drawInside) {
        if (!this.betterDisplayInfo.hideLines().booleanValue()) {
            if (this.parent != null) {
                this.drawConnection(this.parent, scrollX, scrollY, drawInside);
            }
            AdvancementDrawConnectionsEvent event = new AdvancementDrawConnectionsEvent(this.advancement);
            MinecraftForge.EVENT_BUS.post((Event)event);
            for (Advancement parent : event.getExtraConnections()) {
                GuiBetterAdvancement parentGui = this.guiBetterAdvancementTab.getAdvancementGui(parent);
                if (parentGui == null) continue;
                this.drawConnection(parentGui, scrollX, scrollY, drawInside);
            }
        }
        for (GuiBetterAdvancement guiBetterAdvancement : this.children) {
            guiBetterAdvancement.drawConnectivity(scrollX, scrollY, drawInside);
        }
    }

    public void drawConnection(GuiBetterAdvancement parent, int scrollX, int scrollY, boolean drawInside) {
        int innerLineColor = this.advancementProgress != null && this.advancementProgress.func_192105_a() ? this.betterDisplayInfo.getCompletedLineColor() : this.betterDisplayInfo.getUnCompletedLineColor();
        int borderLineColor = -16777216;
        if (this.betterDisplayInfo.drawDirectLines().booleanValue()) {
            boolean perpendicular;
            double x1 = scrollX + this.x + 13 + 3;
            double y1 = scrollY + this.y + 13;
            double x2 = scrollX + parent.x + 13 + 3;
            double y2 = scrollY + parent.y + 13;
            boolean bl = perpendicular = x1 == x2 || y1 == y2;
            if (!perpendicular) {
                double width;
                switch (this.screenScale) {
                    case 1: {
                        width = drawInside ? 1.5 : 0.5;
                        break;
                    }
                    case 2: {
                        width = drawInside ? 2.25 : 0.75;
                        break;
                    }
                    case 3: {
                        width = drawInside ? 2.0 : 0.6666666666666667;
                        break;
                    }
                    case 4: {
                        width = drawInside ? 2.125 : 0.625;
                        break;
                    }
                    default: {
                        double d = width = drawInside ? 3.0 : 1.0;
                    }
                }
                if (drawInside) {
                    RenderUtil.drawRect(x1 - 0.75, y1 - 0.75, x2 - 0.75, y2 - 0.75, width, borderLineColor);
                } else {
                    RenderUtil.drawRect(x1, y1, x2, y2, width, innerLineColor);
                }
            } else {
                double width;
                double d = width = drawInside ? 3.0 : 1.0;
                if (drawInside) {
                    RenderUtil.drawRect(x1 - 1.0, y1 - 1.0, x2 - 1.0, y2 - 1.0, width, borderLineColor);
                } else {
                    RenderUtil.drawRect(x1, y1, x2, y2, width, innerLineColor);
                }
            }
        } else {
            int startX = scrollX + parent.x + 13;
            int endXHalf = scrollX + parent.x + 26 + 6;
            int startY = scrollY + parent.y + 13;
            int endX = scrollX + this.x + 13;
            int endY = scrollY + this.y + 13;
            if (drawInside) {
                this.func_73730_a(endXHalf, startX, startY - 1, borderLineColor);
                this.func_73730_a(endXHalf + 1, startX, startY, borderLineColor);
                this.func_73730_a(endXHalf, startX, startY + 1, borderLineColor);
                this.func_73730_a(endX, endXHalf - 1, endY - 1, borderLineColor);
                this.func_73730_a(endX, endXHalf - 1, endY, borderLineColor);
                this.func_73730_a(endX, endXHalf - 1, endY + 1, borderLineColor);
                this.func_73728_b(endXHalf - 1, endY, startY, borderLineColor);
                this.func_73728_b(endXHalf + 1, endY, startY, borderLineColor);
            } else {
                this.func_73730_a(endXHalf, startX, startY, innerLineColor);
                this.func_73730_a(endX, endXHalf, endY, innerLineColor);
                this.func_73728_b(endXHalf, endY, startY, innerLineColor);
            }
        }
    }

    public void draw(int scrollX, int scrollY) {
        if (!this.displayInfo.func_193224_j() || this.advancementProgress != null && this.advancementProgress.func_192105_a()) {
            float f = this.advancementProgress == null ? 0.0f : this.advancementProgress.func_192103_c();
            AdvancementState advancementState = f >= 1.0f ? AdvancementState.OBTAINED : AdvancementState.UNOBTAINED;
            this.minecraft.func_110434_K().func_110577_a(Resources.Gui.WIDGETS);
            RenderUtil.setColor(this.betterDisplayInfo.getIconColor(advancementState));
            GlStateManager.func_179147_l();
            this.func_73729_b(scrollX + this.x + 3, scrollY + this.y, this.displayInfo.func_192291_d().func_192309_b(), 128 + 26 * this.betterDisplayInfo.getIconYMultiplier(advancementState), 26, 26);
            RenderHelper.func_74520_c();
            this.minecraft.func_175599_af().func_184391_a(null, this.displayInfo.func_192298_b(), scrollX + this.x + 8, scrollY + this.y + 5);
        }
        for (GuiBetterAdvancement guiBetterAdvancement : this.children) {
            guiBetterAdvancement.draw(scrollX, scrollY);
        }
    }

    public void getAdvancementProgress(AdvancementProgress advancementProgressIn) {
        this.advancementProgress = advancementProgressIn;
        this.refreshHover();
    }

    public void addGuiAdvancement(GuiBetterAdvancement guiBetterAdvancement) {
        this.children.add(guiBetterAdvancement);
    }

    public void drawHover(int scrollX, int scrollY, float fade, int left, int top) {
        AdvancementState stateIcon;
        AdvancementState stateTitleRight;
        AdvancementState stateTitleLeft;
        int i;
        this.refreshHover();
        boolean drawLeft = left + scrollX + this.x + this.width + 26 >= this.guiBetterAdvancementTab.getScreen().internalWidth;
        String s = this.advancementProgress == null ? null : this.advancementProgress.func_193126_d();
        int n = i = s == null ? 0 : this.minecraft.field_71466_p.func_78256_a(s);
        boolean drawTop = !CriterionGrid.requiresShift || Keyboard.isKeyDown((int)42) || Keyboard.isKeyDown((int)54) ? (this.criterionGrid.height < this.guiBetterAdvancementTab.getScreen().field_146295_m ? top + scrollY + this.y + this.description.size() * this.minecraft.field_71466_p.field_78288_b + this.criterionGrid.height + 50 >= this.guiBetterAdvancementTab.getScreen().field_146295_m : false) : top + scrollY + this.y + this.description.size() * this.minecraft.field_71466_p.field_78288_b + 50 >= this.guiBetterAdvancementTab.getScreen().field_146295_m;
        float percentageObtained = this.advancementProgress == null ? 0.0f : this.advancementProgress.func_192103_c();
        int j = MathHelper.func_76141_d((float)(percentageObtained * (float)this.width));
        if (percentageObtained >= 1.0f) {
            j = this.width / 2;
            stateTitleLeft = AdvancementState.OBTAINED;
            stateTitleRight = AdvancementState.OBTAINED;
            stateIcon = AdvancementState.OBTAINED;
        } else if (j < 2) {
            j = this.width / 2;
            stateTitleLeft = AdvancementState.UNOBTAINED;
            stateTitleRight = AdvancementState.UNOBTAINED;
            stateIcon = AdvancementState.UNOBTAINED;
        } else if (j > this.width - 2) {
            j = this.width / 2;
            stateTitleLeft = AdvancementState.OBTAINED;
            stateTitleRight = AdvancementState.OBTAINED;
            stateIcon = AdvancementState.UNOBTAINED;
        } else {
            stateTitleLeft = AdvancementState.OBTAINED;
            stateTitleRight = AdvancementState.UNOBTAINED;
            stateIcon = AdvancementState.UNOBTAINED;
        }
        int k = this.width - j;
        this.minecraft.func_110434_K().func_110577_a(Resources.Gui.WIDGETS);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179147_l();
        int drawY = scrollY + this.y;
        int drawX = drawLeft ? scrollX + this.x - this.width + 26 + 6 : scrollX + this.x;
        int boxHeight = !CriterionGrid.requiresShift || Keyboard.isKeyDown((int)42) || Keyboard.isKeyDown((int)54) ? 32 + this.description.size() * this.minecraft.field_71466_p.field_78288_b + this.criterionGrid.height : 32 + this.description.size() * this.minecraft.field_71466_p.field_78288_b;
        if (!this.description.isEmpty()) {
            if (drawTop) {
                this.render9Sprite(drawX, drawY + 26 - boxHeight, this.width, boxHeight, 10, 256, 26, 0, 52);
            } else {
                this.render9Sprite(drawX, drawY, this.width, boxHeight, 10, 256, 26, 0, 52);
            }
        }
        RenderUtil.setColor(this.betterDisplayInfo.getTitleColor(stateTitleLeft));
        int left_side = Math.min(j, 240);
        this.func_73729_b(drawX, drawY, 0, this.betterDisplayInfo.getTitleYMultiplier(stateTitleLeft) * 26, left_side, 26);
        if (left_side < j) {
            this.func_73729_b(drawX + left_side, drawY, 16, this.betterDisplayInfo.getTitleYMultiplier(stateTitleLeft) * 26, j - left_side, 26);
        }
        RenderUtil.setColor(this.betterDisplayInfo.getTitleColor(stateTitleRight));
        int right_side = Math.min(k, 240);
        this.func_73729_b(drawX + j, drawY, 256 - right_side, this.betterDisplayInfo.getTitleYMultiplier(stateTitleRight) * 26, right_side, 26);
        if (right_side < k) {
            this.func_73729_b(drawX + j + right_side, drawY, 256 - k + right_side, this.betterDisplayInfo.getTitleYMultiplier(stateTitleRight) * 26, k - right_side, 26);
        }
        RenderUtil.setColor(this.betterDisplayInfo.getIconColor(stateIcon));
        this.func_73729_b(scrollX + this.x + 3, scrollY + this.y, this.displayInfo.func_192291_d().func_192309_b(), 128 + 26 * this.betterDisplayInfo.getIconYMultiplier(stateIcon), 26, 26);
        if (drawLeft) {
            this.minecraft.field_71466_p.func_175065_a(this.title, (float)(drawX + 5), (float)(scrollY + this.y + 9), -1, true);
            if (s != null) {
                this.minecraft.field_71466_p.func_175065_a(s, (float)(scrollX + this.x - i), (float)(scrollY + this.y + 9), -1, true);
            }
        } else {
            this.minecraft.field_71466_p.func_175065_a(this.title, (float)(scrollX + this.x + 32), (float)(scrollY + this.y + 9), -1, true);
            if (s != null) {
                this.minecraft.field_71466_p.func_175065_a(s, (float)(scrollX + this.x + this.width - i - 5), (float)(scrollY + this.y + 9), -1, true);
            }
        }
        int yOffset = drawTop ? drawY + 26 - boxHeight + 7 : scrollY + this.y + 9 + 17;
        for (int k1 = 0; k1 < this.description.size(); ++k1) {
            this.minecraft.field_71466_p.func_175065_a(this.description.get(k1), (float)(drawX + 5), (float)(yOffset + k1 * this.minecraft.field_71466_p.field_78288_b), -5592406, false);
        }
        if (this.criterionGrid != null && !CriterionGrid.requiresShift || Keyboard.isKeyDown((int)42) || Keyboard.isKeyDown((int)54)) {
            int xOffset = drawX + 5;
            yOffset += this.description.size() * this.minecraft.field_71466_p.field_78288_b;
            for (int colIndex = 0; colIndex < this.criterionGrid.columns.size(); ++colIndex) {
                CriterionGrid.Column col = this.criterionGrid.columns.get(colIndex);
                for (int rowIndex = 0; rowIndex < col.cells.size(); ++rowIndex) {
                    this.minecraft.field_71466_p.func_175065_a(col.cells.get(rowIndex), (float)xOffset, (float)(yOffset + rowIndex * this.minecraft.field_71466_p.field_78288_b), -5592406, false);
                }
                xOffset += col.width;
            }
        }
        RenderHelper.func_74520_c();
        this.minecraft.func_175599_af().func_184391_a(null, this.displayInfo.func_192298_b(), scrollX + this.x + 8, scrollY + this.y + 5);
    }

    protected void render9Sprite(int x, int y, int width, int height, int textureHeight, int textureWidth, int textureDistance, int textureX, int textureY) {
        this.func_73729_b(x, y, textureX, textureY, textureHeight, textureHeight);
        RenderUtil.renderRepeating(this, x + textureHeight, y, width - textureHeight - textureHeight, textureHeight, textureX + textureHeight, textureY, textureWidth - textureHeight - textureHeight, textureDistance);
        this.func_73729_b(x + width - textureHeight, y, textureX + textureWidth - textureHeight, textureY, textureHeight, textureHeight);
        this.func_73729_b(x, y + height - textureHeight, textureX, textureY + textureDistance - textureHeight, textureHeight, textureHeight);
        RenderUtil.renderRepeating(this, x + textureHeight, y + height - textureHeight, width - textureHeight - textureHeight, textureHeight, textureX + textureHeight, textureY + textureDistance - textureHeight, textureWidth - textureHeight - textureHeight, textureDistance);
        this.func_73729_b(x + width - textureHeight, y + height - textureHeight, textureX + textureWidth - textureHeight, textureY + textureDistance - textureHeight, textureHeight, textureHeight);
        RenderUtil.renderRepeating(this, x, y + textureHeight, textureHeight, height - textureHeight - textureHeight, textureX, textureY + textureHeight, textureWidth, textureDistance - textureHeight - textureHeight);
        RenderUtil.renderRepeating(this, x + textureHeight, y + textureHeight, width - textureHeight - textureHeight, height - textureHeight - textureHeight, textureX + textureHeight, textureY + textureHeight, textureWidth - textureHeight - textureHeight, textureDistance - textureHeight - textureHeight);
        RenderUtil.renderRepeating(this, x + width - textureHeight, y + textureHeight, textureHeight, height - textureHeight - textureHeight, textureX + textureWidth - textureHeight, textureY + textureHeight, textureWidth, textureDistance - textureHeight - textureHeight);
    }

    public boolean isMouseOver(int scrollX, int scrollY, int mouseX, int mouseY) {
        if (!this.displayInfo.func_193224_j() || this.advancementProgress != null && this.advancementProgress.func_192105_a()) {
            int left = scrollX + this.x;
            int right = left + 26;
            int top = scrollY + this.y;
            int bottom = top + 26;
            return mouseX >= left && mouseX <= right && mouseY >= top && mouseY <= bottom;
        }
        return false;
    }

    public void attachToParent() {
        if (this.parent == null && this.advancement.func_192070_b() != null) {
            this.parent = this.getFirstVisibleParent(this.advancement);
            if (this.parent != null) {
                this.parent.addGuiAdvancement(this);
            }
        }
    }

    public int getY() {
        return this.y;
    }

    public int getX() {
        return this.x;
    }

    public Advancement getAdvancement() {
        return this.advancement;
    }
}

