/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.world;

import com.brandon3055.draconicevolution.utils.LogHelper;
import com.brandon3055.draconicevolution.world.DEWorldGenHandler;
import gnu.trove.map.hash.TIntObjectHashMap;
import java.util.ArrayDeque;
import java.util.Random;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.World;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.relauncher.Side;

public class WorldTickHandler {
    public static TIntObjectHashMap<ArrayDeque<ChunkPos>> chunksToGen = new TIntObjectHashMap();
    private int tick = 0;

    @SubscribeEvent
    public void tickEnd(TickEvent.WorldTickEvent event) {
        if (event.side != Side.SERVER) {
            return;
        }
        World world = event.world;
        int dimension = event.world.field_73011_w.getDimension();
        if (event.phase == TickEvent.Phase.END) {
            ArrayDeque chunks = (ArrayDeque)chunksToGen.get(dimension);
            if (chunks != null && chunks.size() > 0) {
                ChunkPos chunkPos = (ChunkPos)chunks.pollFirst();
                if (this.tick++ % 20 == 0) {
                    LogHelper.dev("Retroactively adding ore to {dim: " + dimension + ", chunkPos: " + chunkPos.toString() + ", chunksToGo: " + chunks.size() + "}");
                }
                long worldSeed = world.func_72905_C();
                Random rand = new Random(worldSeed);
                long xSeed = rand.nextLong() >> 3;
                long zSeed = rand.nextLong() >> 3;
                rand.setSeed(xSeed * (long)chunkPos.field_77276_a + zSeed * (long)chunkPos.field_77275_b ^ worldSeed);
                DEWorldGenHandler.instance.addOreGen(rand, chunkPos.field_77276_a, chunkPos.field_77275_b, world);
                DEWorldGenHandler.instance.retroGenComplete(dimension, chunkPos.field_77276_a, chunkPos.field_77275_b);
                chunksToGen.put(dimension, (Object)chunks);
            } else if (chunks != null) {
                chunksToGen.remove(dimension);
            }
        }
    }

    @SubscribeEvent
    public void worldUnload(WorldEvent.Unload event) {
        if (chunksToGen.containsKey(event.getWorld().field_73011_w.getDimension())) {
            ((ArrayDeque)chunksToGen.get(event.getWorld().field_73011_w.getDimension())).clear();
        }
    }
}

