/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.entity;

import com.brandon3055.brandonscore.inventory.InventoryDynamic;
import com.brandon3055.draconicevolution.DraconicEvolution;
import com.brandon3055.draconicevolution.network.PacketLootSync;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.entity.Entity;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class EntityLootCore
extends Entity {
    private InventoryDynamic inventory = new InventoryDynamic();
    public double rotX = 0.0;
    public double rotY = 0.0;
    public int timeOffset = 0;
    public int pickupDellay = 0;
    public Map<ItemStack, Integer> displayMap = new HashMap<ItemStack, Integer>();
    public boolean isLooking = false;
    public float lookAnimation = 0.0f;
    private int despawnTimer = 0;
    private int lifespan = 6000;
    private boolean canDespawn = true;
    private List<EntityPlayerMP> trackingPlayers = new ArrayList<EntityPlayerMP>();

    public EntityLootCore(World world) {
        super(world);
        this.func_70105_a(0.3f, 0.3f);
        this.rotX = world.field_73012_v.nextDouble();
        this.rotY = world.field_73012_v.nextDouble();
        this.timeOffset = world.field_73012_v.nextInt(1000);
    }

    public EntityLootCore(World world, InventoryDynamic inventory) {
        super(world);
        this.inventory = inventory;
        this.updateStored();
    }

    public boolean func_70067_L() {
        return true;
    }

    protected void func_70088_a() {
    }

    public void func_70071_h_() {
        if (this.field_70170_p.field_72995_K) {
            if (this.isLooking && this.lookAnimation < 1.0f) {
                this.lookAnimation += 0.05f;
            } else if (!this.isLooking && this.lookAnimation > 0.0f) {
                this.lookAnimation -= 0.05f;
            }
        } else if (this.canDespawn && this.despawnTimer++ > this.lifespan) {
            this.func_70106_y();
        }
        super.func_70071_h_();
    }

    public void func_70030_z() {
        this.field_70169_q = this.field_70165_t;
        this.field_70167_r = this.field_70163_u;
        this.field_70166_s = this.field_70161_v;
        if (!this.func_189652_ae()) {
            this.field_70181_x -= (double)0.04f;
        }
        this.field_70145_X = this.func_145771_j(this.field_70165_t, (this.func_174813_aQ().field_72338_b + this.func_174813_aQ().field_72337_e) / 2.0, this.field_70161_v);
        this.func_70091_d(MoverType.SELF, this.field_70159_w, this.field_70181_x, this.field_70179_y);
        float f = 0.98f;
        if (this.field_70122_E) {
            f = this.field_70170_p.func_180495_p((BlockPos)new BlockPos((int)MathHelper.func_76128_c((double)this.field_70165_t), (int)(MathHelper.func_76128_c((double)this.func_174813_aQ().field_72338_b) - 1), (int)MathHelper.func_76128_c((double)this.field_70161_v))).func_177230_c().field_149765_K * 0.98f;
        }
        this.field_70159_w *= (double)f;
        this.field_70181_x *= (double)0.98f;
        this.field_70179_y *= (double)f;
        super.func_70030_z();
    }

    public void func_70100_b_(EntityPlayer player) {
        if (this.field_70170_p.field_72995_K) {
            return;
        }
        this.despawnTimer = 0;
        if (this.pickupDellay > 0) {
            --this.pickupDellay;
            return;
        }
        if (this.inventory.xp > 0) {
            player.func_71023_q(this.inventory.xp);
            this.inventory.xp = 0;
        }
        boolean inserted = false;
        for (int i = this.inventory.func_70302_i_() - 1; i >= 0; --i) {
            ItemStack stack = this.inventory.func_70301_a(i);
            if (stack.func_190926_b()) continue;
            int start = stack.func_190916_E();
            EntityItem item = new EntityItem(this.field_70170_p, 0.0, 0.0, 0.0, stack);
            item.func_70107_b(this.field_70165_t, this.field_70163_u, this.field_70161_v);
            int result = ForgeEventFactory.onItemPickup((EntityItem)item, (EntityPlayer)player);
            if (result != 1 && stack.func_190916_E() > 0 && !player.field_71071_by.func_70441_a(stack)) continue;
            if (item.field_70128_L) {
                stack.func_190920_e(0);
            }
            if (stack.func_190916_E() == 0) {
                this.inventory.func_70299_a(i, ItemStack.field_190927_a);
            } else {
                this.inventory.func_70299_a(i, stack);
            }
            if (stack.func_190916_E() >= start) continue;
            inserted = true;
        }
        if (inserted) {
            this.field_70170_p.func_184148_a(null, player.field_70165_t, player.field_70163_u, player.field_70161_v, SoundEvents.field_187638_cR, SoundCategory.PLAYERS, 0.2f, ((this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.7f + 1.0f) * 2.0f);
            this.updateStored();
        }
        this.pickupDellay = 10;
        if (this.inventory.func_70302_i_() == 1 && this.inventory.func_70301_a(0).func_190926_b()) {
            this.func_70106_y();
        }
    }

    private void updateStored() {
        if (this.field_70170_p.field_72995_K) {
            return;
        }
        this.displayMap = new HashMap<ItemStack, Integer>();
        for (int i = 0; i < this.inventory.func_70302_i_(); ++i) {
            ItemStack insert = this.inventory.func_70301_a(i);
            if (insert.func_190926_b()) continue;
            boolean added = false;
            for (ItemStack stack : this.displayMap.keySet()) {
                if (!insert.func_77969_a(stack) || !ItemStack.func_77970_a((ItemStack)insert, (ItemStack)stack)) continue;
                added = true;
                this.displayMap.put(stack, this.displayMap.get(stack) + insert.func_190916_E());
                break;
            }
            if (added) continue;
            this.displayMap.put(insert, insert.func_190916_E());
        }
        for (EntityPlayerMP playerMP : this.trackingPlayers) {
            DraconicEvolution.network.sendTo((IMessage)new PacketLootSync(this.func_145782_y(), this.displayMap), playerMP);
        }
    }

    public void func_184178_b(EntityPlayerMP player) {
        this.trackingPlayers.add(player);
        DraconicEvolution.network.sendTo((IMessage)new PacketLootSync(this.func_145782_y(), this.displayMap), player);
        super.func_184178_b(player);
    }

    public void func_184203_c(EntityPlayerMP player) {
        this.trackingPlayers.remove(player);
        super.func_184203_c(player);
    }

    protected void func_70037_a(NBTTagCompound compound) {
        this.inventory.readFromNBT(compound);
        this.updateStored();
        this.despawnTimer = compound.func_74762_e("DespawnTimer");
        this.lifespan = compound.func_74762_e("Lifespan");
        this.canDespawn = compound.func_74767_n("CanDespawn");
    }

    protected void func_70014_b(NBTTagCompound compound) {
        this.inventory.writeToNBT(compound);
        compound.func_74768_a("DespawnTimer", this.despawnTimer);
        compound.func_74768_a("Lifespan", this.lifespan);
        compound.func_74757_a("CanDespawn", this.canDespawn);
    }
}

