/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.client.render.particle;

import com.brandon3055.brandonscore.client.particle.BCParticle;
import com.brandon3055.brandonscore.client.particle.IBCParticleFactory;
import com.brandon3055.brandonscore.lib.Vec3D;
import com.brandon3055.brandonscore.utils.BCProfiler;
import com.brandon3055.brandonscore.utils.Utils;
import com.brandon3055.draconicevolution.client.handler.ClientEventHandler;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.entity.Entity;
import net.minecraft.util.EnumFacing;
import net.minecraft.world.World;

public class ParticleEnergyCoreFX
extends BCParticle {
    public Vec3D targetPos;
    public boolean toCore = false;
    public int startRotation = 0;
    private EnumFacing.Axis direction;
    public boolean isLargeStabilizer = false;

    public ParticleEnergyCoreFX(World worldIn, Vec3D pos) {
        super(worldIn, pos);
    }

    public ParticleEnergyCoreFX(World worldIn, Vec3D pos, Vec3D targetPos) {
        super(worldIn, pos, new Vec3D(0.0, 0.0, 0.0));
        this.targetPos = targetPos;
        this.field_70547_e = 50;
        this.field_70544_f = 1.0f;
        this.field_94055_c = 1;
        Vec3D dir = Vec3D.getDirectionVec((Vec3D)pos, (Vec3D)targetPos);
        this.direction = EnumFacing.func_176737_a((float)((float)dir.x), (float)((float)dir.y), (float)((float)dir.z)).func_176740_k();
    }

    public boolean func_187111_c() {
        return true;
    }

    public void func_189213_a() {
        BCProfiler.TICK.start("core_fx_update");
        this.field_187123_c = this.field_187126_f;
        this.field_187124_d = this.field_187127_g;
        this.field_187125_e = this.field_187128_h;
        Vec3D tPos = this.targetPos.copy();
        this.field_94054_b = this.field_187136_p.nextInt(5);
        if (this.toCore) {
            double d;
            double rotation = ClientEventHandler.elapsedTicks;
            double offsetX = Math.sin(rotation / 180.0 * Math.PI + (double)this.startRotation / 100.0);
            double offsetY = Math.cos(rotation / 180.0 * Math.PI + (double)this.startRotation / 100.0);
            double d2 = d = this.isLargeStabilizer ? 1.8 : 0.2;
            if (this.direction == EnumFacing.Axis.Z) {
                tPos.add(offsetX * d, offsetY * d, 0.0);
            } else if (this.direction == EnumFacing.Axis.Y) {
                tPos.add(offsetX * d, 0.0, offsetY * d);
            } else if (this.direction == EnumFacing.Axis.X) {
                tPos.add(0.0, offsetY * d, offsetX * d);
            }
        }
        Vec3D dir = Vec3D.getDirectionVec((Vec3D)new Vec3D(this.field_187126_f, this.field_187127_g, this.field_187128_h), (Vec3D)tPos);
        double speed = this.toCore ? 0.5 : 0.25;
        this.field_187129_i = dir.x * speed;
        this.field_187130_j = dir.y * speed;
        this.field_187131_k = dir.z * speed;
        this.moveEntityNoClip(this.field_187129_i, this.field_187130_j, this.field_187131_k);
        if (this.field_70546_d++ > this.field_70547_e || Utils.getDistanceAtoB((double)this.field_187126_f, (double)this.field_187127_g, (double)this.field_187128_h, (double)tPos.x, (double)tPos.y, (double)tPos.z) < 0.2) {
            this.func_187112_i();
        }
        BCProfiler.TICK.stop();
    }

    public void func_180434_a(BufferBuilder vertexbuffer, Entity entityIn, float partialTicks, float rotationX, float rotationZ, float rotationYZ, float rotationXY, float rotationXZ) {
        BCProfiler.RENDER.start("core_fx");
        float minU = (float)this.field_94054_b / 8.0f;
        float maxU = minU + 0.125f;
        float minV = (float)this.field_94055_c / 8.0f;
        float maxV = minV + 0.125f;
        float scale = 0.1f * this.field_70544_f;
        float renderX = (float)(this.field_187123_c + (this.field_187126_f - this.field_187123_c) * (double)partialTicks - field_70556_an);
        float renderY = (float)(this.field_187124_d + (this.field_187127_g - this.field_187124_d) * (double)partialTicks - field_70554_ao);
        float renderZ = (float)(this.field_187125_e + (this.field_187128_h - this.field_187125_e) * (double)partialTicks - field_70555_ap);
        int brightnessForRender = this.func_189214_a(partialTicks);
        int j = brightnessForRender >> 16 & 0xFFFF;
        int k = brightnessForRender & 0xFFFF;
        vertexbuffer.func_181662_b((double)(renderX - rotationX * scale - rotationXY * scale), (double)(renderY - rotationZ * scale), (double)(renderZ - rotationYZ * scale - rotationXZ * scale)).func_187315_a((double)maxU, (double)maxV).func_181666_a(this.field_70552_h, this.field_70553_i, this.field_70551_j, this.field_82339_as).func_187314_a(j, k).func_181675_d();
        vertexbuffer.func_181662_b((double)(renderX - rotationX * scale + rotationXY * scale), (double)(renderY + rotationZ * scale), (double)(renderZ - rotationYZ * scale + rotationXZ * scale)).func_187315_a((double)maxU, (double)minV).func_181666_a(this.field_70552_h, this.field_70553_i, this.field_70551_j, this.field_82339_as).func_187314_a(j, k).func_181675_d();
        vertexbuffer.func_181662_b((double)(renderX + rotationX * scale + rotationXY * scale), (double)(renderY + rotationZ * scale), (double)(renderZ + rotationYZ * scale + rotationXZ * scale)).func_187315_a((double)minU, (double)minV).func_181666_a(this.field_70552_h, this.field_70553_i, this.field_70551_j, this.field_82339_as).func_187314_a(j, k).func_181675_d();
        vertexbuffer.func_181662_b((double)(renderX + rotationX * scale - rotationXY * scale), (double)(renderY - rotationZ * scale), (double)(renderZ + rotationYZ * scale - rotationXZ * scale)).func_187315_a((double)minU, (double)maxV).func_181666_a(this.field_70552_h, this.field_70553_i, this.field_70551_j, this.field_82339_as).func_187314_a(j, k).func_181675_d();
        BCProfiler.RENDER.stop();
    }

    public static class Factory
    implements IBCParticleFactory {
        public Particle getEntityFX(int particleID, World world, Vec3D pos, Vec3D targetPos, int ... args) {
            ParticleEnergyCoreFX particle = new ParticleEnergyCoreFX(world, pos, targetPos);
            particle.toCore = args.length >= 1 && args[0] == 1;
            particle.startRotation = args.length >= 2 ? args[1] : 0;
            particle.isLargeStabilizer = args.length >= 3 && args[2] == 1;
            particle.func_70541_f(particle.isLargeStabilizer ? 2.0f : 1.0f);
            return particle;
        }
    }
}

