/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.client.render.entity;

import com.brandon3055.draconicevolution.client.model.ModelChaosGuardian;
import com.brandon3055.draconicevolution.client.render.entity.LayerCHaosGuardianDeath;
import com.brandon3055.draconicevolution.entity.EntityChaosGuardian;
import com.brandon3055.draconicevolution.helpers.ResourceHelperDE;
import net.minecraft.client.model.ModelBase;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.entity.RenderLiving;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.client.renderer.entity.layers.LayerRenderer;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public class RenderChaosGuardian
extends RenderLiving<EntityChaosGuardian> {
    protected ModelChaosGuardian modelDragon;

    public RenderChaosGuardian(RenderManager manager) {
        super(manager, (ModelBase)new ModelChaosGuardian(0.0f), 0.5f);
        this.modelDragon = (ModelChaosGuardian)this.field_77045_g;
        this.func_177094_a(new LayerChaosGuardianEyes(this));
        this.func_177094_a(new LayerCHaosGuardianDeath());
    }

    protected void applyRotations(EntityChaosGuardian entityLiving, float p_77043_2_, float p_77043_3_, float partialTicks) {
        float f3 = (float)entityLiving.getMovementOffsets(7, partialTicks)[0];
        float f4 = (float)(entityLiving.getMovementOffsets(5, partialTicks)[1] - entityLiving.getMovementOffsets(10, partialTicks)[1]);
        GL11.glRotatef((float)(-f3), (float)0.0f, (float)1.0f, (float)0.0f);
        GL11.glRotatef((float)(f4 * 10.0f), (float)1.0f, (float)0.0f, (float)0.0f);
        GL11.glTranslatef((float)0.0f, (float)0.0f, (float)1.0f);
        if (entityLiving.field_70725_aQ > 0) {
            float f5 = ((float)entityLiving.field_70725_aQ + partialTicks - 1.0f) / 20.0f * 1.6f;
            if ((f5 = MathHelper.func_76129_c((float)f5)) > 1.0f) {
                f5 = 1.0f;
            }
            GL11.glRotatef((float)(f5 * this.func_77037_a((EntityLivingBase)entityLiving)), (float)0.0f, (float)0.0f, (float)1.0f);
        }
    }

    protected void renderModel(EntityChaosGuardian chaosGuardian, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch, float scaleFactor) {
        if (chaosGuardian.deathTicks > 0) {
            float f6 = (float)chaosGuardian.deathTicks / 200.0f;
            GL11.glDepthFunc((int)515);
            GL11.glEnable((int)3008);
            GL11.glAlphaFunc((int)516, (float)f6);
            this.func_110776_a(ResourceHelperDE.getResourceRAW("textures/entity/enderdragon/dragon_exploding.png"));
            this.field_77045_g.func_78088_a((Entity)chaosGuardian, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch, scaleFactor);
            GL11.glAlphaFunc((int)516, (float)0.1f);
            GL11.glDepthFunc((int)514);
        }
        this.func_180548_c((Entity)chaosGuardian);
        this.field_77045_g.func_78088_a((Entity)chaosGuardian, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch, scaleFactor);
        if (chaosGuardian.field_70737_aN > 0) {
            GL11.glDepthFunc((int)514);
            GL11.glDisable((int)3553);
            GL11.glEnable((int)3042);
            GL11.glBlendFunc((int)770, (int)771);
            GL11.glColor4f((float)1.0f, (float)0.0f, (float)0.0f, (float)0.5f);
            this.field_77045_g.func_78088_a((Entity)chaosGuardian, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch, scaleFactor);
            GL11.glEnable((int)3553);
            GL11.glDisable((int)3042);
            GL11.glDepthFunc((int)515);
        }
    }

    public void doRender(EntityChaosGuardian chaosGuardian, double x, double y, double z, float entityYaw, float partialTicks) {
        super.func_76986_a((EntityLiving)chaosGuardian, x, y, z, entityYaw, partialTicks);
        BlockPos pos = chaosGuardian.getCrystalPos();
        if (pos != null) {
            float innerRotation = chaosGuardian.healingChaosCrystal != null ? (float)chaosGuardian.healingChaosCrystal.innerRotation + partialTicks : 0.0f;
            float bob = MathHelper.func_76126_a((float)(innerRotation * 0.2f)) / 2.0f + 0.5f;
            bob = (bob * bob + bob) * 0.2f;
            float renderX = (float)((double)pos.func_177958_n() + 0.5 - chaosGuardian.field_70165_t - (chaosGuardian.field_70169_q - chaosGuardian.field_70165_t) * (double)(1.0f - partialTicks));
            float renderY = (float)((double)bob + (double)pos.func_177956_o() - 1.0 - chaosGuardian.field_70163_u - (chaosGuardian.field_70167_r - chaosGuardian.field_70163_u) * (double)(1.0f - partialTicks));
            float renderZ = (float)((double)pos.func_177952_p() + 0.5 - chaosGuardian.field_70161_v - (chaosGuardian.field_70166_s - chaosGuardian.field_70161_v) * (double)(1.0f - partialTicks));
            float f7 = MathHelper.func_76129_c((float)(renderX * renderX + renderZ * renderZ));
            float f8 = MathHelper.func_76129_c((float)(renderX * renderX + renderY * renderY + renderZ * renderZ));
            GL11.glPushMatrix();
            GL11.glTranslatef((float)((float)x), (float)((float)y + 2.0f), (float)((float)z));
            GL11.glRotatef((float)((float)(-Math.atan2(renderZ, renderX)) * 180.0f / (float)Math.PI - 90.0f), (float)0.0f, (float)1.0f, (float)0.0f);
            GL11.glRotatef((float)((float)(-Math.atan2(f7, renderY)) * 180.0f / (float)Math.PI - 90.0f), (float)1.0f, (float)0.0f, (float)0.0f);
            Tessellator tessellator = Tessellator.func_178181_a();
            BufferBuilder buffer = tessellator.func_178180_c();
            RenderHelper.func_74518_a();
            GL11.glDisable((int)2884);
            this.func_110776_a(ResourceHelperDE.getResourceRAW("textures/entity/endercrystal/endercrystal_beam.png"));
            GL11.glShadeModel((int)7425);
            float f9 = 0.0f - ((float)chaosGuardian.field_70173_aa + partialTicks) * 0.01f;
            float f10 = MathHelper.func_76129_c((float)(renderX * renderX + renderY * renderY + renderZ * renderZ)) / 32.0f - ((float)chaosGuardian.field_70173_aa + partialTicks) * 0.01f;
            buffer.func_181668_a(5, DefaultVertexFormats.field_181709_i);
            int b0 = 8;
            for (int i = 0; i <= b0; ++i) {
                float f11 = MathHelper.func_76126_a((float)((float)(i % b0) * (float)Math.PI * 2.0f / (float)b0)) * 0.75f;
                float f12 = MathHelper.func_76134_b((float)((float)(i % b0) * (float)Math.PI * 2.0f / (float)b0)) * 0.75f;
                float f13 = (float)(i % b0) * 1.0f / (float)b0;
                buffer.func_181662_b((double)(f11 * 0.2f), (double)(f12 * 0.2f), 0.0).func_187315_a((double)f13, (double)f10).func_181666_a(0.0f, 0.0f, 0.0f, 1.0f).func_181675_d();
                buffer.func_181662_b((double)f11, (double)f12, (double)f8).func_187315_a((double)f13, (double)f9).func_181666_a(1.0f, 0.0f, 0.0f, 1.0f).func_181675_d();
            }
            tessellator.func_78381_a();
            GL11.glEnable((int)2884);
            GL11.glShadeModel((int)7424);
            RenderHelper.func_74519_b();
            GL11.glPopMatrix();
        }
    }

    protected ResourceLocation getEntityTexture(EntityChaosGuardian entity) {
        return ResourceHelperDE.getResource("textures/entity/chaos_guardian.png");
    }

    public static class LayerChaosGuardianEyes
    implements LayerRenderer<EntityChaosGuardian> {
        private static final ResourceLocation TEXTURE = new ResourceLocation("textures/entity/enderdragon/dragon_eyes.png");
        private final RenderChaosGuardian dragonRenderer;

        public LayerChaosGuardianEyes(RenderChaosGuardian dragonRendererIn) {
            this.dragonRenderer = dragonRendererIn;
        }

        public void doRenderLayer(EntityChaosGuardian entitylivingbaseIn, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch, float scale) {
            this.dragonRenderer.func_110776_a(TEXTURE);
            GlStateManager.func_179147_l();
            GlStateManager.func_179118_c();
            GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE);
            GlStateManager.func_179140_f();
            GlStateManager.func_179143_c((int)514);
            int i = 61680;
            int j = i % 65536;
            int k = i / 65536;
            OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)j, (float)k);
            GlStateManager.func_179145_e();
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            this.dragonRenderer.func_177087_b().func_78088_a((Entity)entitylivingbaseIn, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch, scale);
            this.dragonRenderer.func_177105_a(entitylivingbaseIn);
            GlStateManager.func_179084_k();
            GlStateManager.func_179141_d();
            GlStateManager.func_179143_c((int)515);
        }

        public boolean func_177142_b() {
            return false;
        }
    }
}

